/*
 * Decompiled with CFR 0.152.
 */
package net.sparkworks.cargo.client;

import java.util.Collections;
import java.util.Objects;
import net.sparkworks.cargo.client.config.SparkworksResponseErrorHandler;
import net.sparkworks.cargo.common.CargoRoutes;
import org.springframework.http.HttpHeaders;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordResourceDetails;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public abstract class APIBaseClient
implements CargoRoutes {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String AUTH_BEARER_PREFIX = "Bearer ";
    protected RestOperations restTemplate;
    protected String apiBaseUrl;

    public APIBaseClient() {
    }

    public APIBaseClient(String apiBaseUrl, String clientId, String clientSecret, String username, String password, String oauth2TokenUrl, String oauth2GrantType, String oauth2Scope) {
        this.apiBaseUrl = apiBaseUrl + "/v2";
        ResourceOwnerPasswordResourceDetails resource = this.createOauth2ResourceDetails(clientId, clientSecret, username, password, oauth2TokenUrl, oauth2GrantType, oauth2Scope);
        System.out.println("clientId=" + clientId + ", clientSecret=" + clientSecret + ", username=" + username + ", password=" + password + ", oauth2TokenUrl=" + oauth2TokenUrl + ", oauth2GrantType=" + oauth2GrantType + ", oauth2Scope=" + oauth2Scope);
        this.restTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)resource, (OAuth2ClientContext)new DefaultOAuth2ClientContext((AccessTokenRequest)new DefaultAccessTokenRequest()));
        ((OAuth2RestTemplate)this.restTemplate).setErrorHandler((ResponseErrorHandler)new SparkworksResponseErrorHandler());
    }

    protected APIBaseClient(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl + "/v2";
        this.restTemplate = new RestTemplate();
    }

    protected MultiValueMap<String, String> prepareHeaders(String accessToken) {
        HttpHeaders headers = new HttpHeaders();
        if (Objects.nonNull(accessToken)) {
            headers.add((Object)AUTHORIZATION_HEADER, (Object)(AUTH_BEARER_PREFIX + accessToken));
        }
        return headers;
    }

    private ResourceOwnerPasswordResourceDetails createOauth2ResourceDetails(String clientId, String clientSecret, String username, String password, String oauth2TokenUrl, String oauth2GrantType, String oauth2Scope) {
        ResourceOwnerPasswordResourceDetails resource = new ResourceOwnerPasswordResourceDetails();
        resource.setAccessTokenUri(oauth2TokenUrl);
        resource.setClientId(clientId);
        resource.setClientSecret(clientSecret);
        resource.setGrantType(oauth2GrantType);
        resource.setScope(Collections.singletonList(oauth2Scope));
        resource.setUsername(username);
        resource.setPassword(password);
        return resource;
    }
}

