package net.sparkworks.cargo.client.impl;

import net.sparkworks.cargo.client.APIBaseClient;
import net.sparkworks.cargo.client.PhenomenonClient;
import net.sparkworks.cargo.client.config.CargoClientConfig;
import net.sparkworks.cargo.client.config.CargoInternalCommunicationConfiguration;
import net.sparkworks.cargo.client.config.CargoRestTemplateConfig;
import net.sparkworks.cargo.common.dto.PhenomenonCreateDTO;
import net.sparkworks.cargo.common.dto.PhenomenonDTO;
import net.sparkworks.cargo.common.dto.PhenomenonQueryDTO;
import net.sparkworks.cargo.common.dto.PhenomenonUpdateDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Collection;
import java.util.UUID;

@Component("CaRGOPhenomenonClientImplV2")
public class PhenomenonClientImpl extends APIBaseClient implements PhenomenonClient {
    
    private String accessToken;

    @Autowired
    public PhenomenonClientImpl(@Qualifier(CargoRestTemplateConfig.SW_CARGO_REST_TEMPLATE_NAME) RestOperations restTemplate,
                                final CargoClientConfig sparkworksCargoClientConfig,
                                final CargoInternalCommunicationConfiguration cargoInternalCommunicationConfiguration) {
        this.restTemplate = restTemplate;
        this.apiBaseUrl = sparkworksCargoClientConfig.getAddress() +
                (cargoInternalCommunicationConfiguration.isEnabled() ? INTERNAL_PATH : "") + API_V2;
    }
    
    public PhenomenonClientImpl(final String apiBaseUrl, final String clientId, final String clientSecret, final String username,
                                final String password, final String oauth2TokenUrl, final String oauth2GrantType,
                                final String oauth2Scope) {
        super(apiBaseUrl, clientId, clientSecret, username, password, oauth2TokenUrl, oauth2GrantType, oauth2Scope);
    }
    

    public PhenomenonClientImpl(final String apibaseUrl, final String accessToken){
        super(apibaseUrl);
        this.accessToken = accessToken;
    }
    
    @Override
    public Collection<PhenomenonDTO> listAll() {
        HttpEntity httpEntity = new HttpEntity(prepareHeaders(accessToken));
        ResponseEntity<Collection<PhenomenonDTO>> response = restTemplate.
                exchange(UriComponentsBuilder.fromUriString(apiBaseUrl + PHENOMENON).toUriString(),
                        HttpMethod.GET, httpEntity, new ParameterizedTypeReference<Collection<PhenomenonDTO>>() {});
        if (!response.getStatusCode().is2xxSuccessful()) throw new RestClientException(response.toString());
        return response.getBody();
    }
    
    @Override
    public PhenomenonDTO getByUUID(final UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(prepareHeaders(accessToken));
        ResponseEntity<PhenomenonDTO> response = restTemplate.
                exchange(UriComponentsBuilder.
                        fromUriString(apiBaseUrl + PHENOMENON_BY_UUID).
                        buildAndExpand(uuid).
                        toUriString(), HttpMethod.GET, httpEntity, PhenomenonDTO.class);
        if (!response.getStatusCode().is2xxSuccessful()) throw new RestClientException(response.toString());
        return response.getBody();
    }
    
    @Override
    public PhenomenonDTO create(final String name) {
        final PhenomenonCreateDTO phenomenonCreateDTO = PhenomenonCreateDTO.builder().name(name).build();
        HttpEntity<PhenomenonCreateDTO> httpEntity = new HttpEntity<>(phenomenonCreateDTO, prepareHeaders(accessToken));
        ResponseEntity<PhenomenonDTO> response = restTemplate.
                exchange(UriComponentsBuilder.fromUriString(apiBaseUrl + PHENOMENON).toUriString(),
                        HttpMethod.POST, httpEntity, PhenomenonDTO.class);
        if (!response.getStatusCode().is2xxSuccessful()) throw new RestClientException(response.toString());
        return response.getBody();
    }
    
    @Override
    public PhenomenonDTO query(final String name, final UUID uuid) {
        final PhenomenonQueryDTO queryDTO = PhenomenonQueryDTO.builder().name(name).uuid(uuid).build();
        HttpEntity<PhenomenonQueryDTO> httpEntity = new HttpEntity<>(queryDTO, prepareHeaders(accessToken));
        ResponseEntity<PhenomenonDTO> response = restTemplate.
                exchange(UriComponentsBuilder.fromUriString(apiBaseUrl + PHENOMENON_BY_QUERY).toUriString(),
                        HttpMethod.POST, httpEntity, PhenomenonDTO.class);
        if (!response.getStatusCode().is2xxSuccessful()) throw new RestClientException(response.toString());
        return response.getBody();
    }
    
    
    @Override
    public void delete(UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(prepareHeaders(accessToken));
        ResponseEntity<Void> response = restTemplate.
                exchange(UriComponentsBuilder.fromUriString(apiBaseUrl + PHENOMENON_BY_UUID).
                                buildAndExpand(uuid).
                                toUriString(),
                        HttpMethod.DELETE, httpEntity, Void.class);
        if (!response.getStatusCode().is2xxSuccessful()) throw new RestClientException(response.toString());
    }
    
    @Override
    public PhenomenonDTO update(UUID uuid, String name) {
        PhenomenonUpdateDTO updateDTO = PhenomenonUpdateDTO.builder()
                .name(name)
                .build();
        
        HttpEntity<PhenomenonUpdateDTO> httpEntity = new HttpEntity<>(updateDTO, prepareHeaders(accessToken));
        ResponseEntity<PhenomenonDTO> response = restTemplate.
                exchange(UriComponentsBuilder.
                                fromUriString(apiBaseUrl + PHENOMENON_BY_UUID).
                                buildAndExpand(uuid).toUriString(),
                        HttpMethod.POST, httpEntity, PhenomenonDTO.class);
        if (!response.getStatusCode().is2xxSuccessful()) throw new RestClientException(response.toString());
        return response.getBody();
    }
    
}
