package net.sparkworks.cargo.client.impl;

import net.sparkworks.cargo.client.APIBaseClient;
import net.sparkworks.cargo.client.CommandClient;
import net.sparkworks.cargo.client.config.CargoClientConfig;
import net.sparkworks.cargo.client.config.CargoInternalCommunicationConfiguration;
import net.sparkworks.cargo.client.config.CargoRestTemplateConfig;
import net.sparkworks.cargo.common.dto.CommandDTO;
import net.sparkworks.cargo.common.dto.UnitDTO;
import net.sparkworks.cargo.common.dto.UnitQueryDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.UUID;

@Component("CaRGOCommandClientImplV2")
public class CommandClientImpl extends APIBaseClient implements CommandClient {
    
    private String accessToken;

    @Autowired
    public CommandClientImpl(@Qualifier(CargoRestTemplateConfig.SW_CARGO_REST_TEMPLATE_NAME) RestOperations restTemplate,
                             final CargoClientConfig sparkworksCargoClientConfig,
                             final CargoInternalCommunicationConfiguration cargoInternalCommunicationConfiguration) {
        this.restTemplate = restTemplate;
        this.apiBaseUrl = sparkworksCargoClientConfig.getAddress() +
                (cargoInternalCommunicationConfiguration.isEnabled() ? INTERNAL_PATH : "") +
                API_V2;
    }
    
    public CommandClientImpl(final String apiBaseUrl, final String clientId, final String clientSecret, final String username,
                             final String password, final String oauth2TokenUrl, final String oauth2GrantType,
                             final String oauth2Scope) {
        super(apiBaseUrl, clientId, clientSecret, username, password, oauth2TokenUrl, oauth2GrantType, oauth2Scope);
    }
    
    public CommandClientImpl(final String apibaseUrl, final String accessToken){
        super(apibaseUrl);
        this.accessToken = accessToken;
    }
    
    @Override
    public CommandDTO sendCommand(final UUID resourceUuid, final String command) {
        final CommandDTO commandDTO = CommandDTO.builder().command(command).build();
        HttpEntity<CommandDTO> httpEntity = new HttpEntity<>(commandDTO, prepareHeaders(accessToken));
        ResponseEntity<CommandDTO> response = restTemplate.
                exchange(UriComponentsBuilder.fromUriString(apiBaseUrl + COMMAND_BY_UUID).
                                buildAndExpand(resourceUuid).
                                toUriString(),
                        HttpMethod.POST, httpEntity, CommandDTO.class);
        if (!response.getStatusCode().is2xxSuccessful()) throw new RestClientException(response.toString());
        return response.getBody();
    }
    
}
