package net.sparkworks.cargo.client.config;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;

// todo export to commons
public class SparkworksResponseErrorHandler implements ResponseErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkworksResponseErrorHandler.class);

    @Override
    public boolean hasError(ClientHttpResponse clientHttpResponse) throws IOException {
        if (clientHttpResponse.getStatusCode() == HttpStatus.OK) {
            return false;
        }
        return true;
    }

    @Override
    public void handleError(ClientHttpResponse clientHttpResponse) throws IOException {
        if (clientHttpResponse.getStatusCode() != HttpStatus.OK) {
            LOGGER.debug("Status code: " + clientHttpResponse.getStatusCode());
            LOGGER.debug("Response" + clientHttpResponse.getStatusText());
            final StringWriter writer = new StringWriter();
            try {
                IOUtils.copy(clientHttpResponse.getBody(), writer, Charset.defaultCharset());
                LOGGER.debug(writer.toString());
            } catch (Exception ignore) {

            }
        }
    }
}