package net.sparkworks.cargo.client;

import net.sparkworks.cargo.common.dto.UnitConversionDTO;

import java.util.Collection;
import java.util.UUID;

public interface UnitConversionClient {

    /**
     * Retrieve all the UnitConversions
     *
     * @return a {@link Collection} containing all the {@link UnitConversionDTO}.
     */
    Collection<UnitConversionDTO> listAll();

    /**
     * Get a UnitConversion by its UUID
     *
     * @param uuid the {@link UUID} of the UnitConversion to retrieve
     * @return the {@link UnitConversionDTO} found
     */
    UnitConversionDTO getByUUID(UUID uuid);

    /**
     * Create a UnitConversion
     *
     * @param sourceUuid the {@link UUID} of the source Unit
     * @param targetUuid the {@link UUID} of the target Unit
     * @param method the method applied for the conversion
     * @return the new {@link UnitConversionDTO}
     */
    UnitConversionDTO create(final UUID sourceUuid, final UUID targetUuid, final String method);

    /**
     * Delete a UnitConversion by its UUID
     *
     * @param uuid the {@link UUID} of the UnitConversion to delete
     */
    void delete(UUID uuid);
    
    /**
     * Retrieve a Collection of UnitConversion by source Unit UUID, target Unit UUID and UnitConversion UUID
     *
     * The query will try to find conversions with the following priority:
     *
     * 1) find UnitConversion that has source with sourceUuid and target with targetUuid
     * 2) find UnitConversions that has source with sourceUuid
     * 3) find UnitConversions that has target with targetUuid
     * 4) find UnitConversion with uuid
     *
     * If no conversion is found then UnitConversionNotFoundException is thrown
     *
     * @param sourceUuid the {@link UUID} of the source Unit
     * @param targetUuid the {@link UUID} of the target Unit
     * @param uuid the {@link UUID} of the UnitConversion to retrieve
     * @return a {@link Collection} of {@link UnitConversionDTO} that contains all the Unit Conversions found
     */
    Collection<UnitConversionDTO> query(final UUID sourceUuid, final UUID targetUuid, final UUID uuid);
}
