package net.sparkworks.cargo.client;

import net.sparkworks.cargo.common.dto.UnitDTO;

import java.util.Collection;
import java.util.UUID;

public interface UnitClient {

    /**
     * Retrieve all the Units
     *
     * @return a {@link Collection} containing all the {@link UnitDTO}.
     */
    Collection<UnitDTO> listAll();

    /**
     * Get a Unit by its UUID
     *
     * @param uuid the {@link UUID} of the Unit to retrieve
     * @return the {@link UnitDTO} found
     */
    UnitDTO getByUUID(UUID uuid);

    /**
     * Create a Unit
     *
     * @param name the name of the Unit
     * @return the new {@link UnitDTO}
     */
    UnitDTO create(final String name);

    /**
     * Delete a Unit by its UUID
     *
     * @param uuid the {@link UUID} of the Unit to delete
     */
    void delete(UUID uuid);
    
    /**
     * Retrieve a Unit by its name or UUID
     *
     * @param name the name of the Unit
     * @param uuid the {@link UUID} of the Unit
     * @return the {@link UnitDTO} found
     */
    UnitDTO query(final String name, final UUID uuid);
    
    UnitDTO update(UUID uuid, String name);
}
