package net.sparkworks.cargo.client;

import net.sparkworks.cargo.common.dto.PhenomenonDTO;

import java.util.Collection;
import java.util.UUID;

public interface PhenomenonClient {

    /**
     * Retrieve all the Phenomena
     *
     * @return a {@link Collection} containing all the {@link PhenomenonDTO}.
     */
    Collection<PhenomenonDTO> listAll();

    /**
     * Get a Phenomenon by its UUID
     *
     * @param uuid the {@link UUID} of the Phenomenon to retrieve
     * @return the {@link PhenomenonDTO} found by the UUID
     */
    PhenomenonDTO getByUUID(UUID uuid);

    /**
     * Create a Phenomenon
     *
     * @param name the name of the Phenomenon
     * @return the new {@link PhenomenonDTO}
     */
    PhenomenonDTO create(final String name);

    /**
     * Delete a Phenomenon by its UUID
     *
     * @param uuid the {@link UUID} of the Phenomenon to delete
     */
    void delete(UUID uuid);
    
    /**
     * Retrieve a Phenomenon by its name or UUID
     *
     * @param name the name of the Phenomenon
     * @param uuid the {@link UUID} of the Phenomenon
     * @return the {@link PhenomenonDTO} found
     */
    PhenomenonDTO query(final String name, final UUID uuid);
    
    PhenomenonDTO update(UUID uuid, String name);
    
}
