package net.sparkworks.cargo.client;

import net.sparkworks.cargo.client.config.SparkworksResponseErrorHandler;
import net.sparkworks.cargo.common.CargoRoutes;
import org.springframework.http.HttpHeaders;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordResourceDetails;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

import java.util.Collections;
import java.util.Objects;

public abstract class APIBaseClient implements CargoRoutes {
    
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String AUTH_BEARER_PREFIX = "Bearer ";
    
    protected RestOperations restTemplate;
    protected String apiBaseUrl;
    
    public APIBaseClient() { }
    
    public APIBaseClient(final String apiBaseUrl, final String clientId, final String clientSecret,
                         final String username, final String password, final String oauth2TokenUrl,
                         final String oauth2GrantType, final String oauth2Scope) {
        this.apiBaseUrl = apiBaseUrl + API_V2;
        final ResourceOwnerPasswordResourceDetails resource =
                createOauth2ResourceDetails(clientId, clientSecret, username, password, oauth2TokenUrl, oauth2GrantType, oauth2Scope);
        System.out.println("clientId=" + clientId + ", " + "clientSecret=" + clientSecret+ ", " + "username=" + username+ ", " + "password=" + password+ ", " + "oauth2TokenUrl=" + oauth2TokenUrl+ ", " + "oauth2GrantType=" + oauth2GrantType+ ", " + "oauth2Scope=" + oauth2Scope);
        restTemplate = new OAuth2RestTemplate(resource, new DefaultOAuth2ClientContext(new DefaultAccessTokenRequest()));
        ((OAuth2RestTemplate) restTemplate).setErrorHandler(new SparkworksResponseErrorHandler());
    }
    
    protected APIBaseClient(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl + API_V2;
        this.restTemplate = new RestTemplate();
    }
    
    protected MultiValueMap<String, String> prepareHeaders(final String accessToken) {
        MultiValueMap<String, String> headers = new HttpHeaders();
        if(Objects.nonNull(accessToken)) {
            headers.add(AUTHORIZATION_HEADER, AUTH_BEARER_PREFIX + accessToken);
        }
        return headers;
    }
    
    
    private ResourceOwnerPasswordResourceDetails createOauth2ResourceDetails(final String clientId,
                                                                             final String clientSecret,
                                                                             final String username,
                                                                             final String password,
                                                                             final String oauth2TokenUrl,
                                                                             final String oauth2GrantType,
                                                                             final String oauth2Scope) {
        final ResourceOwnerPasswordResourceDetails resource = new ResourceOwnerPasswordResourceDetails();
        resource.setAccessTokenUri(oauth2TokenUrl);
        resource.setClientId(clientId);
        resource.setClientSecret(clientSecret);
        resource.setGrantType(oauth2GrantType);
        resource.setScope(Collections.singletonList(oauth2Scope));
        resource.setUsername(username);
        resource.setPassword(password);
        return resource;
    }
    
}
