/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.message.kinesis.producer;

import com.amazonaws.services.kinesis.producer.KinesisProducer;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import net.spals.appbuilder.annotations.config.ApplicationName;
import net.spals.appbuilder.annotations.service.AutoBindInMap;
import net.spals.appbuilder.config.message.MessageProducerConfig;
import net.spals.appbuilder.message.core.producer.MessageProducerPlugin;
import net.spals.appbuilder.message.kinesis.producer.KinesisProducerCallback;
import net.spals.appbuilder.message.kinesis.producer.KinesisProducerConfig;
import scala.reflect.ScalaSignature;

@AutoBindInMap(baseClass=MessageProducerPlugin.class, key="kinesis")
@ScalaSignature(bytes="\u0006\u0001M4Q!\u0001\u0002\u0001\u00059\u0011AdS5oKNL7/T3tg\u0006<W\r\u0015:pIV\u001cWM\u001d)mk\u001eLgN\u0003\u0002\u0004\t\u0005A\u0001O]8ek\u000e,'O\u0003\u0002\u0006\r\u000591.\u001b8fg&\u001c(BA\u0004\t\u0003\u001diWm]:bO\u0016T!!\u0003\u0006\u0002\u0015\u0005\u0004\bOY;jY\u0012,'O\u0003\u0002\f\u0019\u0005)1\u000f]1mg*\tQ\"A\u0002oKR\u001c2\u0001A\b\u0018!\t\u0001R#D\u0001\u0012\u0015\t\u00112#\u0001\u0003mC:<'\"\u0001\u000b\u0002\t)\fg/Y\u0005\u0003-E\u0011aa\u00142kK\u000e$\bC\u0001\r\u001d\u001b\u0005I\"BA\u0002\u001b\u0015\tYb!\u0001\u0003d_J,\u0017BA\u000f\u001a\u0005UiUm]:bO\u0016\u0004&o\u001c3vG\u0016\u0014\b\u000b\\;hS:D\u0001b\b\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0010CB\u0004H.[2bi&|gNT1nK\u000e\u0001\u0001C\u0001\u0012)\u001d\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011F\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d\"\u0003F\u0001\u0010-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0004d_:4\u0017n\u001a\u0006\u0003c!\t1\"\u00198o_R\fG/[8og&\u00111G\f\u0002\u0010\u0003B\u0004H.[2bi&|gNT1nK\"A1\u0001\u0001B\u0001B\u0003%Q\u0007\u0005\u00027\u007f5\tqG\u0003\u0002\u0004q)\u0011Q!\u000f\u0006\u0003um\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003yu\n\u0011\"Y7bu>t\u0017m^:\u000b\u0003y\n1aY8n\u0013\t\u0001uGA\bLS:,7/[:Qe>$WoY3s\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0003\u0019a\u0014N\\5u}Q\u0019AI\u0012%\u0011\u0005\u0015\u0003Q\"\u0001\u0002\t\u000b}\t\u0005\u0019A\u0011)\u0005\u0019c\u0003\"B\u0002B\u0001\u0004)\u0004FA!K!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0004j]*,7\r\u001e\u0006\u0003\u001fv\naaZ8pO2,\u0017BA)M\u0005\u0019IeN[3di\")1\u000b\u0001C!)\u0006Y1/\u001a8e\u001b\u0016\u001c8/Y4f)\r)\u0006\f\u0019\t\u0003GYK!a\u0016\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u00063J\u0003\rAW\u0001\u000faJ|G-^2fe\u000e{gNZ5h!\tYf,D\u0001]\u0015\t9QL\u0003\u00020\u0011%\u0011q\f\u0018\u0002\u0016\u001b\u0016\u001c8/Y4f!J|G-^2fe\u000e{gNZ5h\u0011\u0015\t'\u000b1\u0001c\u0003E\u0019XM]5bY&TX\r\u001a)bs2|\u0017\r\u001a\t\u0004G\r,\u0017B\u00013%\u0005\u0015\t%O]1z!\t\u0019c-\u0003\u0002hI\t!!)\u001f;fQ\u0019\u0001\u0011n\u001c9reB\u0011!.\\\u0007\u0002W*\u0011A\u000eM\u0001\bg\u0016\u0014h/[2f\u0013\tq7NA\u0007BkR|')\u001b8e\u0013:l\u0015\r]\u0001\nE\u0006\u001cXm\u00117bgN\u001c\u0013aF\u0001\u0004W\u0016L\u0018%A\u0003")
public class KinesisMessageProducerPlugin
implements MessageProducerPlugin {
    @ApplicationName
    private final String applicationName;
    private final KinesisProducer producer;

    public void sendMessage(MessageProducerConfig producerConfig, byte[] serializedPayload) {
        KinesisProducerConfig kinesisProducerConfig = new KinesisProducerConfig(producerConfig);
        ListenableFuture producerFuture = this.producer.addUserRecord(kinesisProducerConfig.getStreamName(), this.applicationName, ByteBuffer.wrap(serializedPayload));
        Futures.addCallback((ListenableFuture)producerFuture, (FutureCallback)new KinesisProducerCallback(producerConfig));
    }

    @Inject
    public KinesisMessageProducerPlugin(@ApplicationName String applicationName, KinesisProducer producer) {
        this.applicationName = applicationName;
        this.producer = producer;
    }
}

