/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.message.kafka.consumer;

import com.google.inject.Inject;
import com.netflix.governator.annotations.Configuration;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.spals.appbuilder.annotations.service.AutoBindInMap;
import net.spals.appbuilder.config.message.MessageConsumerConfig;
import net.spals.appbuilder.executor.core.ExecutorServiceFactory;
import net.spals.appbuilder.message.core.MessageConsumerCallback;
import net.spals.appbuilder.message.core.consumer.MessageConsumerPlugin;
import net.spals.appbuilder.message.kafka.consumer.KafkaConsumerConfig;
import net.spals.appbuilder.message.kafka.consumer.KafkaConsumerRunnable;
import net.spals.appbuilder.model.core.ModelSerializer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@AutoBindInMap(baseClass=MessageConsumerPlugin.class, key="kafka")
@ScalaSignature(bytes="\u0006\u0001\u0005]f!B\u0001\u0003\u0001\u0011q!AG&bM.\fW*Z:tC\u001e,7i\u001c8tk6,'\u000f\u00157vO&t'BA\u0002\u0005\u0003!\u0019wN\\:v[\u0016\u0014(BA\u0003\u0007\u0003\u0015Y\u0017MZ6b\u0015\t9\u0001\"A\u0004nKN\u001c\u0018mZ3\u000b\u0005%Q\u0011AC1qa\n,\u0018\u000e\u001c3fe*\u00111\u0002D\u0001\u0006gB\fGn\u001d\u0006\u0002\u001b\u0005\u0019a.\u001a;\u0014\u0007\u0001yq\u0003\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\tAB$D\u0001\u001a\u0015\t\u0019!D\u0003\u0002\u001c\r\u0005!1m\u001c:f\u0013\ti\u0012DA\u000bNKN\u001c\u0018mZ3D_:\u001cX/\\3s!2,x-\u001b8\t\u0011}\u0001!\u0011!Q\u0001\n\u0005\n1cY8ogVlWM]\"bY2\u0014\u0017mY6TKR\u001c\u0001\u0001E\u0002#K\u001dj\u0011a\t\u0006\u0003IM\tA!\u001e;jY&\u0011ae\t\u0002\u0004'\u0016$\bG\u0001\u0015/!\rI#\u0006L\u0007\u00025%\u00111F\u0007\u0002\u0018\u001b\u0016\u001c8/Y4f\u0007>t7/^7fe\u000e\u000bG\u000e\u001c2bG.\u0004\"!\f\u0018\r\u0001\u0011IqFHA\u0001\u0002\u0003\u0015\t\u0001\r\u0002\u0004?\u0012\n\u0014CA\u00198!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\r\u001d\n\u0005e\u001a$aA!os\"A1\b\u0001B\u0001B\u0003%A(\u0001\ffq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\r\u0006\u001cGo\u001c:z!\ti\u0014)D\u0001?\u0015\tYrH\u0003\u0002A\u0011\u0005AQ\r_3dkR|'/\u0003\u0002C}\t1R\t_3dkR|'oU3sm&\u001cWMR1di>\u0014\u0018\u0010C\u0003E\u0001\u0011\u0005Q)\u0001\u0004=S:LGO\u0010\u000b\u0004\r\"s\u0005CA$\u0001\u001b\u0005\u0011\u0001\"B\u0010D\u0001\u0004I\u0005c\u0001\u0012&\u0015B\u00121*\u0014\t\u0004S)b\u0005CA\u0017N\t%y\u0003*!A\u0001\u0002\u000b\u0005\u0001\u0007C\u0003<\u0007\u0002\u0007A\b\u000b\u0002D!B\u0011\u0011\u000bW\u0007\u0002%*\u00111\u000bV\u0001\u0007S:TWm\u0019;\u000b\u0005U3\u0016AB4p_\u001edWMC\u0001X\u0003\r\u0019w.\\\u0005\u00033J\u0013a!\u00138kK\u000e$\b\u0002C.\u0001\u0001\u0004%\t\u0001\u0002/\u0002!\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001cX#A/\u0011\u0005y\u000bgB\u0001\u001a`\u0013\t\u00017'\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u000114\u0011!)\u0007\u00011A\u0005\u0002\u00111\u0017\u0001\u00062p_R\u001cHO]1q'\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002hUB\u0011!\u0007[\u0005\u0003SN\u0012A!\u00168ji\"91\u000eZA\u0001\u0002\u0004i\u0016a\u0001=%c!1Q\u000e\u0001Q!\nu\u000b\u0011CY8piN$(/\u00199TKJ4XM]:!Q\u0011aw.\u001f>\u0011\u0005A<X\"A9\u000b\u0005I\u001c\u0018aC1o]>$\u0018\r^5p]NT!\u0001^;\u0002\u0015\u001d|g/\u001a:oCR|'O\u0003\u0002w-\u00069a.\u001a;gY&D\u0018B\u0001=r\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006)a/\u00197vK\u0006\n10\u0001\u0014nKN\u001c\u0018mZ3D_:\u001cX/\\3s]-\fgm[1/E>|Go\u001d;sCB\u001cVM\u001d<feND#\u0001\\?\u0011\u0007y\fY!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0017\r|gn\u001d;sC&tGo\u001d\u0006\u0005\u0003\u000b\t9!\u0001\u0006wC2LG-\u0019;j_:T!!!\u0003\u0002\u000b)\fg/\u0019=\n\u0007\u00055qPA\u0004O_RtU\u000f\u001c7\t\u0015\u0005E\u0001\u00011A\u0005\u0002\u0011\t\u0019\"\u0001\u0006ok6$\u0006N]3bIN,\"!!\u0006\u0011\u0007I\n9\"C\u0002\u0002\u001aM\u00121!\u00138u\u0011)\ti\u0002\u0001a\u0001\n\u0003!\u0011qD\u0001\u000f]VlG\u000b\u001b:fC\u0012\u001cx\fJ3r)\r9\u0017\u0011\u0005\u0005\nW\u0006m\u0011\u0011!a\u0001\u0003+A\u0001\"!\n\u0001A\u0003&\u0011QC\u0001\f]VlG\u000b\u001b:fC\u0012\u001c\b\u0005\u000b\u0004\u0002$=L\u0018\u0011F\u0011\u0003\u0003W\t\u0001%\\3tg\u0006<WmQ8ogVlWM\u001d\u0018lC\u001a\\\u0017M\f8v[RC'/Z1eg\":\u00111EA\u0018s\u0006U\u0002c\u0001@\u00022%\u0019\u00111G@\u0003\u00075KgNH\u0001\u0003\u0011%\tI\u0004\u0001b\u0001\n\u0013\tY$A\u000bd_:\u001cX/\\3s%Vtg.\u00192mK\u000e\u000b7\r[3\u0016\u0005\u0005u\u0002\u0003CA \u0003\u0013\ni%a\u0017\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nq!\\;uC\ndWMC\u0002\u0002HM\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY%!\u0011\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002P\u0005]SBAA)\u0015\r9\u00111\u000b\u0006\u0004\u0003+B\u0011AB2p]\u001aLw-\u0003\u0003\u0002Z\u0005E#!F'fgN\fw-Z\"p]N,X.\u001a:D_:4\u0017n\u001a\t\u0004\u000f\u0006u\u0013bAA0\u0005\t)2*\u00194lC\u000e{gn];nKJ\u0014VO\u001c8bE2,\u0007\u0002CA2\u0001\u0001\u0006I!!\u0010\u0002-\r|gn];nKJ\u0014VO\u001c8bE2,7)Y2iK\u0002B\u0001\"a\u001a\u0001\t\u0003\u0011\u0011\u0011N\u0001\u0014GJ,\u0017\r^3D_:\u001cX/\\3s!J|\u0007o\u001d\u000b\u0005\u0003W\n\t\bE\u0002#\u0003[J1!a\u001c$\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\t\u0003g\n)\u00071\u0001\u0002v\u0005\u00192.\u00194lC\u000e{gn];nKJ\u001cuN\u001c4jOB\u0019q)a\u001e\n\u0007\u0005e$AA\nLC\u001a\\\u0017mQ8ogVlWM]\"p]\u001aLw\rC\u0004\u0002~\u0001!\t%a \u0002\u000bM$\u0018M\u001d;\u0015\u000b\u001d\f\t)!\"\t\u0011\u0005\r\u00151\u0010a\u0001\u0003\u001b\nabY8ogVlWM]\"p]\u001aLw\r\u0003\u0005\u0002\b\u0006m\u0004\u0019AAE\u0003=iw\u000eZ3m'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003BAF\u0003'k!!!$\u000b\u0007m\tyIC\u0002\u0002\u0012\"\tQ!\\8eK2LA!!&\u0002\u000e\nyQj\u001c3fYN+'/[1mSj,'\u000fC\u0004\u0002\u001a\u0002!\t%a'\u0002\tM$x\u000e\u001d\u000b\u0004O\u0006u\u0005\u0002CAB\u0003/\u0003\r!!\u0014)\u0017\u0001\t\t+a,\u00022\u0006M\u0016Q\u0017\t\u0005\u0003G\u000bY+\u0004\u0002\u0002&*!\u0011qUAU\u0003\u001d\u0019XM\u001d<jG\u0016T!A\u001d\u0005\n\t\u00055\u0016Q\u0015\u0002\u000e\u0003V$xNQ5oI&sW*\u00199\u0002\u0013\t\f7/Z\"mCN\u001c8%A\f\u0002\u0007-,\u00170I\u0001\u0006\u0001")
public class KafkaMessageConsumerPlugin
implements MessageConsumerPlugin {
    private final Set<MessageConsumerCallback<?>> consumerCallbackSet;
    private final ExecutorServiceFactory executorServiceFactory;
    @NotNull
    @Configuration(value="messageConsumer.kafka.bootstrapServers")
    private String bootstrapServers;
    @Min(value=2L)
    @Configuration(value="messageConsumer.kafka.numThreads")
    private int numThreads;
    private final Map<MessageConsumerConfig, KafkaConsumerRunnable> consumerRunnableCache;

    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    public void bootstrapServers_$eq(String x$1) {
        this.bootstrapServers = x$1;
    }

    public int numThreads() {
        return this.numThreads;
    }

    public void numThreads_$eq(int x$1) {
        this.numThreads = x$1;
    }

    private Map<MessageConsumerConfig, KafkaConsumerRunnable> consumerRunnableCache() {
        return this.consumerRunnableCache;
    }

    /*
     * WARNING - void declaration
     */
    public Properties createConsumerProps(KafkaConsumerConfig kafkaConsumerConfig) {
        void var2_2;
        Properties props = new Properties();
        props.put("auto.commit.interval.ms", BoxesRunTime.boxToInteger((int)1000));
        props.put("bootstrap.servers", this.bootstrapServers());
        props.put("enable.auto.commit", BoxesRunTime.boxToBoolean((boolean)true));
        props.put("group.id", kafkaConsumerConfig.getGroupId());
        props.put("key.deserializer", StringDeserializer.class.getName());
        props.put("session.timeout.ms", BoxesRunTime.boxToInteger((int)30000));
        props.put("value.deserializer", ByteArrayDeserializer.class.getName());
        return var2_2;
    }

    public void start(MessageConsumerConfig consumerConfig, ModelSerializer modelSerializer) {
        KafkaConsumerConfig kafkaConsumerConfig = new KafkaConsumerConfig(consumerConfig);
        Properties consumerProps = this.createConsumerProps(kafkaConsumerConfig);
        KafkaConsumer consumer = new KafkaConsumer(consumerProps);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{kafkaConsumerConfig.getTopic()}))).asJava());
        KafkaConsumerRunnable consumerRunnable = new KafkaConsumerRunnable((KafkaConsumer<String, byte[]>)consumer, ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(MessageConsumerCallback.loadCallbacksForTag((String)consumerConfig.getTag(), this.consumerCallbackSet)).asScala()).toMap(Predef$.MODULE$.$conforms()), consumerConfig, modelSerializer);
        this.consumerRunnableCache().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)consumerConfig), (Object)consumerRunnable)})));
        ExecutorService executorService = this.executorServiceFactory.createFixedThreadPool(this.numThreads(), this.getClass(), new String[]{consumerConfig.getTag()});
        executorService.submit(consumerRunnable);
    }

    public void stop(MessageConsumerConfig consumerConfig) {
        this.consumerRunnableCache().get((Object)consumerConfig).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaConsumerRunnable x$1) {
                x$1.shutdown();
            }
        });
    }

    @Inject
    public KafkaMessageConsumerPlugin(Set<MessageConsumerCallback<?>> consumerCallbackSet, ExecutorServiceFactory executorServiceFactory) {
        this.consumerCallbackSet = consumerCallbackSet;
        this.executorServiceFactory = executorServiceFactory;
        this.bootstrapServers = null;
        this.numThreads = 2;
        this.consumerRunnableCache = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

