/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.message.kafka.producer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.governator.annotations.Configuration;
import java.util.Properties;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.spals.appbuilder.annotations.service.AutoBindInMap;
import net.spals.appbuilder.config.message.MessageProducerConfig;
import net.spals.appbuilder.message.core.producer.MessageProducerPlugin;
import net.spals.appbuilder.message.kafka.producer.KafkaProducerCallback;
import net.spals.appbuilder.message.kafka.producer.KafkaProducerConfig;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@AutoBindInMap(baseClass=MessageProducerPlugin.class, key="kafka")
@ScalaSignature(bytes="\u0006\u0001\u0005Ec!B\u0001\u0003\u0001\u0011q!AG&bM.\fW*Z:tC\u001e,\u0007K]8ek\u000e,'\u000f\u00157vO&t'BA\u0002\u0005\u0003!\u0001(o\u001c3vG\u0016\u0014(BA\u0003\u0007\u0003\u0015Y\u0017MZ6b\u0015\t9\u0001\"A\u0004nKN\u001c\u0018mZ3\u000b\u0005%Q\u0011AC1qa\n,\u0018\u000e\u001c3fe*\u00111\u0002D\u0001\u0006gB\fGn\u001d\u0006\u0002\u001b\u0005\u0019a.\u001a;\u0014\u0007\u0001yq\u0003\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\tAB$D\u0001\u001a\u0015\t\u0019!D\u0003\u0002\u001c\r\u0005!1m\u001c:f\u0013\ti\u0012DA\u000bNKN\u001c\u0018mZ3Qe>$WoY3s!2,x-\u001b8\t\u000b}\u0001A\u0011A\u0011\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\t\t\u0003G\u0001i\u0011A\u0001\u0005\tK\u0001\u0001\r\u0011\"\u0001\u0005M\u0005\u0001\"m\\8ugR\u0014\u0018\r]*feZ,'o]\u000b\u0002OA\u0011\u0001F\f\b\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QFK\u0001\u0007!J,G-\u001a4\n\u0005=\u0002$AB*ue&twM\u0003\u0002.U!A!\u0007\u0001a\u0001\n\u0003!1'\u0001\u000bc_>$8\u000f\u001e:baN+'O^3sg~#S-\u001d\u000b\u0003i]\u0002\"!K\u001b\n\u0005YR#\u0001B+oSRDq\u0001O\u0019\u0002\u0002\u0003\u0007q%A\u0002yIEBaA\u000f\u0001!B\u00139\u0013!\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:tA!\"\u0011\b\u0010%J!\tid)D\u0001?\u0015\ty\u0004)A\u0006b]:|G/\u0019;j_:\u001c(BA!C\u0003)9wN^3s]\u0006$xN\u001d\u0006\u0003\u0007\u0012\u000bqA\\3uM2L\u0007PC\u0001F\u0003\r\u0019w.\\\u0005\u0003\u000fz\u0012QbQ8oM&<WO]1uS>t\u0017!\u0002<bYV,\u0017%\u0001&\u0002M5,7o]1hKB\u0013x\u000eZ;dKJt3.\u00194lC:\u0012wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148\u000f\u000b\u0002:\u0019B\u0011Q\nV\u0007\u0002\u001d*\u0011q\nU\u0001\fG>t7\u000f\u001e:bS:$8O\u0003\u0002R%\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0003M\u000bQA[1wCbL!!\u0016(\u0003\u000f9{GOT;mY\"Aq\u000b\u0001a\u0001\n\u0003!\u0001,A\u0004sKR\u0014\u0018.Z:\u0016\u0003e\u0003\"!\u000b.\n\u0005mS#aA%oi\"AQ\f\u0001a\u0001\n\u0003!a,A\u0006sKR\u0014\u0018.Z:`I\u0015\fHC\u0001\u001b`\u0011\u001dAD,!AA\u0002eCa!\u0019\u0001!B\u0013I\u0016\u0001\u0003:fiJLWm\u001d\u0011)\t\u0001d\u0004jY\u0011\u0002I\u0006iR.Z:tC\u001e,\u0007K]8ek\u000e,'OL6bM.\fgF]3ue&,7\u000f\u000b\u0003aM\"K\u0007CA'h\u0013\tAgJA\u0002NS:t\u0012\u0001\u0001\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u00035\u0001(o\u001c3vG\u0016\u00148)Y2iKV\tQ\u000e\u0005\u0003ok^TX\"A8\u000b\u0005A\f\u0018!B2bG\",'B\u0001:t\u0003\u0019\u0019w.\\7p]*\u0011A\u000fR\u0001\u0007O>|w\r\\3\n\u0005Y|'\u0001\u0004'pC\u0012LgnZ\"bG\",\u0007CA\u0012y\u0013\tI(AA\nLC\u001a\\\u0017\r\u0015:pIV\u001cWM]\"p]\u001aLw\r\u0005\u0004|\u0003\u00139\u0013QB\u0007\u0002y*\u00111! \u0006\u0003}~\fqa\u00197jK:$8OC\u0002\u0006\u0003\u0003QA!a\u0001\u0002\u0006\u00051\u0011\r]1dQ\u0016T!!a\u0002\u0002\u0007=\u0014x-C\u0002\u0002\fq\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b#B\u0015\u0002\u0010\u0005M\u0011bAA\tU\t)\u0011I\u001d:bsB\u0019\u0011&!\u0006\n\u0007\u0005]!F\u0001\u0003CsR,\u0007bBA\u000e\u0001\u0001\u0006I!\\\u0001\u000faJ|G-^2fe\u000e\u000b7\r[3!\u0011\u001d\ty\u0002\u0001C!\u0003C\t1b]3oI6+7o]1hKR)A'a\t\u00026!A\u0011QEA\u000f\u0001\u0004\t9#\u0001\bqe>$WoY3s\u0007>tg-[4\u0011\t\u0005%\u0012\u0011G\u0007\u0003\u0003WQ1aBA\u0017\u0015\r\ty\u0003C\u0001\u0007G>tg-[4\n\t\u0005M\u00121\u0006\u0002\u0016\u001b\u0016\u001c8/Y4f!J|G-^2fe\u000e{gNZ5h\u0011!\t9$!\bA\u0002\u00055\u0011!E:fe&\fG.\u001b>fIB\u000b\u0017\u0010\\8bI\"Z\u0001!a\u000f\u0002J\u0005-\u0013QJA(!\u0011\ti$!\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nqa]3sm&\u001cWM\u0003\u0002@\u0011%!\u0011qIA \u00055\tU\u000f^8CS:$\u0017J\\'ba\u0006I!-Y:f\u00072\f7o]\u0012\u0002/\u0005\u00191.Z=\"\u0003\u0015\u0001")
public class KafkaMessageProducerPlugin
implements MessageProducerPlugin {
    @NotNull
    @Configuration(value="messageProducer.kafka.bootstrapServers")
    private String bootstrapServers = null;
    @Min(value=0L)
    @Configuration(value="messageProducer.kafka.retries")
    private int retries = 0;
    private final LoadingCache<KafkaProducerConfig, KafkaProducer<String, byte[]>> producerCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<KafkaProducerConfig, KafkaProducer<String, byte[]>>(this){
        private final /* synthetic */ KafkaMessageProducerPlugin $outer;

        public KafkaProducer<String, byte[]> load(KafkaProducerConfig kafkaProducerConfig) {
            return new KafkaProducer(this.createProducerProps(kafkaProducerConfig));
        }

        /*
         * WARNING - void declaration
         */
        private Properties createProducerProps(KafkaProducerConfig kafkaProducerConfig) {
            void var2_2;
            Properties props = new Properties();
            props.put("acks", "all");
            props.put("batch.size", BoxesRunTime.boxToInteger((int)16384));
            props.put("bootstrap.servers", this.$outer.bootstrapServers());
            props.put("buffer.memory", BoxesRunTime.boxToLong((long)0x2000000L));
            props.put("client.id", kafkaProducerConfig.getClientId());
            props.put("key.serializer", StringSerializer.class.getName());
            props.put("linger.ms", BoxesRunTime.boxToInteger((int)1));
            props.put("retries", BoxesRunTime.boxToInteger((int)this.$outer.retries()));
            props.put("value.serializer", ByteArraySerializer.class.getName());
            return var2_2;
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    });

    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    public void bootstrapServers_$eq(String x$1) {
        this.bootstrapServers = x$1;
    }

    public int retries() {
        return this.retries;
    }

    public void retries_$eq(int x$1) {
        this.retries = x$1;
    }

    private LoadingCache<KafkaProducerConfig, KafkaProducer<String, byte[]>> producerCache() {
        return this.producerCache;
    }

    public void sendMessage(MessageProducerConfig producerConfig, byte[] serializedPayload) {
        KafkaProducerConfig kafkaProducerConfig = new KafkaProducerConfig(producerConfig);
        KafkaProducer producer = (KafkaProducer)this.producerCache().getUnchecked((Object)kafkaProducerConfig);
        ProducerRecord producerRecord = new ProducerRecord(kafkaProducerConfig.getTopic(), (Object)serializedPayload);
        producer.send(producerRecord, (Callback)new KafkaProducerCallback(producerConfig));
    }
}

