/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableLongSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

/**
 * ImmutableLongSetFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongSet}.
 * This file was automatically generated from template file immutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongSetFactoryImpl implements ImmutableLongSetFactory
{
    public ImmutableLongSet empty()
    {
        return ImmutableLongEmptySet.INSTANCE;
    }

    public ImmutableLongSet of()
    {
        return this.empty();
    }

    public ImmutableLongSet with()
    {
        return this.empty();
    }

    public ImmutableLongSet of(long one)
    {
        return this.with(one);
    }

    public ImmutableLongSet with(long one)
    {
        return new ImmutableLongSingletonSet(one);
    }

    public ImmutableLongSet of(long... items)
    {
        return this.with(items);
    }

    public ImmutableLongSet with(long... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return LongHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableLongSet ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableLongSet withAll(LongIterable items)
    {
        if (items instanceof ImmutableLongSet)
        {
            return (ImmutableLongSet) items;
        }
        return this.with(items.toArray());
    }
}
