/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.DoubleBooleanPredicate;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableDoubleBooleanMap extends DoubleBooleanMap
{
    ImmutableDoubleBooleanMap select(DoubleBooleanPredicate predicate);

    ImmutableDoubleBooleanMap reject(DoubleBooleanPredicate predicate);

    ImmutableBooleanCollection select(BooleanPredicate predicate);

    ImmutableBooleanCollection reject(BooleanPredicate predicate);

    <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function);

    ImmutableDoubleBooleanMap newWithKeyValue(double key, boolean value);

    ImmutableDoubleBooleanMap newWithoutKey(double key);

    ImmutableDoubleBooleanMap newWithoutAllKeys(DoubleIterable keys);
}
