/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractIntSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableIntSet extends AbstractIntSet implements ImmutableIntSet
{
    public ImmutableIntSet newWith(int element)
    {
        return IntHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableIntSet newWithout(int element)
    {
        return IntHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableIntSet newWithAll(IntIterable elements)
    {
        return IntHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableIntSet newWithoutAll(IntIterable elements)
    {
        return IntHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public IntSet freeze()
    {
        return this;
    }

    public ImmutableIntSet toImmutable()
    {
        return this;
    }
}
