/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.DoubleFloatPredicate;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableFloatCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableDoubleFloatMap extends DoubleFloatMap
{
    ImmutableDoubleFloatMap select(DoubleFloatPredicate predicate);

    ImmutableDoubleFloatMap reject(DoubleFloatPredicate predicate);

    ImmutableFloatCollection select(FloatPredicate predicate);

    ImmutableFloatCollection reject(FloatPredicate predicate);

    <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function);

    ImmutableDoubleFloatMap newWithKeyValue(double key, float value);

    ImmutableDoubleFloatMap newWithoutKey(double key);

    ImmutableDoubleFloatMap newWithoutAllKeys(DoubleIterable keys);
}
