// Autogenerated code. Do not modify.
package net.spals.appbuilder.mapstore.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Generated;
import javax.annotation.Nullable;

/**
 * Auto-generated superclass of {@link MapStoreKey.Builder}, derived from the API of {@link
 * MapStoreKey}.
 */
@Generated("org.inferred.freebuilder.processor.CodeGenerator")
abstract class MapStoreKey_Builder {

  /** Creates a new builder using {@code value} as a template. */
  public static MapStoreKey.Builder from(MapStoreKey value) {
    return new MapStoreKey.Builder().mergeFrom(value);
  }

  private static final Joiner COMMA_JOINER = Joiner.on(", ").skipNulls();

  private enum Property {
    HASH_FIELD("hashField"),
    HASH_VALUE("hashValue"),
    ;

    private final String name;

    private Property(String name) {
      this.name = name;
    }

    @Override
    public String toString() {
      return name;
    }
  }

  private String hashField;
  private Object hashValue;
  // Store a nullable object instead of an Optional. Escape analysis then
  // allows the JVM to optimize away the Optional objects created by and
  // passed to our API.
  private String rangeField = null;
  private MapRangeKey rangeKey;
  private final EnumSet<MapStoreKey_Builder.Property> _unsetProperties =
      EnumSet.allOf(MapStoreKey_Builder.Property.class);

  /**
   * Sets the value to be returned by {@link MapStoreKey#getHashField()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code hashField} is null
   */
  @JsonProperty("hashField")
  public MapStoreKey.Builder setHashField(String hashField) {
    this.hashField = Preconditions.checkNotNull(hashField);
    _unsetProperties.remove(MapStoreKey_Builder.Property.HASH_FIELD);
    return (MapStoreKey.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link MapStoreKey#getHashField()} by applying {@code
   * mapper} to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public MapStoreKey.Builder mapHashField(UnaryOperator<String> mapper) {
    Preconditions.checkNotNull(mapper);
    return setHashField(mapper.apply(getHashField()));
  }

  /**
   * Returns the value that will be returned by {@link MapStoreKey#getHashField()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public String getHashField() {
    Preconditions.checkState(
        !_unsetProperties.contains(MapStoreKey_Builder.Property.HASH_FIELD), "hashField not set");
    return hashField;
  }

  /**
   * Sets the value to be returned by {@link MapStoreKey#getHashValue()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code hashValue} is null
   */
  @JsonProperty("hashValue")
  public MapStoreKey.Builder setHashValue(Object hashValue) {
    this.hashValue = Preconditions.checkNotNull(hashValue);
    _unsetProperties.remove(MapStoreKey_Builder.Property.HASH_VALUE);
    return (MapStoreKey.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link MapStoreKey#getHashValue()} by applying {@code
   * mapper} to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   * @throws IllegalStateException if the field has not been set
   */
  public MapStoreKey.Builder mapHashValue(UnaryOperator<Object> mapper) {
    Preconditions.checkNotNull(mapper);
    return setHashValue(mapper.apply(getHashValue()));
  }

  /**
   * Returns the value that will be returned by {@link MapStoreKey#getHashValue()}.
   *
   * @throws IllegalStateException if the field has not been set
   */
  public Object getHashValue() {
    Preconditions.checkState(
        !_unsetProperties.contains(MapStoreKey_Builder.Property.HASH_VALUE), "hashValue not set");
    return hashValue;
  }

  /**
   * Sets the value to be returned by {@link MapStoreKey#getRangeField()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code rangeField} is null
   */
  public MapStoreKey.Builder setRangeField(String rangeField) {
    this.rangeField = Preconditions.checkNotNull(rangeField);
    return (MapStoreKey.Builder) this;
  }

  /**
   * Sets the value to be returned by {@link MapStoreKey#getRangeField()}.
   *
   * @return this {@code Builder} object
   */
  @JsonProperty("rangeField")
  public MapStoreKey.Builder setRangeField(Optional<? extends String> rangeField) {
    if (rangeField.isPresent()) {
      return setRangeField(rangeField.get());
    } else {
      return clearRangeField();
    }
  }

  /**
   * Sets the value to be returned by {@link MapStoreKey#getRangeField()}.
   *
   * @return this {@code Builder} object
   */
  public MapStoreKey.Builder setNullableRangeField(@Nullable String rangeField) {
    if (rangeField != null) {
      return setRangeField(rangeField);
    } else {
      return clearRangeField();
    }
  }

  /**
   * If the value to be returned by {@link MapStoreKey#getRangeField()} is present, replaces it by
   * applying {@code mapper} to it and using the result.
   *
   * <p>If the result is null, clears the value.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null
   */
  public MapStoreKey.Builder mapRangeField(UnaryOperator<String> mapper) {
    return setRangeField(getRangeField().map(mapper));
  }

  /**
   * Sets the value to be returned by {@link MapStoreKey#getRangeField()} to {@link Optional#empty()
   * Optional.empty()}.
   *
   * @return this {@code Builder} object
   */
  public MapStoreKey.Builder clearRangeField() {
    this.rangeField = null;
    return (MapStoreKey.Builder) this;
  }

  /** Returns the value that will be returned by {@link MapStoreKey#getRangeField()}. */
  public Optional<String> getRangeField() {
    return Optional.ofNullable(rangeField);
  }

  /**
   * Sets the value to be returned by {@link MapStoreKey#getRangeKey()}.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code rangeKey} is null
   */
  @JsonProperty("rangeKey")
  public MapStoreKey.Builder setRangeKey(MapRangeKey rangeKey) {
    this.rangeKey = Preconditions.checkNotNull(rangeKey);
    return (MapStoreKey.Builder) this;
  }

  /**
   * Replaces the value to be returned by {@link MapStoreKey#getRangeKey()} by applying {@code
   * mapper} to it and using the result.
   *
   * @return this {@code Builder} object
   * @throws NullPointerException if {@code mapper} is null or returns null
   */
  public MapStoreKey.Builder mapRangeKey(UnaryOperator<MapRangeKey> mapper) {
    return setRangeKey(mapper.apply(getRangeKey()));
  }

  /** Returns the value that will be returned by {@link MapStoreKey#getRangeKey()}. */
  public MapRangeKey getRangeKey() {
    return rangeKey;
  }

  /** Sets all property values using the given {@code MapStoreKey} as a template. */
  public MapStoreKey.Builder mergeFrom(MapStoreKey value) {
    MapStoreKey_Builder _defaults = new MapStoreKey.Builder();
    if (_defaults._unsetProperties.contains(MapStoreKey_Builder.Property.HASH_FIELD)
        || !Objects.equals(value.getHashField(), _defaults.getHashField())) {
      setHashField(value.getHashField());
    }
    if (_defaults._unsetProperties.contains(MapStoreKey_Builder.Property.HASH_VALUE)
        || !Objects.equals(value.getHashValue(), _defaults.getHashValue())) {
      setHashValue(value.getHashValue());
    }
    value.getRangeField().ifPresent(this::setRangeField);
    if (!Objects.equals(value.getRangeKey(), _defaults.getRangeKey())) {
      setRangeKey(value.getRangeKey());
    }
    return (MapStoreKey.Builder) this;
  }

  /**
   * Copies values from the given {@code Builder}. Does not affect any properties not set on the
   * input.
   */
  public MapStoreKey.Builder mergeFrom(MapStoreKey.Builder template) {
    // Upcast to access private fields; otherwise, oddly, we get an access violation.
    MapStoreKey_Builder base = (MapStoreKey_Builder) template;
    MapStoreKey_Builder _defaults = new MapStoreKey.Builder();
    if (!base._unsetProperties.contains(MapStoreKey_Builder.Property.HASH_FIELD)
        && (_defaults._unsetProperties.contains(MapStoreKey_Builder.Property.HASH_FIELD)
            || !Objects.equals(template.getHashField(), _defaults.getHashField()))) {
      setHashField(template.getHashField());
    }
    if (!base._unsetProperties.contains(MapStoreKey_Builder.Property.HASH_VALUE)
        && (_defaults._unsetProperties.contains(MapStoreKey_Builder.Property.HASH_VALUE)
            || !Objects.equals(template.getHashValue(), _defaults.getHashValue()))) {
      setHashValue(template.getHashValue());
    }
    template.getRangeField().ifPresent(this::setRangeField);
    if (!Objects.equals(template.getRangeKey(), _defaults.getRangeKey())) {
      setRangeKey(template.getRangeKey());
    }
    return (MapStoreKey.Builder) this;
  }

  /** Resets the state of this builder. */
  public MapStoreKey.Builder clear() {
    MapStoreKey_Builder _defaults = new MapStoreKey.Builder();
    hashField = _defaults.hashField;
    hashValue = _defaults.hashValue;
    rangeField = _defaults.rangeField;
    rangeKey = _defaults.rangeKey;
    _unsetProperties.clear();
    _unsetProperties.addAll(_defaults._unsetProperties);
    return (MapStoreKey.Builder) this;
  }

  /**
   * Returns a newly-created {@link MapStoreKey} based on the contents of the {@code Builder}.
   *
   * @throws IllegalStateException if any field has not been set
   */
  public MapStoreKey build() {
    Preconditions.checkState(_unsetProperties.isEmpty(), "Not set: %s", _unsetProperties);
    return new MapStoreKey_Builder.Value(this);
  }

  /**
   * Returns a newly-created partial {@link MapStoreKey} for use in unit tests. State checking will
   * not be performed. Unset properties will throw an {@link UnsupportedOperationException} when
   * accessed via the partial object.
   *
   * <p>Partials should only ever be used in tests. They permit writing robust test cases that won't
   * fail if this type gains more application-level constraints (e.g. new required fields) in
   * future. If you require partially complete values in production code, consider using a Builder.
   */
  @VisibleForTesting()
  public MapStoreKey buildPartial() {
    return new MapStoreKey_Builder.Partial(this);
  }

  private static final class Value implements MapStoreKey {
    private final String hashField;
    private final Object hashValue;
    // Store a nullable object instead of an Optional. Escape analysis then
    // allows the JVM to optimize away the Optional objects created by our
    // getter method.
    private final String rangeField;
    private final MapRangeKey rangeKey;

    private Value(MapStoreKey_Builder builder) {
      this.hashField = builder.hashField;
      this.hashValue = builder.hashValue;
      this.rangeField = builder.rangeField;
      this.rangeKey = builder.rangeKey;
    }

    @Override
    @JsonProperty("hashField")
    public String getHashField() {
      return hashField;
    }

    @Override
    @JsonProperty("hashValue")
    public Object getHashValue() {
      return hashValue;
    }

    @Override
    @JsonProperty("rangeField")
    public Optional<String> getRangeField() {
      return Optional.ofNullable(rangeField);
    }

    @Override
    @JsonProperty("rangeKey")
    public MapRangeKey getRangeKey() {
      return rangeKey;
    }

    @Override
    public boolean equals(Object obj) {
      if (!(obj instanceof MapStoreKey_Builder.Value)) {
        return false;
      }
      MapStoreKey_Builder.Value other = (MapStoreKey_Builder.Value) obj;
      return Objects.equals(hashField, other.hashField)
          && Objects.equals(hashValue, other.hashValue)
          && Objects.equals(rangeField, other.rangeField)
          && Objects.equals(rangeKey, other.rangeKey);
    }

    @Override
    public int hashCode() {
      return Objects.hash(hashField, hashValue, rangeField, rangeKey);
    }

    @Override
    public String toString() {
      return "MapStoreKey{"
          + COMMA_JOINER.join(
              "hashField=" + hashField,
              "hashValue=" + hashValue,
              (rangeField != null ? "rangeField=" + rangeField : null),
              "rangeKey=" + rangeKey)
          + "}";
    }
  }

  private static final class Partial implements MapStoreKey {
    private final String hashField;
    private final Object hashValue;
    // Store a nullable object instead of an Optional. Escape analysis then
    // allows the JVM to optimize away the Optional objects created by our
    // getter method.
    private final String rangeField;
    private final MapRangeKey rangeKey;
    private final EnumSet<MapStoreKey_Builder.Property> _unsetProperties;

    Partial(MapStoreKey_Builder builder) {
      this.hashField = builder.hashField;
      this.hashValue = builder.hashValue;
      this.rangeField = builder.rangeField;
      this.rangeKey = builder.rangeKey;
      this._unsetProperties = builder._unsetProperties.clone();
    }

    @Override
    @JsonProperty("hashField")
    public String getHashField() {
      if (_unsetProperties.contains(MapStoreKey_Builder.Property.HASH_FIELD)) {
        throw new UnsupportedOperationException("hashField not set");
      }
      return hashField;
    }

    @Override
    @JsonProperty("hashValue")
    public Object getHashValue() {
      if (_unsetProperties.contains(MapStoreKey_Builder.Property.HASH_VALUE)) {
        throw new UnsupportedOperationException("hashValue not set");
      }
      return hashValue;
    }

    @Override
    @JsonProperty("rangeField")
    public Optional<String> getRangeField() {
      return Optional.ofNullable(rangeField);
    }

    @Override
    @JsonProperty("rangeKey")
    public MapRangeKey getRangeKey() {
      return rangeKey;
    }

    @Override
    public boolean equals(Object obj) {
      if (!(obj instanceof MapStoreKey_Builder.Partial)) {
        return false;
      }
      MapStoreKey_Builder.Partial other = (MapStoreKey_Builder.Partial) obj;
      return Objects.equals(hashField, other.hashField)
          && Objects.equals(hashValue, other.hashValue)
          && Objects.equals(rangeField, other.rangeField)
          && Objects.equals(rangeKey, other.rangeKey)
          && Objects.equals(_unsetProperties, other._unsetProperties);
    }

    @Override
    public int hashCode() {
      return Objects.hash(hashField, hashValue, rangeField, rangeKey, _unsetProperties);
    }

    @Override
    public String toString() {
      return "partial MapStoreKey{"
          + COMMA_JOINER.join(
              (!_unsetProperties.contains(MapStoreKey_Builder.Property.HASH_FIELD)
                  ? "hashField=" + hashField
                  : null),
              (!_unsetProperties.contains(MapStoreKey_Builder.Property.HASH_VALUE)
                  ? "hashValue=" + hashValue
                  : null),
              (rangeField != null ? "rangeField=" + rangeField : null),
              "rangeKey=" + rangeKey)
          + "}";
    }
  }
}
