/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.mapstore.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Assignment;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.Drop;
import com.datastax.driver.core.schemabuilder.KeyspaceOptions;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.google.inject.Inject;
import com.netflix.governator.annotations.Configuration;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PreDestroy;
import javax.validation.constraints.Min;
import net.spals.appbuilder.annotations.config.ApplicationName;
import net.spals.appbuilder.annotations.service.AutoBindInMap;
import net.spals.appbuilder.mapstore.cassandra.CassandraKeyClause;
import net.spals.appbuilder.mapstore.cassandra.CassandraMapStorePlugin$;
import net.spals.appbuilder.mapstore.core.MapStorePlugin;
import net.spals.appbuilder.mapstore.core.model.MapQueryOptions;
import net.spals.appbuilder.mapstore.core.model.MapStoreKey;
import net.spals.appbuilder.mapstore.core.model.MapStoreTableKey;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@AutoBindInMap(baseClass=MapStorePlugin.class, key="cassandra")
@ScalaSignature(bytes="\u0006\u0001\t\rc!B\u0001\u0003\u0001\ta!aF\"bgN\fg\u000e\u001a:b\u001b\u0006\u00048\u000b^8sKBcWoZ5o\u0015\t\u0019A!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011QAB\u0001\t[\u0006\u00048\u000f^8sK*\u0011q\u0001C\u0001\u000bCB\u0004(-^5mI\u0016\u0014(BA\u0005\u000b\u0003\u0015\u0019\b/\u00197t\u0015\u0005Y\u0011a\u00018fiN\u0019\u0001!D\u000b\u0011\u00059\u0019R\"A\b\u000b\u0005A\t\u0012\u0001\u00027b]\u001eT\u0011AE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0015\u001f\t1qJ\u00196fGR\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0003\u0002\t\r|'/Z\u0005\u00035]\u0011a\"T1q'R|'/\u001a)mk\u001eLg\u000e\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001f\u0003=\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8OC6,7\u0001\u0001\t\u0003?\u0015r!\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\na\u0001\u0015:fI\u00164\u0017B\u0001\u0014(\u0005\u0019\u0019FO]5oO*\u0011A%\t\u0015\u00037%\u0002\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\r\r|gNZ5h\u0015\tqc!A\u0006b]:|G/\u0019;j_:\u001c\u0018B\u0001\u0019,\u0005=\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8OC6,\u0007\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\u000f\rdWo\u001d;feB\u0011A\u0007P\u0007\u0002k)\u0011\u0001D\u000e\u0006\u0003oa\na\u0001\u001a:jm\u0016\u0014(BA\u001d;\u0003!!\u0017\r^1ti\u0006D(\"A\u001e\u0002\u0007\r|W.\u0003\u0002>k\t91\t\\;ti\u0016\u0014\b\"B \u0001\t\u0003\u0001\u0015A\u0002\u001fj]&$h\bF\u0002B\u0007\u0016\u0003\"A\u0011\u0001\u000e\u0003\tAQ\u0001\b A\u0002yA#aQ\u0015\t\u000bIr\u0004\u0019A\u001a)\u0005y:\u0005C\u0001%N\u001b\u0005I%B\u0001&L\u0003\u0019IgN[3di*\u0011AJO\u0001\u0007O>|w\r\\3\n\u00059K%AB%oU\u0016\u001cG\u000f\u0003\u0005Q\u0001\u0001\u0007I\u0011\u0001\u0002R\u0003I\u0019wN\u001c4jOV\u0014X\rZ&fsN\u0004\u0018mY3\u0016\u0003yA\u0001b\u0015\u0001A\u0002\u0013\u0005!\u0001V\u0001\u0017G>tg-[4ve\u0016$7*Z=ta\u0006\u001cWm\u0018\u0013fcR\u0011Q\u000b\u0017\t\u0003AYK!aV\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b3J\u000b\t\u00111\u0001\u001f\u0003\rAH%\r\u0005\u00077\u0002\u0001\u000b\u0015\u0002\u0010\u0002'\r|gNZ5hkJ,GmS3zgB\f7-\u001a\u0011)\u0005ik\u0006C\u0001\u0011_\u0013\ty\u0016E\u0001\u0005w_2\fG/\u001b7fQ\u0011Q\u0016M[6\u0011\u0005\tDW\"A2\u000b\u00059\"'BA3g\u0003)9wN^3s]\u0006$xN\u001d\u0006\u0003Oj\nqA\\3uM2L\u00070\u0003\u0002jG\ni1i\u001c8gS\u001e,(/\u0019;j_:\fQA^1mk\u0016\f\u0013\u0001\\\u0001\u001c[\u0006\u00048\u000b^8sK:\u001a\u0017m]:b]\u0012\u0014\u0018ML6fsN\u0004\u0018mY3\t\u00119\u0004\u0001\u0019!C\u0001\u0005=\f\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s+\u0005\u0001\bC\u0001\u0011r\u0013\t\u0011\u0018EA\u0002J]RD\u0001\u0002\u001e\u0001A\u0002\u0013\u0005!!^\u0001\u0016e\u0016\u0004H.[2bi&|gNR1di>\u0014x\fJ3r)\t)f\u000fC\u0004Zg\u0006\u0005\t\u0019\u00019\t\ra\u0004\u0001\u0015)\u0003q\u0003I\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0011)\u0005]l\u0006\u0006B<bUn\f\u0013\u0001`\u0001%[\u0006\u00048\u000b^8sK:\u001a\u0017m]:b]\u0012\u0014\u0018M\f:fa2L7-\u0019;j_:4\u0015m\u0019;pe\"*qO 6\u0002\u0012A\u0019q0!\u0004\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\t1bY8ogR\u0014\u0018-\u001b8ug*!\u0011qAA\u0005\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u0003\u0017\tQA[1wCbLA!a\u0004\u0002\u0002\t\u0019Q*\u001b8\u001f\u0003\u0005A\u0011\"!\u0006\u0001\u0005\u0004%\tAA)\u0002'I,\u0007\u000f\\5dCRLwN\\*ue\u0006$XmZ=\t\u000f\u0005e\u0001\u0001)A\u0005=\u0005!\"/\u001a9mS\u000e\fG/[8o'R\u0014\u0018\r^3hs\u0002B!\"!\b\u0001\u0011\u000b\u0007I\u0011BA\u0010\u00035\u0019w\u000eZ3d%\u0016<\u0017n\u001d;ssV\u0011\u0011\u0011\u0005\t\u0004i\u0005\r\u0012bAA\u0013k\ti1i\u001c3fGJ+w-[:uefD!\"!\u000b\u0001\u0011\u0003\u0005\u000b\u0015BA\u0011\u00039\u0019w\u000eZ3d%\u0016<\u0017n\u001d;ss\u0002B\u0011\"!\f\u0001\u0011\u000b\u0007I\u0011B)\u0002\u0011-,\u0017p\u001d9bG\u0016D\u0011\"!\r\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u0010\u0002\u0013-,\u0017p\u001d9bG\u0016\u0004\u0003BCA\u001b\u0001!\u0015\r\u0011\"\u0003\u00028\u000591/Z:tS>tWCAA\u001d!\r!\u00141H\u0005\u0004\u0003{)$aB*fgNLwN\u001c\u0005\u000b\u0003\u0003\u0002\u0001\u0012!Q!\n\u0005e\u0012\u0001C:fgNLwN\u001c\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\u0005)1\r\\8tKR\tQ\u000b\u000b\u0003\u0002D\u0005-\u0003\u0003BA'\u0003'j!!a\u0014\u000b\t\u0005E\u0013\u0011B\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA+\u0003\u001f\u0012!\u0002\u0015:f\t\u0016\u001cHO]8z\u0011\u001d\tI\u0006\u0001C!\u00037\n1b\u0019:fCR,G+\u00192mKR1\u0011QLA2\u0003O\u00022\u0001IA0\u0013\r\t\t'\t\u0002\b\u0005>|G.Z1o\u0011\u001d\t)'a\u0016A\u0002y\t\u0011\u0002^1cY\u0016t\u0015-\\3\t\u0011\u0005%\u0014q\u000ba\u0001\u0003W\n\u0001\u0002^1cY\u0016\\U-\u001f\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011O\f\u0002\u000b5|G-\u001a7\n\t\u0005U\u0014q\u000e\u0002\u0011\u001b\u0006\u00048\u000b^8sKR\u000b'\r\\3LKfDq!!\u001f\u0001\t\u0003\nY(A\u0005ee>\u0004H+\u00192mKR!\u0011QLA?\u0011\u001d\t)'a\u001eA\u0002yAq!!!\u0001\t\u0003\n\u0019)\u0001\u0006eK2,G/Z%uK6$R!VAC\u0003\u000fCq!!\u001a\u0002\u0000\u0001\u0007a\u0004\u0003\u0005\u0002\n\u0006}\u0004\u0019AAF\u0003\rYW-\u001f\t\u0005\u0003[\ni)\u0003\u0003\u0002\u0010\u0006=$aC'baN#xN]3LKfDq!a%\u0001\t\u0003\n)*A\u0006hKR\fE\u000e\\%uK6\u001cH\u0003BAL\u0003_\u0003b!!'\u0002 \u0006\rVBAAN\u0015\r\ti*E\u0001\u0005kRLG.\u0003\u0003\u0002\"\u0006m%\u0001\u0002'jgR\u0004r!!'\u0002&z\tI+\u0003\u0003\u0002(\u0006m%aA'baB\u0019\u0001%a+\n\u0007\u00055\u0016E\u0001\u0004B]f\u0014VM\u001a\u0005\b\u0003K\n\t\n1\u0001\u001f\u0011\u001d\t\u0019\f\u0001C!\u0003k\u000bqaZ3u\u0013R,W\u000e\u0006\u0004\u00028\u0006u\u0016q\u0018\t\u0007\u00033\u000bI,a)\n\t\u0005m\u00161\u0014\u0002\t\u001fB$\u0018n\u001c8bY\"9\u0011QMAY\u0001\u0004q\u0002\u0002CAE\u0003c\u0003\r!a#\t\u000f\u0005\r\u0007\u0001\"\u0011\u0002F\u0006Aq-\u001a;Ji\u0016l7\u000f\u0006\u0005\u0002\u0018\u0006\u001d\u0017\u0011ZAf\u0011\u001d\t)'!1A\u0002yA\u0001\"!#\u0002B\u0002\u0007\u00111\u0012\u0005\t\u0003\u001b\f\t\r1\u0001\u0002P\u00069q\u000e\u001d;j_:\u001c\b\u0003BA7\u0003#LA!a5\u0002p\tyQ*\u00199Rk\u0016\u0014\u0018p\u00149uS>t7\u000fC\u0004\u0002X\u0002!\t%!7\u0002\u000fA,H/\u0013;f[RA\u00111UAn\u0003;\fy\u000eC\u0004\u0002f\u0005U\u0007\u0019\u0001\u0010\t\u0011\u0005%\u0015Q\u001ba\u0001\u0003\u0017C\u0001\"!9\u0002V\u0002\u0007\u00111U\u0001\ba\u0006LHn\\1e\u0011\u001d\t)\u000f\u0001C!\u0003O\f!\"\u001e9eCR,\u0017\n^3n)!\t\u0019+!;\u0002l\u00065\bbBA3\u0003G\u0004\rA\b\u0005\t\u0003\u0013\u000b\u0019\u000f1\u0001\u0002\f\"A\u0011\u0011]Ar\u0001\u0004\t\u0019\u000b\u0003\u0005\u0002r\u0002!\tAAAz\u00031aw.\u00193ECR\fG+\u001f9f)\u0011\t)0a?\u0011\u0007Q\n90C\u0002\u0002zV\u0012\u0001\u0002R1uCRK\b/\u001a\u0005\t\u0003{\fy\u000f1\u0001\u0002\u0000\u0006Ia-[3mIRK\b/\u001a\u0019\u0005\u0005\u0003\u0011Y\u0001E\u0003 \u0005\u0007\u00119!C\u0002\u0003\u0006\u001d\u0012Qa\u00117bgN\u0004BA!\u0003\u0003\f1\u0001A\u0001\u0004B\u0007\u0003w\f\t\u0011!A\u0003\u0002\t=!aA0%cE!!\u0011\u0003B\f!\r\u0001#1C\u0005\u0004\u0005+\t#a\u0002(pi\"Lgn\u001a\t\u0004A\te\u0011b\u0001B\u000eC\t\u0019\u0011I\\=\t\u0011\t}\u0001\u0001\"\u0001\u0003\u0005C\t\u0011B]8x\u001b\u0006\u0004\b/\u001a:\u0015\u0005\t\r\u0002c\u0002\u0011\u0003&\t%\u00121U\u0005\u0004\u0005O\t#!\u0003$v]\u000e$\u0018n\u001c82!\r!$1F\u0005\u0004\u0005[)$a\u0001*po\"Z\u0001A!\r\u0003>\t}\u0012\u0011\u0012B!!\u0011\u0011\u0019D!\u000f\u000e\u0005\tU\"b\u0001B\u001c[\u000591/\u001a:wS\u000e,\u0017\u0002\u0002B\u001e\u0005k\u0011Q\"Q;u_\nKg\u000eZ%o\u001b\u0006\u0004\u0018!\u00032bg\u0016\u001cE.Y:tG\u0005)\u0012%A\u0002")
public class CassandraMapStorePlugin
implements MapStorePlugin {
    @ApplicationName
    public final String net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$applicationName;
    private final Cluster cluster;
    @Configuration(value="mapStore.cassandra.keyspace")
    private volatile String configuredKeyspace;
    @Min(value=1L)
    @Configuration(value="mapStore.cassandra.replicationFactor")
    private volatile int replicationFactor;
    private final String replicationStrategy;
    private CodecRegistry net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry;
    private String keyspace;
    private Session session;
    private volatile byte bitmap$0;

    private CodecRegistry net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry$lzycompute() {
        CassandraMapStorePlugin cassandraMapStorePlugin = this;
        synchronized (cassandraMapStorePlugin) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry = new CodecRegistry();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry;
        }
    }

    private String keyspace$lzycompute() {
        CassandraMapStorePlugin cassandraMapStorePlugin = this;
        synchronized (cassandraMapStorePlugin) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.keyspace = (String)Option$.MODULE$.apply((Object)this.configuredKeyspace()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ CassandraMapStorePlugin $outer;

                    public final String apply() {
                        return this.$outer.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$applicationName;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.keyspace;
        }
    }

    private Session session$lzycompute() {
        CassandraMapStorePlugin cassandraMapStorePlugin = this;
        synchronized (cassandraMapStorePlugin) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                scala.collection.immutable.Map replicationOptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replication_factor"), (Object)BoxesRunTime.boxToInteger((int)this.replicationFactor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.replicationStrategy())}));
                KeyspaceOptions createKeyspace = SchemaBuilder.createKeyspace((String)this.keyspace()).ifNotExists().with().durableWrites(Predef$.MODULE$.boolean2Boolean(true)).replication((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)replicationOptions).asJava());
                Session connectedSession = this.cluster.connect();
                connectedSession.execute((Statement)createKeyspace);
                String useKeyspace = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keyspace()}));
                connectedSession.execute(useKeyspace);
                this.session = connectedSession;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.session;
        }
    }

    public String configuredKeyspace() {
        return this.configuredKeyspace;
    }

    public void configuredKeyspace_$eq(String x$1) {
        this.configuredKeyspace = x$1;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public void replicationFactor_$eq(int x$1) {
        this.replicationFactor = x$1;
    }

    public String replicationStrategy() {
        return this.replicationStrategy;
    }

    public CodecRegistry net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry$lzycompute() : this.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry;
    }

    private String keyspace() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.keyspace$lzycompute() : this.keyspace;
    }

    private Session session() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.session$lzycompute() : this.session;
    }

    @PreDestroy
    public void close() {
        this.cluster.close();
    }

    public boolean createTable(String tableName, MapStoreTableKey tableKey) {
        boolean bl;
        Create schemaBuilder = ((Create)SchemaBuilder.createTable((String)tableName).ifNotExists()).addPartitionKey(tableKey.getHashField(), this.loadDataType(tableKey.getHashFieldType()));
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(tableKey.getRangeField())).foreach((Function1)new Serializable(this, tableKey, schemaBuilder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraMapStorePlugin $outer;
            private final MapStoreTableKey tableKey$1;
            private final Create schemaBuilder$1;

            public final Create apply(String x$1) {
                return this.schemaBuilder$1.addClusteringColumn(x$1, this.$outer.loadDataType((Class)this.tableKey$1.getRangeFieldType().get()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableKey$1 = tableKey$1;
                this.schemaBuilder$1 = schemaBuilder$1;
            }
        });
        schemaBuilder.addColumn("payload", (DataType)DataType.map((DataType)DataType.varchar(), (DataType)DataType.varchar()));
        try {
            bl = this.session().execute(schemaBuilder.toString()).wasApplied();
        }
        catch (RuntimeException runtimeException) {
            bl = false;
        }
        return bl;
    }

    public boolean dropTable(String tableName) {
        Drop schemaBuilder = SchemaBuilder.dropTable((String)tableName).ifExists();
        return this.session().execute(schemaBuilder.toString()).wasApplied();
    }

    public void deleteItem(String tableName, MapStoreKey key) {
        CassandraKeyClause keyClause = new CassandraKeyClause(key);
        Delete.Where queryBuilder = QueryBuilder.delete().from(tableName).where(keyClause.hashClause());
        keyClause.rangeClauses().foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Delete.Where queryBuilder$1;

            public final Delete.Where apply(Clause x$2) {
                return this.queryBuilder$1.and(x$2);
            }
            {
                this.queryBuilder$1 = queryBuilder$1;
            }
        });
        this.session().execute(queryBuilder.toString());
    }

    public java.util.List<java.util.Map<String, Object>> getAllItems(String tableName) {
        Select queryBuilder = QueryBuilder.select().all().from(tableName);
        Buffer results = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.session().execute(queryBuilder.toString()).all()).asScala();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)results.map(this.rowMapper(), Buffer$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    public Optional<java.util.Map<String, Object>> getItem(String tableName, MapStoreKey key) {
        CassandraKeyClause keyClause = new CassandraKeyClause(key);
        Select.Where queryBuilder = QueryBuilder.select().all().from(tableName).where(keyClause.hashClause());
        keyClause.rangeClauses().foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Select.Where queryBuilder$2;

            public final Select.Where apply(Clause x$3) {
                return this.queryBuilder$2.and(x$3);
            }
            {
                this.queryBuilder$2 = queryBuilder$2;
            }
        });
        Row result = this.session().execute(queryBuilder.toString()).one();
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.apply((Object)result).map(this.rowMapper())));
    }

    public java.util.List<java.util.Map<String, Object>> getItems(String tableName, MapStoreKey key, MapQueryOptions options) {
        CassandraKeyClause keyClause = new CassandraKeyClause(key);
        Select.Where queryBuilder = QueryBuilder.select().all().from(tableName).where(keyClause.hashClause());
        keyClause.rangeClauses().foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Select.Where queryBuilder$3;

            public final Select.Where apply(Clause x$4) {
                return this.queryBuilder$3.and(x$4);
            }
            {
                this.queryBuilder$3 = queryBuilder$3;
            }
        });
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(key.getRangeField())).map((Function1)new Serializable(this, options){
            public static final long serialVersionUID = 0L;
            private final MapQueryOptions options$1;

            public final Ordering apply(String rangeField) {
                MapQueryOptions.Order order;
                block4: {
                    Ordering ordering;
                    block3: {
                        block2: {
                            order = this.options$1.getOrder();
                            if (!MapQueryOptions.Order.ASC.equals(order)) break block2;
                            ordering = QueryBuilder.asc((String)rangeField);
                            break block3;
                        }
                        if (!MapQueryOptions.Order.DESC.equals(order)) break block4;
                        ordering = QueryBuilder.desc((String)rangeField);
                    }
                    return ordering;
                }
                throw new MatchError((Object)order);
            }
            {
                this.options$1 = options$1;
            }
        }).foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Select.Where queryBuilder$3;

            public final Select apply(Ordering x$5) {
                return this.queryBuilder$3.orderBy(new Ordering[]{x$5});
            }
            {
                this.queryBuilder$3 = queryBuilder$3;
            }
        });
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(options.getLimit())).foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Select.Where queryBuilder$3;

            public final Select apply(Integer x$6) {
                return this.queryBuilder$3.limit(Predef$.MODULE$.Integer2int(x$6));
            }
            {
                this.queryBuilder$3 = queryBuilder$3;
            }
        });
        Buffer results = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.session().execute(queryBuilder.toString()).all()).asScala();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)results.map(this.rowMapper(), Buffer$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    public java.util.Map<String, Object> putItem(String tableName, MapStoreKey key, java.util.Map<String, Object> payload) {
        MapStorePlugin.stripKey((MapStoreKey)key, payload);
        List keyFields = (List)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(key.getRangeField())).map((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final MapStoreKey key$1;

            public final List<String> apply(String rangeField) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.key$1.getHashField(), rangeField}));
            }
            {
                this.key$1 = key$1;
            }
        }).getOrElse((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final MapStoreKey key$1;

            public final List<String> apply() {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.key$1.getHashField()}));
            }
            {
                this.key$1 = key$1;
            }
        });
        List keyValues = (List)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(key.getRangeField())).map((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final MapStoreKey key$1;

            public final List<Object> apply(String rangeField) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.key$1.getHashValue(), this.key$1.getRangeKey().getValue()}));
            }
            {
                this.key$1 = key$1;
            }
        }).getOrElse((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final MapStoreKey key$1;

            public final List<Object> apply() {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.key$1.getHashValue()}));
            }
            {
                this.key$1 = key$1;
            }
        });
        Insert queryBuilder = QueryBuilder.insertInto((String)tableName).values((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)keyFields).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)keyValues).asJava()).value("payload", payload);
        this.session().execute(queryBuilder.toString());
        return this.getItem(tableName, key).get();
    }

    public java.util.Map<String, Object> updateItem(String tableName, MapStoreKey key, java.util.Map<String, Object> payload) {
        CassandraKeyClause keyClause = new CassandraKeyClause(key);
        Update.Where queryBuilder = QueryBuilder.update((String)tableName).where(keyClause.hashClause());
        keyClause.rangeClauses().foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Update.Where queryBuilder$4;

            public final Update.Where apply(Clause x$7) {
                return this.queryBuilder$4.and(x$7);
            }
            {
                this.queryBuilder$4 = queryBuilder$4;
            }
        });
        MapStorePlugin.stripKey((MapStoreKey)key, payload);
        Iterable assignments = (Iterable)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(payload).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Assignment apply(Tuple2<String, Object> entry) {
                return QueryBuilder.set((String)((String)entry._1()), (Object)entry._2());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        assignments.foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Update.Where queryBuilder$4;

            public final Update.Assignments apply(Assignment x$8) {
                return this.queryBuilder$4.with(x$8);
            }
            {
                this.queryBuilder$4 = queryBuilder$4;
            }
        });
        return (java.util.Map)this.rowMapper().apply((Object)this.session().execute(queryBuilder.toString()).one());
    }

    public DataType loadDataType(Class<?> fieldType) {
        block12: {
            DataType dataType;
            block3: {
                Class<?> clazz;
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    clazz = fieldType;
                                                    if (!clazz.equals(Boolean.TYPE) && !clazz.equals(Boolean.class)) break block2;
                                                    dataType = DataType.cboolean();
                                                    break block3;
                                                }
                                                if (!clazz.equals(Byte.TYPE) && !clazz.equals(Byte.class)) break block4;
                                                dataType = DataType.tinyint();
                                                break block3;
                                            }
                                            if (!clazz.equals(Date.class)) break block5;
                                            dataType = DataType.date();
                                            break block3;
                                        }
                                        if (!clazz.equals(Double.TYPE) && !clazz.equals(Double.class)) break block6;
                                        dataType = DataType.cdouble();
                                        break block3;
                                    }
                                    if (!clazz.equals(Float.TYPE) && !clazz.equals(Float.class)) break block7;
                                    dataType = DataType.cfloat();
                                    break block3;
                                }
                                if (!clazz.equals(Integer.TYPE) && !clazz.equals(Integer.class)) break block8;
                                dataType = DataType.cint();
                                break block3;
                            }
                            if (!clazz.equals(Long.TYPE) && !clazz.equals(Long.class)) break block9;
                            dataType = DataType.bigint();
                            break block3;
                        }
                        if (!clazz.equals(Short.TYPE) && !clazz.equals(Short.class)) break block10;
                        dataType = DataType.smallint();
                        break block3;
                    }
                    if (!clazz.equals(String.class)) break block11;
                    dataType = DataType.varchar();
                    break block3;
                }
                if (!clazz.equals(UUID.class)) break block12;
                dataType = DataType.uuid();
            }
            return dataType;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported Cassandra column DataType: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldType})));
    }

    public Function1<Row, java.util.Map<String, Object>> rowMapper() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraMapStorePlugin $outer;

            public final java.util.Map<String, Object> apply(Row row) {
                Buffer cols = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(row.getColumnDefinitions().asList()).asScala();
                scala.collection.immutable.Map rowMap = ((TraversableOnce)cols.map((Function1)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$rowMapper$1 $outer;
                    private final Row row$1;

                    public final Tuple2<String, Nothing$> apply(ColumnDefinitions.Definition col) {
                        return new Tuple2((Object)col.getName(), this.row$1.get(col.getName(), this.$outer.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$anonfun$$$outer().net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry().codecFor(col.getType())));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.row$1 = row$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                scala.collection.mutable.Map rowMMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(rowMap.toSeq());
                Option payloadMap = rowMMap.remove((Object)"payload").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.mutable.Map<String, Object> apply(Object x$9) {
                        return (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)x$9).asScala();
                    }
                });
                scala.collection.immutable.Map keyMap = rowMMap.toMap(Predef$.MODULE$.$conforms());
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)payloadMap.map((Function1)new Serializable(this, keyMap){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map keyMap$1;

                    public final scala.collection.mutable.Map<String, Object> apply(scala.collection.mutable.Map<String, Object> x$10) {
                        return x$10.$plus$plus((GenTraversableOnce)this.keyMap$1);
                    }
                    {
                        this.keyMap$1 = keyMap$1;
                    }
                }).getOrElse((Function0)new Serializable(this, keyMap){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map keyMap$1;

                    public final scala.collection.immutable.Map<String, Object> apply() {
                        return this.keyMap$1;
                    }
                    {
                        this.keyMap$1 = keyMap$1;
                    }
                })).asJava();
            }

            public /* synthetic */ CassandraMapStorePlugin net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    @Inject
    public CassandraMapStorePlugin(@ApplicationName String applicationName, Cluster cluster) {
        this.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$applicationName = applicationName;
        this.cluster = cluster;
        this.configuredKeyspace = null;
        this.replicationFactor = 2;
        this.replicationStrategy = "SimpleStrategy";
    }
}

