/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.mapstore.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.google.inject.Provider;
import com.netflix.governator.annotations.Configuration;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.spals.appbuilder.annotations.service.AutoBindProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@AutoBindProvider
@ScalaSignature(bytes="\u0006\u0001\u0005Ef!B\u0001\u0003\u0001\ta!aI\"bgN\fg\u000e\u001a:b\u00072,8\u000f^3s\u0013:LG/[1mSj,'\u000f\u0015:pm&$WM\u001d\u0006\u0003\u0007\u0011\t\u0011bY1tg\u0006tGM]1\u000b\u0005\u00151\u0011\u0001C7baN$xN]3\u000b\u0005\u001dA\u0011AC1qa\n,\u0018\u000e\u001c3fe*\u0011\u0011BC\u0001\u0006gB\fGn\u001d\u0006\u0002\u0017\u0005\u0019a.\u001a;\u0014\t\u0001iQ\u0003\u000f\t\u0003\u001dMi\u0011a\u0004\u0006\u0003!E\tA\u0001\\1oO*\t!#\u0001\u0003kCZ\f\u0017B\u0001\u000b\u0010\u0005\u0019y%M[3diB\u0019a#H\u0010\u000e\u0003]Q!\u0001G\r\u0002\r%t'.Z2u\u0015\tQ2$\u0001\u0004h_><G.\u001a\u0006\u00029\u0005\u00191m\\7\n\u0005y9\"\u0001\u0003)s_ZLG-\u001a:\u0011\u0005\u0001*dBA\u00113\u001d\t\u0011sF\u0004\u0002$Y9\u0011AE\u000b\b\u0003K%j\u0011A\n\u0006\u0003O!\na\u0001\u0010:p_Rt4\u0001A\u0005\u00029%\u00111fG\u0001\tI\u0006$\u0018m\u001d;bq&\u0011QFL\u0001\u0007IJLg/\u001a:\u000b\u0005-Z\u0012B\u0001\u00192\u0003\u0011\u0019wN]3\u000b\u00055r\u0013BA\u001a5\u0003\u001d\u0019E.^:uKJT!\u0001M\u0019\n\u0005Y:$aC%oSRL\u0017\r\\5{KJT!a\r\u001b\u0011\u0005ebdBA\u0011;\u0013\tYD'\u0001\u0003I_N$\u0018BA\u001f?\u00055\u0019F/\u0019;f\u0019&\u001cH/\u001a8fe*\u00111\b\u000e\u0005\u0006\u0001\u0002!\t!Q\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0003\"a\u0011\u0001\u000e\u0003\tAq!\u0012\u0001C\u0002\u0013%a)\u0001\u0004M\u001f\u001e;UIU\u000b\u0002\u000fB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0006g24GG\u001b\u0006\u0002\u0019\u0006\u0019qN]4\n\u00059K%A\u0002'pO\u001e,'\u000f\u0003\u0004Q\u0001\u0001\u0006IaR\u0001\b\u0019>;u)\u0012*!\u0011!\u0011\u0006\u00011A\u0005\u0002\t\u0019\u0016aC2mkN$XM\u001d(b[\u0016,\u0012\u0001\u0016\t\u0003+ns!AV-\u000e\u0003]S\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035^\u000ba\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!l\u0016\u0005\t?\u0002\u0001\r\u0011\"\u0001\u0003A\u0006y1\r\\;ti\u0016\u0014h*Y7f?\u0012*\u0017\u000f\u0006\u0002bIB\u0011aKY\u0005\u0003G^\u0013A!\u00168ji\"9QMXA\u0001\u0002\u0004!\u0016a\u0001=%c!1q\r\u0001Q!\nQ\u000bAb\u00197vgR,'OT1nK\u0002B#AZ5\u0011\u0005YS\u0017BA6X\u0005!1x\u000e\\1uS2,\u0007\u0006\u00024nob\u0004\"A\\;\u000e\u0003=T!\u0001]9\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003eN\f!bZ8wKJt\u0017\r^8s\u0015\t!8$A\u0004oKR4G.\u001b=\n\u0005Y|'!D\"p]\u001aLw-\u001e:bi&|g.A\u0003wC2,X-I\u0001z\u0003yi\u0017\r]*u_J,gfY1tg\u0006tGM]1/G2,8\u000f^3s\u001d\u0006lW\r\u000b\u0002gwB\u0019A0a\u0002\u000e\u0003uT!A`@\u0002\u0017\r|gn\u001d;sC&tGo\u001d\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0006wC2LG-\u0019;j_:T!!!\u0002\u0002\u000b)\fg/\u0019=\n\u0007\u0005%QPA\u0004O_RtU\u000f\u001c7\t\u0013\u00055\u0001\u00011A\u0005\u0002\t\u0019\u0016!\u00025pgR\u001c\bBCA\t\u0001\u0001\u0007I\u0011\u0001\u0002\u0002\u0014\u0005I\u0001n\\:ug~#S-\u001d\u000b\u0004C\u0006U\u0001\u0002C3\u0002\u0010\u0005\u0005\t\u0019\u0001+\t\u000f\u0005e\u0001\u0001)Q\u0005)\u00061\u0001n\\:ug\u0002B3!a\u0006jQ\u0019\t9\"\\<\u0002 \u0005\u0012\u0011\u0011E\u0001\u0019[\u0006\u00048\u000b^8sK:\u001a\u0017m]:b]\u0012\u0014\u0018M\f5pgR\u001c\bfAA\fw\"Q\u0011q\u0005\u0001A\u0002\u0013\u0005!!!\u000b\u0002\tA|'\u000f^\u000b\u0003\u0003W\u00012AVA\u0017\u0013\r\tyc\u0016\u0002\u0004\u0013:$\bBCA\u001a\u0001\u0001\u0007I\u0011\u0001\u0002\u00026\u0005A\u0001o\u001c:u?\u0012*\u0017\u000fF\u0002b\u0003oA\u0011\"ZA\u0019\u0003\u0003\u0005\r!a\u000b\t\u0011\u0005m\u0002\u0001)Q\u0005\u0003W\tQ\u0001]8si\u0002B3!!\u000fjQ\u0019\tI$\\<\u0002B\u0005\u0012\u00111I\u0001\u0018[\u0006\u00048\u000b^8sK:\u001a\u0017m]:b]\u0012\u0014\u0018M\f9peRDs!!\u000f\u0002H]\fi\u0005E\u0002}\u0003\u0013J1!a\u0013~\u0005\ri\u0015\r\u001f\u0010\u0004\u0001}\u0000\u0010fBA\u001d\u0003#:\u0018q\u000b\t\u0004y\u0006M\u0013bAA+{\n\u0019Q*\u001b8\u001f\u0005\rA\u000fbBA.\u0001\u0011\u0005\u0013QL\u0001\u0004O\u0016$H#A\u0010\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d\u0005)qN\\!eIR\u0019\u0011-!\u001a\t\u0011\u0005\u001d\u0014q\fa\u0001\u0003S\nA\u0001[8tiB!\u00111NA7\u001b\u0005!\u0014bAA8i\t!\u0001j\\:u\u0011\u001d\t\u0019\b\u0001C!\u0003k\nAb\u001c8V]J,w-[:uKJ$2!YA<\u0011!\tI(!\u001dA\u0002\u0005m\u0014aB2mkN$XM\u001d\t\u0005\u0003W\ni(C\u0002\u0002\u0000Q\u0012qa\u00117vgR,'\u000fC\u0004\u0002\u0004\u0002!\t%!\"\u0002\u0015=t'+Z4jgR,'\u000fF\u0002b\u0003\u000fC\u0001\"!\u001f\u0002\u0002\u0002\u0007\u00111\u0010\u0005\b\u0003\u0017\u0003A\u0011IAG\u0003!ygNU3n_Z,GcA1\u0002\u0010\"A\u0011qMAE\u0001\u0004\tI\u0007C\u0004\u0002\u0014\u0002!\t%!&\u0002\t=tW\u000b\u001d\u000b\u0004C\u0006]\u0005\u0002CA4\u0003#\u0003\r!!\u001b\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\u00061qN\u001c#po:$2!YAP\u0011!\t9'!'A\u0002\u0005%\u0004f\u0001\u0001\u0002$B!\u0011QUAW\u001b\t\t9K\u0003\u0003\u0002*\u0006-\u0016aB:feZL7-\u001a\u0006\u0003a\u001aIA!a,\u0002(\n\u0001\u0012)\u001e;p\u0005&tG\r\u0015:pm&$WM\u001d")
public class CassandraClusterInitializerProvider
implements Provider<Cluster.Initializer>,
Host.StateListener {
    private final Logger LOGGER = LoggerFactory.getLogger(CassandraClusterInitializerProvider.class);
    @NotNull
    @Configuration(value="mapStore.cassandra.clusterName")
    private volatile String clusterName = null;
    @NotNull
    @Configuration(value="mapStore.cassandra.hosts")
    private volatile String hosts = null;
    @Min(value=1000L)
    @Max(value=65535L)
    @Configuration(value="mapStore.cassandra.port")
    private volatile int port = 9042;

    private Logger LOGGER() {
        return this.LOGGER;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public void clusterName_$eq(String x$1) {
        this.clusterName = x$1;
    }

    public String hosts() {
        return this.hosts;
    }

    public void hosts_$eq(String x$1) {
        this.hosts = x$1;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public Cluster.Initializer get() {
        return Cluster.builder().withClusterName(this.clusterName()).addContactPoints(this.hosts().split(",")).withPort(this.port()).withInitialListeners(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Host.StateListener[]{this}))).asJavaCollection());
    }

    public void onAdd(Host host) {
        this.LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding Cassandra host: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host})));
    }

    public void onUnregister(Cluster cluster) {
        this.LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unregistered Cassandra cluster: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cluster})));
    }

    public void onRegister(Cluster cluster) {
        this.LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered Cassandra cluster: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cluster})));
    }

    public void onRemove(Host host) {
        this.LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed Cassandra host: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host})));
    }

    public void onUp(Host host) {
        this.LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cassandra host is up: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host})));
    }

    public void onDown(Host host) {
        this.LOGGER().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cassandra host is down: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host})));
    }
}

