/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.mapstore.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Assignment;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.Drop;
import com.datastax.driver.core.schemabuilder.KeyspaceOptions;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.google.inject.Inject;
import com.netflix.governator.annotations.Configuration;
import java.io.Closeable;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PreDestroy;
import javax.validation.constraints.Min;
import net.spals.appbuilder.annotations.config.ApplicationName;
import net.spals.appbuilder.annotations.service.AutoBindInMap;
import net.spals.appbuilder.mapstore.cassandra.CassandraKeyClause;
import net.spals.appbuilder.mapstore.cassandra.CassandraMapStorePlugin$;
import net.spals.appbuilder.mapstore.core.MapStorePlugin;
import net.spals.appbuilder.mapstore.core.model.MapQueryOptions;
import net.spals.appbuilder.mapstore.core.model.MapStoreKey;
import net.spals.appbuilder.mapstore.core.model.MapStoreTableKey;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@AutoBindInMap(baseClass=MapStorePlugin.class, key="cassandra")
@ScalaSignature(bytes="\u0006\u0001\t=c!B\u0001\u0003\u0001\ta!aF\"bgN\fg\u000e\u001a:b\u001b\u0006\u00048\u000b^8sKBcWoZ5o\u0015\t\u0019A!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011QAB\u0001\t[\u0006\u00048\u000f^8sK*\u0011q\u0001C\u0001\u000bCB\u0004(-^5mI\u0016\u0014(BA\u0005\u000b\u0003\u0015\u0019\b/\u00197t\u0015\u0005Y\u0011a\u00018fiN!\u0001!D\u000b\u001c!\tq1#D\u0001\u0010\u0015\t\u0001\u0012#\u0001\u0003mC:<'\"\u0001\n\u0002\t)\fg/Y\u0005\u0003)=\u0011aa\u00142kK\u000e$\bC\u0001\f\u001a\u001b\u00059\"B\u0001\r\u0005\u0003\u0011\u0019wN]3\n\u0005i9\"AD'baN#xN]3QYV<\u0017N\u001c\t\u00039}i\u0011!\b\u0006\u0003=E\t!![8\n\u0005\u0001j\"!C\"m_N,\u0017M\u00197f\u0011!\u0011\u0003A!A!\u0002\u0013!\u0013aD1qa2L7-\u0019;j_:t\u0015-\\3\u0004\u0001A\u0011Qe\u000b\b\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!fJ\u0001\u0007!J,G-\u001a4\n\u00051j#AB*ue&twM\u0003\u0002+O!\u0012\u0011e\f\t\u0003aUj\u0011!\r\u0006\u0003eM\naaY8oM&<'B\u0001\u001b\u0007\u0003-\tgN\\8uCRLwN\\:\n\u0005Y\n$aD!qa2L7-\u0019;j_:t\u0015-\\3\t\u0011a\u0002!\u0011!Q\u0001\ne\nqa\u00197vgR,'\u000f\u0005\u0002;\u00056\t1H\u0003\u0002\u0019y)\u0011QHP\u0001\u0007IJLg/\u001a:\u000b\u0005}\u0002\u0015\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003\u0005\u000b1aY8n\u0013\t\u00195HA\u0004DYV\u001cH/\u001a:\t\u000b\u0015\u0003A\u0011\u0001$\u0002\rqJg.\u001b;?)\r9\u0015j\u0013\t\u0003\u0011\u0002i\u0011A\u0001\u0005\u0006E\u0011\u0003\r\u0001\n\u0015\u0003\u0013>BQ\u0001\u000f#A\u0002eB#\u0001R'\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016AB5oU\u0016\u001cGO\u0003\u0002S\u0001\u00061qm\\8hY\u0016L!\u0001V(\u0003\r%s'.Z2u\u0011!1\u0006\u00011A\u0005\u0002\t9\u0016AE2p]\u001aLw-\u001e:fI.+\u0017p\u001d9bG\u0016,\u0012\u0001\n\u0005\t3\u0002\u0001\r\u0011\"\u0001\u00035\u000612m\u001c8gS\u001e,(/\u001a3LKf\u001c\b/Y2f?\u0012*\u0017\u000f\u0006\u0002\\=B\u0011a\u0005X\u0005\u0003;\u001e\u0012A!\u00168ji\"9q\fWA\u0001\u0002\u0004!\u0013a\u0001=%c!1\u0011\r\u0001Q!\n\u0011\n1cY8oM&<WO]3e\u0017\u0016L8\u000f]1dK\u0002B#\u0001Y2\u0011\u0005\u0019\"\u0017BA3(\u0005!1x\u000e\\1uS2,\u0007\u0006\u00021haF\u0004\"\u0001\u001b8\u000e\u0003%T!\u0001\u000e6\u000b\u0005-d\u0017AC4pm\u0016\u0014h.\u0019;pe*\u0011Q\u000eQ\u0001\b]\u0016$h\r\\5y\u0013\ty\u0017NA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0006m\u0006dW/Z\u0011\u0002e\u0006YR.\u00199Ti>\u0014XML2bgN\fg\u000e\u001a:b]-,\u0017p\u001d9bG\u0016D\u0001\u0002\u001e\u0001A\u0002\u0013\u0005!!^\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014X#\u0001<\u0011\u0005\u0019:\u0018B\u0001=(\u0005\rIe\u000e\u001e\u0005\tu\u0002\u0001\r\u0011\"\u0001\u0003w\u0006)\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:`I\u0015\fHCA.}\u0011\u001dy\u00160!AA\u0002YDaA \u0001!B\u00131\u0018A\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002B#!`2)\u000bu<\u0007/a\u0001\"\u0005\u0005\u0015\u0011\u0001J7baN#xN]3/G\u0006\u001c8/\u00198ee\u0006t#/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:)\ru\fI\u0001]A\u000f!\u0011\tY!!\u0007\u000e\u0005\u00055!\u0002BA\b\u0003#\t1bY8ogR\u0014\u0018-\u001b8ug*!\u00111CA\u000b\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u0003/\tQA[1wCbLA!a\u0007\u0002\u000e\t\u0019Q*\u001b8\u001f\u0003\u0005A\u0011\"!\t\u0001\u0005\u0004%\tAA,\u0002'I,\u0007\u000f\\5dCRLwN\\*ue\u0006$XmZ=\t\u000f\u0005\u0015\u0002\u0001)A\u0005I\u0005!\"/\u001a9mS\u000e\fG/[8o'R\u0014\u0018\r^3hs\u0002B!\"!\u000b\u0001\u0011\u000b\u0007I\u0011BA\u0016\u00035\u0019w\u000eZ3d%\u0016<\u0017n\u001d;ssV\u0011\u0011Q\u0006\t\u0004u\u0005=\u0012bAA\u0019w\ti1i\u001c3fGJ+w-[:uefD!\"!\u000e\u0001\u0011\u0003\u0005\u000b\u0015BA\u0017\u00039\u0019w\u000eZ3d%\u0016<\u0017n\u001d;ss\u0002B\u0001\"!\u000f\u0001\u0005\u0004%IaV\u0001\tW\u0016L8\u000f]1dK\"9\u0011Q\b\u0001!\u0002\u0013!\u0013!C6fsN\u0004\u0018mY3!\u0011)\t\t\u0005\u0001EC\u0002\u0013%\u00111I\u0001\bg\u0016\u001c8/[8o+\t\t)\u0005E\u0002;\u0003\u000fJ1!!\u0013<\u0005\u001d\u0019Vm]:j_:D!\"!\u0014\u0001\u0011\u0003\u0005\u000b\u0015BA#\u0003!\u0019Xm]:j_:\u0004\u0003bBA)\u0001\u0011\u0005\u00131K\u0001\u0006G2|7/\u001a\u000b\u00027\"\"\u0011qJA,!\u0011\tI&a\u0018\u000e\u0005\u0005m#\u0002BA/\u0003+\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t'a\u0017\u0003\u0015A\u0013X\rR3tiJ|\u0017\u0010C\u0004\u0002f\u0001!\t%a\u001a\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u0007\u0003S\ny'a\u001d\u0011\u0007\u0019\nY'C\u0002\u0002n\u001d\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002r\u0005\r\u0004\u0019\u0001\u0013\u0002\u0013Q\f'\r\\3OC6,\u0007\u0002CA;\u0003G\u0002\r!a\u001e\u0002\u0011Q\f'\r\\3LKf\u0004B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004\u0003{:\u0012!B7pI\u0016d\u0017\u0002BAA\u0003w\u0012\u0001#T1q'R|'/\u001a+bE2,7*Z=\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\u0006IAM]8q)\u0006\u0014G.\u001a\u000b\u0005\u0003S\nI\tC\u0004\u0002r\u0005\r\u0005\u0019\u0001\u0013\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\u0006QA-\u001a7fi\u0016LE/Z7\u0015\u000bm\u000b\t*a%\t\u000f\u0005E\u00141\u0012a\u0001I!A\u0011QSAF\u0001\u0004\t9*A\u0002lKf\u0004B!!\u001f\u0002\u001a&!\u00111TA>\u0005-i\u0015\r]*u_J,7*Z=\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\u0006Yq-\u001a;BY2LE/Z7t)\u0011\t\u0019+a/\u0011\r\u0005\u0015\u00161VAX\u001b\t\t9KC\u0002\u0002*F\tA!\u001e;jY&!\u0011QVAT\u0005\u0011a\u0015n\u001d;\u0011\u000f\u0005\u0015\u0016\u0011\u0017\u0013\u00026&!\u00111WAT\u0005\ri\u0015\r\u001d\t\u0004M\u0005]\u0016bAA]O\t1\u0011I\\=SK\u001aDq!!\u001d\u0002\u001e\u0002\u0007A\u0005C\u0004\u0002@\u0002!\t%!1\u0002\u000f\u001d,G/\u0013;f[R1\u00111YAe\u0003\u0017\u0004b!!*\u0002F\u0006=\u0016\u0002BAd\u0003O\u0013\u0001b\u00149uS>t\u0017\r\u001c\u0005\b\u0003c\ni\f1\u0001%\u0011!\t)*!0A\u0002\u0005]\u0005bBAh\u0001\u0011\u0005\u0013\u0011[\u0001\tO\u0016$\u0018\n^3ngRA\u00111UAj\u0003+\f9\u000eC\u0004\u0002r\u00055\u0007\u0019\u0001\u0013\t\u0011\u0005U\u0015Q\u001aa\u0001\u0003/C\u0001\"!7\u0002N\u0002\u0007\u00111\\\u0001\b_B$\u0018n\u001c8t!\u0011\tI(!8\n\t\u0005}\u00171\u0010\u0002\u0010\u001b\u0006\u0004\u0018+^3ss>\u0003H/[8og\"9\u00111\u001d\u0001\u0005B\u0005\u0015\u0018a\u00029vi&#X-\u001c\u000b\t\u0003_\u000b9/!;\u0002l\"9\u0011\u0011OAq\u0001\u0004!\u0003\u0002CAK\u0003C\u0004\r!a&\t\u0011\u00055\u0018\u0011\u001da\u0001\u0003_\u000bq\u0001]1zY>\fG\rC\u0004\u0002r\u0002!\t%a=\u0002\u0015U\u0004H-\u0019;f\u0013R,W\u000e\u0006\u0005\u00020\u0006U\u0018q_A}\u0011\u001d\t\t(a<A\u0002\u0011B\u0001\"!&\u0002p\u0002\u0007\u0011q\u0013\u0005\t\u0003[\fy\u000f1\u0001\u00020\"A\u0011Q \u0001\u0005\u0002\t\ty0\u0001\u0007m_\u0006$G)\u0019;b)f\u0004X\r\u0006\u0003\u0003\u0002\t\u001d\u0001c\u0001\u001e\u0003\u0004%\u0019!QA\u001e\u0003\u0011\u0011\u000bG/\u0019+za\u0016D\u0001B!\u0003\u0002|\u0002\u0007!1B\u0001\nM&,G\u000e\u001a+za\u0016\u0004DA!\u0004\u0003\u0018A)QEa\u0004\u0003\u0014%\u0019!\u0011C\u0017\u0003\u000b\rc\u0017m]:\u0011\t\tU!q\u0003\u0007\u0001\t1\u0011IBa\u0002\u0002\u0002\u0003\u0005)\u0011\u0001B\u000e\u0005\ryF%M\t\u0005\u0005;\u0011\u0019\u0003E\u0002'\u0005?I1A!\t(\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\nB\u0013\u0013\r\u00119c\n\u0002\u0004\u0003:L\b\u0002\u0003B\u0016\u0001\u0011\u0005!A!\f\u0002\u0013I|w/T1qa\u0016\u0014HC\u0001B\u0018!\u001d1#\u0011\u0007B\u001b\u0003_K1Aa\r(\u0005%1UO\\2uS>t\u0017\u0007E\u0002;\u0005oI1A!\u000f<\u0005\r\u0011vn\u001e\u0015\f\u0001\tu\"\u0011\nB&\u0003+\u0013i\u0005\u0005\u0003\u0003@\t\u0015SB\u0001B!\u0015\r\u0011\u0019eM\u0001\bg\u0016\u0014h/[2f\u0013\u0011\u00119E!\u0011\u0003\u001b\u0005+Ho\u001c\"j]\u0012Le.T1q\u0003%\u0011\u0017m]3DY\u0006\u001c8oI\u0001\u0016C\u0005\u0019\u0001")
public class CassandraMapStorePlugin
implements MapStorePlugin,
Closeable {
    @ApplicationName
    public final String net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$applicationName;
    private final Cluster cluster;
    @Configuration(value="mapStore.cassandra.keyspace")
    private volatile String configuredKeyspace;
    @Min(value=1L)
    @Configuration(value="mapStore.cassandra.replicationFactor")
    private volatile int replicationFactor;
    private final String replicationStrategy;
    private CodecRegistry net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry;
    private final String keyspace;
    private Session session;
    private volatile byte bitmap$0;

    private CodecRegistry net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry$lzycompute() {
        CassandraMapStorePlugin cassandraMapStorePlugin = this;
        synchronized (cassandraMapStorePlugin) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry = new CodecRegistry();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry;
        }
    }

    private Session session$lzycompute() {
        CassandraMapStorePlugin cassandraMapStorePlugin = this;
        synchronized (cassandraMapStorePlugin) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                scala.collection.immutable.Map replicationOptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replication_factor"), (Object)BoxesRunTime.boxToInteger((int)this.replicationFactor())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.replicationStrategy())}));
                KeyspaceOptions createKeyspace = SchemaBuilder.createKeyspace((String)this.keyspace()).ifNotExists().with().durableWrites(Predef$.MODULE$.boolean2Boolean(true)).replication((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)replicationOptions).asJava());
                Session connectedSession = this.cluster.connect();
                connectedSession.execute((Statement)createKeyspace);
                String useKeyspace = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keyspace()}));
                connectedSession.execute(useKeyspace);
                this.session = connectedSession;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.session;
        }
    }

    public String configuredKeyspace() {
        return this.configuredKeyspace;
    }

    public void configuredKeyspace_$eq(String x$1) {
        this.configuredKeyspace = x$1;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public void replicationFactor_$eq(int x$1) {
        this.replicationFactor = x$1;
    }

    public String replicationStrategy() {
        return this.replicationStrategy;
    }

    public CodecRegistry net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry$lzycompute() : this.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry;
    }

    private String keyspace() {
        return this.keyspace;
    }

    private Session session() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.session$lzycompute() : this.session;
    }

    @Override
    @PreDestroy
    public void close() {
        this.cluster.close();
    }

    public boolean createTable(String tableName, MapStoreTableKey tableKey) {
        Create schemaBuilder = ((Create)SchemaBuilder.createTable((String)tableName).ifNotExists()).addPartitionKey(tableKey.getHashField(), this.loadDataType(tableKey.getHashFieldType()));
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(tableKey.getRangeField())).foreach((Function1)new Serializable(this, tableKey, schemaBuilder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraMapStorePlugin $outer;
            private final MapStoreTableKey tableKey$1;
            private final Create schemaBuilder$1;

            public final Create apply(String x$1) {
                return this.schemaBuilder$1.addClusteringColumn(x$1, this.$outer.loadDataType((Class)this.tableKey$1.getRangeFieldType().get()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableKey$1 = tableKey$1;
                this.schemaBuilder$1 = schemaBuilder$1;
            }
        });
        schemaBuilder.addColumn("payload", (DataType)DataType.map((DataType)DataType.varchar(), (DataType)DataType.varchar()));
        return this.session().execute(schemaBuilder.toString()).wasApplied();
    }

    public boolean dropTable(String tableName) {
        Drop schemaBuilder = SchemaBuilder.dropTable((String)tableName).ifExists();
        return this.session().execute(schemaBuilder.toString()).wasApplied();
    }

    public void deleteItem(String tableName, MapStoreKey key) {
        CassandraKeyClause keyClause = new CassandraKeyClause(key);
        Delete.Where queryBuilder = QueryBuilder.delete().from(tableName).where(keyClause.hashClause());
        keyClause.rangeClauses().foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Delete.Where queryBuilder$1;

            public final Delete.Where apply(Clause x$2) {
                return this.queryBuilder$1.and(x$2);
            }
            {
                this.queryBuilder$1 = queryBuilder$1;
            }
        });
        this.session().execute(queryBuilder.toString());
    }

    public java.util.List<java.util.Map<String, Object>> getAllItems(String tableName) {
        Select queryBuilder = QueryBuilder.select().all().from(tableName);
        Buffer results = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.session().execute(queryBuilder.toString()).all()).asScala();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)results.map(this.rowMapper(), Buffer$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    public Optional<java.util.Map<String, Object>> getItem(String tableName, MapStoreKey key) {
        CassandraKeyClause keyClause = new CassandraKeyClause(key);
        Select.Where queryBuilder = QueryBuilder.select().all().from(tableName).where(keyClause.hashClause());
        keyClause.rangeClauses().foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Select.Where queryBuilder$2;

            public final Select.Where apply(Clause x$3) {
                return this.queryBuilder$2.and(x$3);
            }
            {
                this.queryBuilder$2 = queryBuilder$2;
            }
        });
        Row result = this.session().execute(queryBuilder.toString()).one();
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.apply((Object)result).map(this.rowMapper())));
    }

    public java.util.List<java.util.Map<String, Object>> getItems(String tableName, MapStoreKey key, MapQueryOptions options) {
        CassandraKeyClause keyClause = new CassandraKeyClause(key);
        Select.Where queryBuilder = QueryBuilder.select().all().from(tableName).where(keyClause.hashClause());
        keyClause.rangeClauses().foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Select.Where queryBuilder$3;

            public final Select.Where apply(Clause x$4) {
                return this.queryBuilder$3.and(x$4);
            }
            {
                this.queryBuilder$3 = queryBuilder$3;
            }
        });
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(key.getRangeField())).map((Function1)new Serializable(this, options){
            public static final long serialVersionUID = 0L;
            private final MapQueryOptions options$1;

            public final Ordering apply(String rangeField) {
                MapQueryOptions.Order order;
                block4: {
                    Ordering ordering;
                    block3: {
                        block2: {
                            order = this.options$1.getOrder();
                            if (!MapQueryOptions.Order.ASC.equals(order)) break block2;
                            ordering = QueryBuilder.asc((String)rangeField);
                            break block3;
                        }
                        if (!MapQueryOptions.Order.DESC.equals(order)) break block4;
                        ordering = QueryBuilder.desc((String)rangeField);
                    }
                    return ordering;
                }
                throw new MatchError((Object)order);
            }
            {
                this.options$1 = options$1;
            }
        }).foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Select.Where queryBuilder$3;

            public final Select apply(Ordering x$5) {
                return this.queryBuilder$3.orderBy(new Ordering[]{x$5});
            }
            {
                this.queryBuilder$3 = queryBuilder$3;
            }
        });
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(options.getLimit())).foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Select.Where queryBuilder$3;

            public final Select apply(Integer x$6) {
                return this.queryBuilder$3.limit(Predef$.MODULE$.Integer2int(x$6));
            }
            {
                this.queryBuilder$3 = queryBuilder$3;
            }
        });
        Buffer results = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.session().execute(queryBuilder.toString()).all()).asScala();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)results.map(this.rowMapper(), Buffer$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    public java.util.Map<String, Object> putItem(String tableName, MapStoreKey key, java.util.Map<String, Object> payload) {
        this.stripKey(key, payload);
        List keyFields = (List)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(key.getRangeField())).map((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final MapStoreKey key$1;

            public final List<String> apply(String rangeField) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.key$1.getHashField(), rangeField}));
            }
            {
                this.key$1 = key$1;
            }
        }).getOrElse((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final MapStoreKey key$1;

            public final List<String> apply() {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.key$1.getHashField()}));
            }
            {
                this.key$1 = key$1;
            }
        });
        List keyValues = (List)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(key.getRangeField())).map((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final MapStoreKey key$1;

            public final List<Object> apply(String rangeField) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.key$1.getHashValue(), this.key$1.getRangeKey().getValue()}));
            }
            {
                this.key$1 = key$1;
            }
        }).getOrElse((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final MapStoreKey key$1;

            public final List<Object> apply() {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.key$1.getHashValue()}));
            }
            {
                this.key$1 = key$1;
            }
        });
        Insert queryBuilder = QueryBuilder.insertInto((String)tableName).values((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)keyFields).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)keyValues).asJava()).value("payload", payload);
        this.session().execute(queryBuilder.toString());
        return this.getItem(tableName, key).get();
    }

    public java.util.Map<String, Object> updateItem(String tableName, MapStoreKey key, java.util.Map<String, Object> payload) {
        CassandraKeyClause keyClause = new CassandraKeyClause(key);
        Update.Where queryBuilder = QueryBuilder.update((String)tableName).where(keyClause.hashClause());
        keyClause.rangeClauses().foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Update.Where queryBuilder$4;

            public final Update.Where apply(Clause x$7) {
                return this.queryBuilder$4.and(x$7);
            }
            {
                this.queryBuilder$4 = queryBuilder$4;
            }
        });
        this.stripKey(key, payload);
        Iterable assignments = (Iterable)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(payload).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Assignment apply(Tuple2<String, Object> entry) {
                return QueryBuilder.set((String)((String)entry._1()), (Object)entry._2());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        assignments.foreach((Function1)new Serializable(this, queryBuilder){
            public static final long serialVersionUID = 0L;
            private final Update.Where queryBuilder$4;

            public final Update.Assignments apply(Assignment x$8) {
                return this.queryBuilder$4.with(x$8);
            }
            {
                this.queryBuilder$4 = queryBuilder$4;
            }
        });
        return (java.util.Map)this.rowMapper().apply((Object)this.session().execute(queryBuilder.toString()).one());
    }

    public DataType loadDataType(Class<?> fieldType) {
        block12: {
            DataType dataType;
            block3: {
                Class<?> clazz;
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    clazz = fieldType;
                                                    if (!clazz.equals(Boolean.TYPE) && !clazz.equals(Boolean.class)) break block2;
                                                    dataType = DataType.cboolean();
                                                    break block3;
                                                }
                                                if (!clazz.equals(Byte.TYPE) && !clazz.equals(Byte.class)) break block4;
                                                dataType = DataType.tinyint();
                                                break block3;
                                            }
                                            if (!clazz.equals(Date.class)) break block5;
                                            dataType = DataType.date();
                                            break block3;
                                        }
                                        if (!clazz.equals(Double.TYPE) && !clazz.equals(Double.class)) break block6;
                                        dataType = DataType.cdouble();
                                        break block3;
                                    }
                                    if (!clazz.equals(Float.TYPE) && !clazz.equals(Float.class)) break block7;
                                    dataType = DataType.cfloat();
                                    break block3;
                                }
                                if (!clazz.equals(Integer.TYPE) && !clazz.equals(Integer.class)) break block8;
                                dataType = DataType.cint();
                                break block3;
                            }
                            if (!clazz.equals(Long.TYPE) && !clazz.equals(Long.class)) break block9;
                            dataType = DataType.bigint();
                            break block3;
                        }
                        if (!clazz.equals(Short.TYPE) && !clazz.equals(Short.class)) break block10;
                        dataType = DataType.smallint();
                        break block3;
                    }
                    if (!clazz.equals(String.class)) break block11;
                    dataType = DataType.varchar();
                    break block3;
                }
                if (!clazz.equals(UUID.class)) break block12;
                dataType = DataType.uuid();
            }
            return dataType;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported Cassandra column DataType: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldType})));
    }

    public Function1<Row, java.util.Map<String, Object>> rowMapper() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraMapStorePlugin $outer;

            public final java.util.Map<String, Object> apply(Row row) {
                Buffer cols = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(row.getColumnDefinitions().asList()).asScala();
                scala.collection.immutable.Map rowMap = ((TraversableOnce)cols.map((Function1)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$rowMapper$1 $outer;
                    private final Row row$1;

                    public final Tuple2<String, Nothing$> apply(ColumnDefinitions.Definition col) {
                        return new Tuple2((Object)col.getName(), this.row$1.get(col.getName(), this.$outer.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$anonfun$$$outer().net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$codecRegistry().codecFor(col.getType())));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.row$1 = row$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                scala.collection.mutable.Map rowMMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(rowMap.toSeq());
                Option payloadMap = rowMMap.remove((Object)"payload").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.mutable.Map<String, Object> apply(Object x$9) {
                        return (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)x$9).asScala();
                    }
                });
                scala.collection.immutable.Map keyMap = rowMMap.toMap(Predef$.MODULE$.$conforms());
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)payloadMap.map((Function1)new Serializable(this, keyMap){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map keyMap$1;

                    public final scala.collection.mutable.Map<String, Object> apply(scala.collection.mutable.Map<String, Object> x$10) {
                        return x$10.$plus$plus((GenTraversableOnce)this.keyMap$1);
                    }
                    {
                        this.keyMap$1 = keyMap$1;
                    }
                }).getOrElse((Function0)new Serializable(this, keyMap){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map keyMap$1;

                    public final scala.collection.immutable.Map<String, Object> apply() {
                        return this.keyMap$1;
                    }
                    {
                        this.keyMap$1 = keyMap$1;
                    }
                })).asJava();
            }

            public /* synthetic */ CassandraMapStorePlugin net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    @Inject
    public CassandraMapStorePlugin(@ApplicationName String applicationName, Cluster cluster) {
        this.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$applicationName = applicationName;
        this.cluster = cluster;
        this.configuredKeyspace = null;
        this.replicationFactor = 2;
        this.replicationStrategy = "SimpleStrategy";
        this.keyspace = (String)Option$.MODULE$.apply((Object)this.configuredKeyspace()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraMapStorePlugin $outer;

            public final String apply() {
                return this.$outer.net$spals$appbuilder$mapstore$cassandra$CassandraMapStorePlugin$$applicationName;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

