/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.filestore.s3;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.IdentityEndpointBuilder;
import com.amazonaws.internal.ServiceEndpointBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.internal.S3RequestEndpointResolver;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.netflix.governator.annotations.Configuration;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import net.spals.appbuilder.annotations.config.ApplicationName;
import net.spals.appbuilder.annotations.service.AutoBindInMap;
import net.spals.appbuilder.filestore.core.FileStorePlugin;
import net.spals.appbuilder.filestore.core.model.FileMetadata;
import net.spals.appbuilder.filestore.core.model.FileSecurityLevel;
import net.spals.appbuilder.filestore.core.model.FileStoreKey;
import net.spals.appbuilder.filestore.core.model.FileStoreLocation;
import net.spals.appbuilder.filestore.core.model.PutFileRequest;
import net.spals.appbuilder.filestore.s3.S3EncryptionHolder;
import net.spals.appbuilder.filestore.s3.S3TransferEncryptionHolder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@AutoBindInMap(baseClass=FileStorePlugin.class, key="s3")
@ScalaSignature(bytes="\u0006\u0001\tec!B\u0001\u0003\u0001\ta!!E*4\r&dWm\u0015;pe\u0016\u0004F.^4j]*\u00111\u0001B\u0001\u0003gNR!!\u0002\u0004\u0002\u0013\u0019LG.Z:u_J,'BA\u0004\t\u0003)\t\u0007\u000f\u001d2vS2$WM\u001d\u0006\u0003\u0013)\tQa\u001d9bYNT\u0011aC\u0001\u0004]\u0016$8c\u0001\u0001\u000e+A\u0011abE\u0007\u0002\u001f)\u0011\u0001#E\u0001\u0005Y\u0006twMC\u0001\u0013\u0003\u0011Q\u0017M^1\n\u0005Qy!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001735\tqC\u0003\u0002\u0019\t\u0005!1m\u001c:f\u0013\tQrCA\bGS2,7\u000b^8sKBcWoZ5o\u0011!a\u0002A!A!\u0002\u0013q\u0012aD1qa2L7-\u0019;j_:t\u0015-\\3\u0004\u0001A\u0011q$\n\b\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%I\u0001\u0007!J,G-\u001a4\n\u0005\u0019:#AB*ue&twM\u0003\u0002%C!\u00121$\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\naaY8oM&<'B\u0001\u0018\u0007\u0003-\tgN\\8uCRLwN\\:\n\u0005AZ#aD!qa2L7-\u0019;j_:t\u0015-\\3\t\u0011I\u0002!\u0011!Q\u0001\nM\n\u0001b]\u001aDY&,g\u000e\u001e\t\u0003iqj\u0011!\u000e\u0006\u0003\u0007YR!a\u000e\u001d\u0002\u0011M,'O^5dKNT!!\u000f\u001e\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"A\u001e\u0002\u0007\r|W.\u0003\u0002>k\tA\u0011)\\1{_:\u001c6\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0003I\u00198'\u00128def\u0004H/[8o\u0011>dG-\u001a:\u0011\u0005\u0005\u0013U\"\u0001\u0002\n\u0005\r\u0013!AE*4\u000b:\u001c'/\u001f9uS>t\u0007j\u001c7eKJD\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IAR\u0001\u0012gN\"&/\u00198tM\u0016\u0014X*\u00198bO\u0016\u0014\bCA$K\u001b\u0005A%BA%6\u0003!!(/\u00198tM\u0016\u0014\u0018BA&I\u0005=!&/\u00198tM\u0016\u0014X*\u00198bO\u0016\u0014\b\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\u00025M\u001cDK]1og\u001a,'/\u00128def\u0004H/[8o\u0011>dG-\u001a:\u0011\u0005\u0005{\u0015B\u0001)\u0003\u0005i\u00196\u0007\u0016:b]N4WM]#oGJL\b\u000f^5p]\"{G\u000eZ3s\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0003\u0019a\u0014N\\5u}Q1A+V,Y3j\u0003\"!\u0011\u0001\t\u000bq\t\u0006\u0019\u0001\u0010)\u0005UK\u0003\"\u0002\u001aR\u0001\u0004\u0019\u0004\"B R\u0001\u0004\u0001\u0005\"B#R\u0001\u00041\u0005\"B'R\u0001\u0004q\u0005FA)]!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0004j]*,7\r\u001e\u0006\u0003Cj\naaZ8pO2,\u0017BA2_\u0005\u0019IeN[3di\"AQ\r\u0001a\u0001\n\u0003\u0011a-\u0001\u0005f]\u0012\u0004x.\u001b8u+\u0005q\u0002\u0002\u00035\u0001\u0001\u0004%\tAA5\u0002\u0019\u0015tG\r]8j]R|F%Z9\u0015\u0005)l\u0007C\u0001\u0011l\u0013\ta\u0017E\u0001\u0003V]&$\bb\u00028h\u0003\u0003\u0005\rAH\u0001\u0004q\u0012\n\u0004B\u00029\u0001A\u0003&a$A\u0005f]\u0012\u0004x.\u001b8uA!\"qN]>}!\t\u0019\u00180D\u0001u\u0015\tqSO\u0003\u0002wo\u0006Qqm\u001c<fe:\fGo\u001c:\u000b\u0005aT\u0014a\u00028fi\u001ad\u0017\u000e_\u0005\u0003uR\u0014QbQ8oM&<WO]1uS>t\u0017!\u0002<bYV,\u0017%A?\u0002+\u0019LG.Z*u_J,gf]\u001a/K:$\u0007o\\5oi\"\u0012qn \t\u0005\u0003\u0003\ty!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003-\u0019wN\\:ue\u0006Lg\u000e^:\u000b\t\u0005%\u00111B\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'BAA\u0007\u0003\u0015Q\u0017M^1y\u0013\u0011\t\t\"a\u0001\u0003\u000f9{GOT;mY\"I\u0011Q\u0003\u0001A\u0002\u0013\u0005!AZ\u0001\tgN\u0012UoY6fi\"Q\u0011\u0011\u0004\u0001A\u0002\u0013\u0005!!a\u0007\u0002\u0019M\u001c$)^2lKR|F%Z9\u0015\u0007)\fi\u0002\u0003\u0005o\u0003/\t\t\u00111\u0001\u001f\u0011\u001d\t\t\u0003\u0001Q!\ny\t\u0011b]\u001aCk\u000e\\W\r\u001e\u0011)\r\u0005}!o_A\u0013C\t\t9#A\ngS2,7\u000b^8sK:\u001a8G\f2vG.,G\u000fK\u0002\u0002 }D1\"!\f\u0001\u0011\u000b\u0007I\u0011\u0001\u0002\u00020\u0005A1o\r*fO&|g.\u0006\u0002\u00022A)\u0001%a\r\u00028%\u0019\u0011QG\u0011\u0003\r=\u0003H/[8o!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001fk\u0005)Qn\u001c3fY&!\u0011\u0011IA\u001e\u0005\u0019\u0011VmZ5p]\"Q\u0011Q\t\u0001\t\u0002\u0003\u0006K!!\r\u0002\u0013M\u001c$+Z4j_:\u0004\u0003\u0002CA%\u0001\u0011\u0005!!a\u0013\u0002\u0019\r\u0014X-\u0019;f\u0005V\u001c7.\u001a;\u0015\u0003)DC!a\u0012\u0002PA!\u0011\u0011KA,\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005-\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011LA*\u00055\u0001vn\u001d;D_:\u001cHO];di\"9\u0011Q\f\u0001\u0005B\u0005}\u0013A\u00033fY\u0016$XMR5mKR!\u0011\u0011MA4!\r\u0001\u00131M\u0005\u0004\u0003K\n#a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003S\nY\u00061\u0001\u0002l\u0005\u00191.Z=\u0011\t\u00055\u0014\u0011O\u0007\u0003\u0003_R1!!\u0010\u0018\u0013\u0011\t\u0019(a\u001c\u0003\u0019\u0019KG.Z*u_J,7*Z=\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z\u0005qq-\u001a;GS2,7i\u001c8uK:$H\u0003BA>\u0003'\u0003b!! \u0002\u0004\u0006\u001dUBAA@\u0015\r\t\t)E\u0001\u0005kRLG.\u0003\u0003\u0002\u0006\u0006}$\u0001C(qi&|g.\u00197\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$\u0012\u0003\tIw.\u0003\u0003\u0002\u0012\u0006-%aC%oaV$8\u000b\u001e:fC6D\u0001\"!\u001b\u0002v\u0001\u0007\u00111\u000e\u0015\u0007\u0003k\n9*a)\u0011\u000b\u0001\nI*!(\n\u0007\u0005m\u0015E\u0001\u0004uQJ|wo\u001d\t\u0005\u0003\u0013\u000by*\u0003\u0003\u0002\"\u0006-%aC%P\u000bb\u001cW\r\u001d;j_:\fdA\b\u0010\u0002&\u0006U\u0017'C\u0012\u0002(\u00065\u00161ZAX+\r1\u0017\u0011\u0016\u0003\b\u0003Wk\"\u0019AA[\u0005\u0005!\u0016\u0002BAX\u0003c\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAAZC\u00051A\u000f\u001b:poN\fB!a.\u0002>B\u0019\u0001%!/\n\u0007\u0005m\u0016EA\u0004O_RD\u0017N\\4\u0011\t\u0005}\u0016Q\u0019\b\u0004A\u0005\u0005\u0017bAAbC\u00059\u0001/Y2lC\u001e,\u0017\u0002BAd\u0003\u0013\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005\r\u0017%M\u0005$\u0003\u001b\fy-!5\u00024:\u0019\u0001%a4\n\u0007\u0005M\u0016%M\u0003#A\u0005\n\u0019NA\u0003tG\u0006d\u0017-M\u0002'\u0003;Cq!!7\u0001\t\u0003\nY.A\bhKR4\u0015\u000e\\3NKR\fG-\u0019;b)\u0011\ti.!:\u0011\r\u0005u\u00141QAp!\u0011\ti'!9\n\t\u0005\r\u0018q\u000e\u0002\r\r&dW-T3uC\u0012\fG/\u0019\u0005\t\u0003S\n9\u000e1\u0001\u0002l!2\u0011q[AL\u0003S\fdA\b\u0010\u0002l\u0006E\u0018'C\u0012\u0002(\u00065\u0016Q^AXc%\u0019\u0013QZAh\u0003_\f\u0019,M\u0003#A\u0005\n\u0019.M\u0002'\u0003;Cq!!>\u0001\t\u0003\n90A\u0004qkR4\u0015\u000e\\3\u0015\r\u0005}\u0017\u0011`A~\u0011!\tI'a=A\u0002\u0005-\u0004\u0002CA\u007f\u0003g\u0004\r!a@\u0002\u000fI,\u0017/^3tiB!\u0011Q\u000eB\u0001\u0013\u0011\u0011\u0019!a\u001c\u0003\u001dA+HOR5mKJ+\u0017/^3ti\"2\u00111_AL\u0005\u000f\tdA\b\u0010\u0003\n\t=\u0011'C\u0012\u0002(\u00065&1BAXc%\u0019\u0013QZAh\u0005\u001b\t\u0019,M\u0003#A\u0005\n\u0019.M\u0002'\u0003;C\u0001Ba\u0005\u0001\t\u0003\u0011!QC\u0001\u0012e\u0016\u001cx\u000e\u001c<f\u0005J|wo]3s+JKE\u0003\u0002B\f\u0005C\u0001BA!\u0007\u0003\u001e5\u0011!1\u0004\u0006\u0003\u0017EIAAa\b\u0003\u001c\t\u0019QKU%\t\u0011\t\r\"\u0011\u0003a\u0001\u0005K\t!b]\u001aPE*,7\r^%e!\u0011\tIDa\n\n\t\t%\u00121\b\u0002\u000b'Nz%M[3di&#\u0007\u0006\u0002B\t\u0005[\u0001BAa\f\u000385\u0011!\u0011\u0007\u0006\u0004]\tM\"b\u0001B\u001bA\u000611m\\7n_:LAA!\u000f\u00032\t\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\t\u0011\tu\u0002\u0001\"\u0001\u0003\u0005\u007f\t\u0011C]3t_24XmU\u001aPE*,7\r^%e)\u0011\u0011)C!\u0011\t\u0011\u0005%$1\ba\u0001\u0003WBCAa\u000f\u0003.!Z\u0001Aa\u0012\u0003T\tU\u0013\u0011\u000eB,!\u0011\u0011IEa\u0014\u000e\u0005\t-#b\u0001B'[\u000591/\u001a:wS\u000e,\u0017\u0002\u0002B)\u0005\u0017\u0012Q\"Q;u_\nKg\u000eZ%o\u001b\u0006\u0004\u0018!\u00032bg\u0016\u001cE.Y:tG\u0005)\u0012%A\u0002")
public class S3FileStorePlugin
implements FileStorePlugin {
    public final AmazonS3 net$spals$appbuilder$filestore$s3$S3FileStorePlugin$$s3Client;
    public final S3EncryptionHolder net$spals$appbuilder$filestore$s3$S3FileStorePlugin$$s3EncryptionHolder;
    private final TransferManager s3TransferManager;
    private final S3TransferEncryptionHolder s3TransferEncryptionHolder;
    @NotNull
    @Configuration(value="fileStore.s3.endpoint")
    private String endpoint;
    @NotNull
    @Configuration(value="fileStore.s3.bucket")
    private String s3Bucket;
    private Option<Region> s3Region;
    private volatile boolean bitmap$0;

    private Option s3Region$lzycompute() {
        S3FileStorePlugin s3FileStorePlugin = this;
        synchronized (s3FileStorePlugin) {
            if (!this.bitmap$0) {
                this.s3Region = Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ S3FileStorePlugin $outer;

                    public final Region apply() {
                        return this.$outer.net$spals$appbuilder$filestore$s3$S3FileStorePlugin$$s3Client.getRegion();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).toOption();
                this.bitmap$0 = true;
            }
            return this.s3Region;
        }
    }

    public String endpoint() {
        return this.endpoint;
    }

    public void endpoint_$eq(String x$1) {
        this.endpoint = x$1;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public void s3Bucket_$eq(String x$1) {
        this.s3Bucket = x$1;
    }

    public Option<Region> s3Region() {
        return this.bitmap$0 ? this.s3Region : this.s3Region$lzycompute();
    }

    @PostConstruct
    public void createBucket() {
        if (!this.net$spals$appbuilder$filestore$s3$S3FileStorePlugin$$s3Client.doesBucketExist(this.s3Bucket())) {
            this.net$spals$appbuilder$filestore$s3$S3FileStorePlugin$$s3Client.createBucket(this.s3Bucket());
        }
    }

    public boolean deleteFile(FileStoreKey key) {
        S3ObjectId s3ObjectId = this.resolveS3ObjectId(key);
        DeleteObjectRequest request = new DeleteObjectRequest(s3ObjectId.getBucket(), s3ObjectId.getKey());
        return Try$.MODULE$.apply((Function0)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3FileStorePlugin $outer;
            private final DeleteObjectRequest request$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$spals$appbuilder$filestore$s3$S3FileStorePlugin$$s3Client.deleteObject(this.request$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
            }
        }).isSuccess();
    }

    public Optional<InputStream> getFileContent(FileStoreKey key) throws IOException {
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.getFileMetadata(key))).map((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3FileStorePlugin $outer;
            private final FileStoreKey key$1;

            public final InputStream apply(FileMetadata fileMetadata) {
                FileSecurityLevel fileSecurityLevel;
                block7: {
                    AmazonS3 amazonS3;
                    GetObjectRequest request;
                    block6: {
                        block5: {
                            S3ObjectId s3ObjectId = this.$outer.resolveS3ObjectId(this.key$1);
                            request = new GetObjectRequest(s3ObjectId);
                            fileSecurityLevel = fileMetadata.getSecurityLevel();
                            if (!FileSecurityLevel.PUBLIC.equals(fileSecurityLevel)) break block5;
                            amazonS3 = this.$outer.net$spals$appbuilder$filestore$s3$S3FileStorePlugin$$s3Client;
                            break block6;
                        }
                        if (!FileSecurityLevel.PRIVATE.equals(fileSecurityLevel)) break block7;
                        amazonS3 = (AmazonS3)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.$outer.net$spals$appbuilder$filestore$s3$S3FileStorePlugin$$s3EncryptionHolder.value())).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Nothing$ apply() {
                                throw new UnsupportedOperationException("S3 plugin is not configured for encryption. So private file content cannot be read. Please set the s3.fileStore.encryptionKey configuration.");
                            }
                        });
                    }
                    AmazonS3 amazonS32 = amazonS3;
                    Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, request, amazonS32){
                        public static final long serialVersionUID = 0L;
                        private final GetObjectRequest request$2;
                        private final AmazonS3 amazonS3$1;

                        public final S3Object apply() {
                            return this.amazonS3$1.getObject(this.request$2);
                        }
                        {
                            this.request$2 = request$2;
                            this.amazonS3$1 = amazonS3$1;
                        }
                    });
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        S3Object s3Object = (S3Object)success.value();
                        S3ObjectInputStream s3ObjectInputStream = s3Object.getObjectContent();
                        return s3ObjectInputStream;
                    }
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable t = failure.exception();
                        throw (IOException)new IOException().initCause(t);
                    }
                    throw new MatchError((Object)try_);
                }
                throw new MatchError((Object)fileSecurityLevel);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$1 = key$1;
            }
        })));
    }

    public Optional<FileMetadata> getFileMetadata(FileStoreKey key) throws IOException {
        Try try_;
        Failure failure;
        boolean bl;
        block9: {
            Optional optional;
            block8: {
                block7: {
                    S3ObjectId s3ObjectId = this.resolveS3ObjectId(key);
                    GetObjectMetadataRequest request = new GetObjectMetadataRequest(s3ObjectId.getBucket(), s3ObjectId.getKey());
                    bl = false;
                    failure = null;
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(this, request){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ S3FileStorePlugin $outer;
                        private final GetObjectMetadataRequest request$3;

                        public final ObjectMetadata apply() {
                            return this.$outer.net$spals$appbuilder$filestore$s3$S3FileStorePlugin$$s3Client.getObjectMetadata(this.request$3);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.request$3 = request$3;
                        }
                    });
                    if (!(try_ instanceof Success)) break block7;
                    Success success = (Success)try_;
                    ObjectMetadata s3Metadata = (ObjectMetadata)success.value();
                    optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.apply((Object)s3Metadata).map((Function1)new Serializable(this, s3ObjectId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ S3FileStorePlugin $outer;
                        private final S3ObjectId s3ObjectId$1;

                        public final FileMetadata apply(ObjectMetadata s3Meta) {
                            FileSecurityLevel securityLevel = (FileSecurityLevel)Option$.MODULE$.apply((Object)s3Meta.getSSEAwsKmsKeyId()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final FileSecurityLevel apply(String x$1) {
                                    return FileSecurityLevel.PRIVATE;
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final FileSecurityLevel apply() {
                                    return FileSecurityLevel.PUBLIC;
                                }
                            });
                            return new FileMetadata.Builder().setSecurityLevel(securityLevel).setStoreLocation(FileStoreLocation.REMOTE).setURI(this.$outer.resolveBrowserURI(this.s3ObjectId$1)).build();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.s3ObjectId$1 = s3ObjectId$1;
                        }
                    })));
                    break block8;
                }
                if (!(try_ instanceof Failure)) break block9;
                bl = true;
                failure = (Failure)try_;
                Throwable s3e = failure.exception();
                if (!(s3e instanceof AmazonS3Exception)) break block9;
                AmazonS3Exception amazonS3Exception = (AmazonS3Exception)s3e;
                int n = amazonS3Exception.getStatusCode();
                switch (n) {
                    default: {
                        throw (IOException)new IOException().initCause((Throwable)amazonS3Exception);
                    }
                    case 404: 
                }
                optional = Optional.empty();
            }
            return optional;
        }
        if (bl) {
            Throwable t = failure.exception();
            throw (IOException)new IOException().initCause(t);
        }
        throw new MatchError((Object)try_);
    }

    /*
     * WARNING - void declaration
     */
    public FileMetadata putFile(FileStoreKey key, PutFileRequest request) throws IOException {
        Option option;
        block8: {
            FileSecurityLevel fileSecurityLevel;
            block11: {
                FileSecurityLevel fileSecurityLevel2;
                block14: {
                    Try try_;
                    block5: {
                        FileMetadata fileMetadata;
                        CannedAccessControlList cannedAccessControlList;
                        ObjectMetadata objectMetadata;
                        TransferManager localTransferManager;
                        InputStream fileStreamForUpload;
                        block13: {
                            block12: {
                                TransferManager transferManager;
                                block10: {
                                    block9: {
                                        InputStream inputStream;
                                        block7: {
                                            block6: {
                                                option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(request.getContentLength()));
                                                if (!(option instanceof Some)) break block6;
                                                inputStream = request.getFileStream();
                                                break block7;
                                            }
                                            if (!None$.MODULE$.equals(option)) break block8;
                                            inputStream = new BufferedInputStream(request.getFileStream(), 1);
                                        }
                                        fileStreamForUpload = inputStream;
                                        fileSecurityLevel = request.getFileSecurityLevel();
                                        if (!FileSecurityLevel.PUBLIC.equals(fileSecurityLevel)) break block9;
                                        transferManager = this.s3TransferManager;
                                        break block10;
                                    }
                                    if (!FileSecurityLevel.PRIVATE.equals(fileSecurityLevel)) break block11;
                                    transferManager = (TransferManager)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.s3TransferEncryptionHolder.value())).getOrElse((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Nothing$ apply() {
                                            throw new UnsupportedOperationException("S3 plugin is not configured for encryption. So private files cannot be written. Please set the s3.fileStore.encryptionKey configuration.");
                                        }
                                    });
                                }
                                localTransferManager = transferManager;
                                objectMetadata = new ObjectMetadata();
                                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(request.getContentLength())).foreach((Function1)new Serializable(this, objectMetadata){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectMetadata objectMetadata$1;

                                    public final void apply(Long x$2) {
                                        this.objectMetadata$1.setContentLength(Predef$.MODULE$.Long2long(x$2));
                                    }
                                    {
                                        this.objectMetadata$1 = objectMetadata$1;
                                    }
                                });
                                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(request.getContentType())).foreach((Function1)new Serializable(this, objectMetadata){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectMetadata objectMetadata$1;

                                    public final void apply(String x$3) {
                                        this.objectMetadata$1.setContentType(x$3);
                                    }
                                    {
                                        this.objectMetadata$1 = objectMetadata$1;
                                    }
                                });
                                fileSecurityLevel2 = request.getFileSecurityLevel();
                                if (!FileSecurityLevel.PUBLIC.equals(fileSecurityLevel2)) break block12;
                                cannedAccessControlList = CannedAccessControlList.PublicRead;
                                break block13;
                            }
                            if (!FileSecurityLevel.PRIVATE.equals(fileSecurityLevel2)) break block14;
                            cannedAccessControlList = CannedAccessControlList.Private;
                        }
                        CannedAccessControlList accessControlList = cannedAccessControlList;
                        S3ObjectId s3ObjectId = this.resolveS3ObjectId(key);
                        PutObjectRequest putObjectRequest = new PutObjectRequest(s3ObjectId.getBucket(), s3ObjectId.getKey(), fileStreamForUpload, objectMetadata);
                        putObjectRequest.withCannedAcl(accessControlList);
                        try {
                            FileMetadata fileMetadata2;
                            try_ = Try$.MODULE$.apply((Function0)new Serializable(this, localTransferManager, putObjectRequest){
                                public static final long serialVersionUID = 0L;
                                private final TransferManager localTransferManager$1;
                                private final PutObjectRequest putObjectRequest$1;

                                public final UploadResult apply() {
                                    return this.localTransferManager$1.upload(this.putObjectRequest$1).waitForUploadResult();
                                }
                                {
                                    this.localTransferManager$1 = localTransferManager$1;
                                    this.putObjectRequest$1 = putObjectRequest$1;
                                }
                            });
                            if (!(try_ instanceof Success)) break block5;
                            fileMetadata = fileMetadata2 = new FileMetadata.Builder().setSecurityLevel(request.getFileSecurityLevel()).setStoreLocation(FileStoreLocation.REMOTE).setURI(this.resolveBrowserURI(s3ObjectId)).build();
                        }
                        catch (Throwable throwable) {
                            void var3_5;
                            var3_5.close();
                            throw throwable;
                        }
                        fileStreamForUpload.close();
                        return fileMetadata;
                    }
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable t = failure.exception();
                        throw (IOException)new IOException().initCause(t);
                    }
                    throw new MatchError((Object)try_);
                }
                throw new MatchError((Object)fileSecurityLevel2);
            }
            throw new MatchError((Object)fileSecurityLevel);
        }
        throw new MatchError((Object)option);
    }

    @VisibleForTesting
    public URI resolveBrowserURI(S3ObjectId s3ObjectId) {
        String s3Endpoint = (String)this.s3Region().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Region region) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{region.toAWSRegion().getServiceEndpoint("s3")}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3FileStorePlugin $outer;

            public final String apply() {
                return this.$outer.endpoint();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        DefaultRequest request = new DefaultRequest("Amazon S3");
        IdentityEndpointBuilder serviceEndpointBuilder = new IdentityEndpointBuilder(new URI(s3Endpoint));
        S3RequestEndpointResolver requestEndpointResolver = new S3RequestEndpointResolver((ServiceEndpointBuilder)serviceEndpointBuilder, true, s3ObjectId.getBucket(), s3ObjectId.getKey());
        requestEndpointResolver.resolveRequestEndpoint((Request)request);
        return ServiceUtils.convertRequestToUrl((Request)request, (boolean)false, (boolean)true).toURI();
    }

    @VisibleForTesting
    public S3ObjectId resolveS3ObjectId(FileStoreKey key) {
        return new S3ObjectId(this.s3Bucket(), key.toGlobalId("/"));
    }

    @Inject
    public S3FileStorePlugin(@ApplicationName String applicationName, AmazonS3 s3Client, S3EncryptionHolder s3EncryptionHolder, TransferManager s3TransferManager, S3TransferEncryptionHolder s3TransferEncryptionHolder) {
        this.net$spals$appbuilder$filestore$s3$S3FileStorePlugin$$s3Client = s3Client;
        this.net$spals$appbuilder$filestore$s3$S3FileStorePlugin$$s3EncryptionHolder = s3EncryptionHolder;
        this.s3TransferManager = s3TransferManager;
        this.s3TransferEncryptionHolder = s3TransferEncryptionHolder;
        this.endpoint = null;
        this.s3Bucket = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-filestore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{applicationName.toLowerCase()}));
    }
}

