/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.app.grpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerTransportFilter;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.stub.AbstractStub;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.ws.rs.Path;
import net.spals.appbuilder.app.core.jaxrs.JaxRsCorsModule;
import net.spals.appbuilder.app.grpc.GrpcWebServerModule_Builder;
import net.spals.appbuilder.config.matcher.TypeLiteralMatchers;
import net.spals.appbuilder.config.service.ServiceScan;
import net.spals.appbuilder.graph.model.IServiceGraphVertex;
import net.spals.appbuilder.graph.model.ServiceGraph;
import net.spals.appbuilder.graph.model.ServiceGraphVertex;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GrpcWebServerModule
extends AbstractModule
implements InjectionListener<Object>,
TypeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcWebServerModule.class);
    private static GrpcWebServerVertex theWebServerVertex = new GrpcWebServerVertex();

    public abstract boolean isWebServerAutoBindingEnabled();

    public abstract String getApplicationName();

    public abstract ServerBuilder<?> getGrpcExternalServerBuilder();

    public abstract ServiceGraph getServiceGraph();

    public abstract ServiceScan getServiceScan();

    public abstract boolean isRestServerEnabled();

    public abstract boolean isCorsEnabled();

    public abstract Optional<InProcessServerBuilder> getGrpcInternalServerBuilder();

    public abstract Optional<ResourceConfig> getRestResourceConfig();

    abstract Map<Class<?>, Constructor<?>> getRestResourceConstructors();

    protected void configure() {
        Matcher typeMatcher = TypeLiteralMatchers.rawTypeThat((Matcher)Matchers.subclassesOf(BindableService.class)).or(TypeLiteralMatchers.rawTypeThat((Matcher)Matchers.subclassesOf(ServerServiceDefinition.class))).or(TypeLiteralMatchers.rawTypeThat((Matcher)Matchers.subclassesOf(ServerInterceptor.class))).or(TypeLiteralMatchers.rawTypeThat((Matcher)Matchers.subclassesOf(ServerTransportFilter.class))).or(TypeLiteralMatchers.rawTypeThat((Matcher)Matchers.subclassesOf(HandlerRegistry.class))).or(TypeLiteralMatchers.rawTypeThat((Matcher)Matchers.subclassesOf(DecompressorRegistry.class))).or(TypeLiteralMatchers.rawTypeThat((Matcher)Matchers.subclassesOf(CompressorRegistry.class)));
        this.bindListener(typeMatcher, this);
    }

    public void afterInjection(Object wsComponent) {
        LOGGER.info("Registering WebServer component: {}", wsComponent);
        this.registerGrpcComponent(wsComponent);
        Key wsKey = Key.get((TypeLiteral)TypeLiteral.get(wsComponent.getClass()));
        ServiceGraphVertex wsVertex = ServiceGraphVertex.createGraphVertex((Key)wsKey, (Object)wsComponent);
        this.getServiceGraph().addVertex((Object)wsVertex);
        this.getServiceGraph().addEdge((Object)wsVertex, (Object)theWebServerVertex);
    }

    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
        if (this.isWebServerAutoBindingEnabled()) {
            if (!this.getServiceGraph().containsVertex((Object)theWebServerVertex)) {
                this.getServiceGraph().addVertex((Object)theWebServerVertex);
            }
            typeEncounter.register((InjectionListener)this);
        }
    }

    Object createGrpcStub(BindableService grpcService) {
        Method newStubMethod;
        Preconditions.checkState((boolean)this.isRestServerEnabled());
        Preconditions.checkState((boolean)this.getGrpcInternalServerBuilder().isPresent());
        Class<?> grpcServiceClass = grpcService.getClass().getSuperclass().getEnclosingClass();
        try {
            newStubMethod = grpcServiceClass.getMethod("newStub", Channel.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find newStub method for gRPC service class: " + grpcServiceClass.getName(), e);
        }
        ManagedChannel internalServerChannel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.getApplicationName()).usePlaintext().directExecutor()).build();
        try {
            return newStubMethod.invoke(grpcServiceClass, internalServerChannel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create a new stub for gRPC service class: " + grpcServiceClass.getName(), e);
        }
    }

    Object createRestResource(Object grpcStub) {
        Constructor<?> restResourceCtor = Optional.ofNullable(this.getRestResourceConstructors().get(grpcStub.getClass())).orElseThrow(() -> new RuntimeException("No RESTful resource found on classpath for gRPC stub: " + grpcStub.getClass().getName() + ". This means that you haven't run the grpc-jersey protoc plugin OR you haven't annotated the RPC protobuf correctly OR you need to create a Jersey resource class by hand (if you aren't using the grpc-jersey plugin."));
        restResourceCtor.setAccessible(true);
        try {
            return restResourceCtor.newInstance(grpcStub);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate Jersey Rest resource: " + restResourceCtor.getName());
        }
    }

    void registerGrpcComponent(Object wsComponent) {
        if (wsComponent instanceof BindableService) {
            BindableService grpcService = (BindableService)wsComponent;
            this.getGrpcExternalServerBuilder().addService(grpcService);
            if (this.isRestServerEnabled()) {
                this.registerRestService(grpcService);
            }
        } else if (wsComponent instanceof ServerInterceptor) {
            ServerInterceptor grpcInterceptor = (ServerInterceptor)wsComponent;
            this.getGrpcExternalServerBuilder().intercept(grpcInterceptor);
            if (this.isRestServerEnabled()) {
                this.registerRestInterceptor(grpcInterceptor);
            }
        } else if (wsComponent instanceof ServerServiceDefinition) {
            this.getGrpcExternalServerBuilder().addService((ServerServiceDefinition)wsComponent);
        } else if (wsComponent instanceof ServerTransportFilter) {
            this.getGrpcExternalServerBuilder().addTransportFilter((ServerTransportFilter)wsComponent);
        } else if (wsComponent instanceof HandlerRegistry) {
            this.getGrpcExternalServerBuilder().fallbackHandlerRegistry((HandlerRegistry)wsComponent);
        } else if (wsComponent instanceof DecompressorRegistry) {
            this.getGrpcExternalServerBuilder().decompressorRegistry((DecompressorRegistry)wsComponent);
        } else if (wsComponent instanceof CompressorRegistry) {
            this.getGrpcExternalServerBuilder().compressorRegistry((CompressorRegistry)wsComponent);
        } else {
            throw new UnsupportedOperationException("Error exists in AppBuilder framework. Encountered web server of type " + wsComponent.getClass().getName() + " for auto-binding, but do not know how to bind this type within Grpc.");
        }
    }

    void registerRestInterceptor(ServerInterceptor grpcInterceptor) {
        Preconditions.checkState((boolean)this.isRestServerEnabled());
        Preconditions.checkState((boolean)this.getGrpcInternalServerBuilder().isPresent());
        this.getGrpcInternalServerBuilder().get().intercept(grpcInterceptor);
    }

    void registerRestService(BindableService grpcService) {
        Preconditions.checkState((boolean)this.isRestServerEnabled());
        Preconditions.checkState((boolean)this.getGrpcInternalServerBuilder().isPresent());
        Preconditions.checkState((boolean)this.getRestResourceConfig().isPresent());
        this.getGrpcInternalServerBuilder().get().addService(grpcService);
        Object grpcStub = this.createGrpcStub(grpcService);
        Object restResource = this.createRestResource(grpcStub);
        this.getRestResourceConfig().get().register(restResource);
    }

    static class GrpcWebServerVertex
    implements IServiceGraphVertex<String> {
        GrpcWebServerVertex() {
        }

        public Key<String> getGuiceKey() {
            return Key.get(String.class);
        }

        public String getServiceInstance() {
            return "GRPC WEBSERVER";
        }

        public String toString(String separator) {
            return this.getServiceInstance();
        }
    }

    public static class Builder
    extends GrpcWebServerModule_Builder {
        public Builder() {
            this.setWebServerAutoBindingEnabled(true);
            this.setServiceScan(ServiceScan.empty());
            this.setRestServerEnabled(false);
            this.setCorsEnabled(false);
            this.setGrpcInternalServerBuilder(Optional.empty());
            this.setRestResourceConfig(Optional.empty());
        }

        public Builder enableRestServer(InProcessServerBuilder grpcInternalServerBuilder, ResourceConfig restResourceConfig) {
            this.setRestServerEnabled(true);
            this.setGrpcInternalServerBuilder(grpcInternalServerBuilder);
            this.setRestResourceConfig(restResourceConfig);
            return this;
        }

        @Override
        public GrpcWebServerModule build() {
            if (this.isRestServerEnabled()) {
                ServiceScan serviceScan = this.getServiceScanBuilder().build();
                Set restClasses = serviceScan.getReflections().getTypesAnnotatedWith(Path.class);
                restClasses.stream().flatMap(jerseyClass -> {
                    ArrayList ctors = Lists.newArrayList((Object[])jerseyClass.getDeclaredConstructors());
                    Optional<Constructor> restCtor = ctors.stream().filter(ctor -> ctor.getParameterCount() == 1).filter(ctor -> AbstractStub.class.isAssignableFrom(ctor.getParameterTypes()[0])).findFirst();
                    return restCtor.map(rCtor -> Collections.singleton(rCtor).stream()).orElseGet(() -> Stream.empty());
                }).forEach(restCtor -> this.putRestResourceConstructors((Class)restCtor.getParameterTypes()[0], (Constructor)restCtor));
                if (this.isCorsEnabled() && this.getRestResourceConfig().isPresent()) {
                    ((ResourceConfig)this.getRestResourceConfig().get()).register(JaxRsCorsModule.JaxRsCorsFilter.class);
                }
            }
            return super.build();
        }
    }
}

