/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.app.grpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.spals.appbuilder.app.grpc.GrpcWebServerModule;
import net.spals.appbuilder.config.service.ServiceScan;
import net.spals.appbuilder.graph.model.ServiceGraph;
import org.glassfish.jersey.server.ResourceConfig;

abstract class GrpcWebServerModule_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private boolean webServerAutoBindingEnabled;
    private String applicationName;
    private ServerBuilder<?> grpcExternalServerBuilder;
    private ServiceGraph serviceGraph;
    private final ServiceScan.Builder serviceScan = new ServiceScan.Builder();
    private boolean restServerEnabled;
    private boolean corsEnabled;
    private InProcessServerBuilder grpcInternalServerBuilder = null;
    private ResourceConfig restResourceConfig = null;
    private final LinkedHashMap<Class<?>, Constructor<?>> restResourceConstructors = new LinkedHashMap();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    GrpcWebServerModule_Builder() {
    }

    public static GrpcWebServerModule.Builder from(GrpcWebServerModule value) {
        return new GrpcWebServerModule.Builder().mergeFrom(value);
    }

    public GrpcWebServerModule.Builder setWebServerAutoBindingEnabled(boolean webServerAutoBindingEnabled) {
        this.webServerAutoBindingEnabled = webServerAutoBindingEnabled;
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder mapWebServerAutoBindingEnabled(UnaryOperator<Boolean> mapper) {
        return this.setWebServerAutoBindingEnabled((Boolean)mapper.apply(this.isWebServerAutoBindingEnabled()));
    }

    public boolean isWebServerAutoBindingEnabled() {
        return this.webServerAutoBindingEnabled;
    }

    public GrpcWebServerModule.Builder setApplicationName(String applicationName) {
        this.applicationName = (String)Preconditions.checkNotNull((Object)applicationName);
        this._unsetProperties.remove((Object)Property.APPLICATION_NAME);
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder mapApplicationName(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setApplicationName((String)mapper.apply(this.getApplicationName()));
    }

    public String getApplicationName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.APPLICATION_NAME) ? 1 : 0) != 0, (Object)"applicationName not set");
        return this.applicationName;
    }

    public GrpcWebServerModule.Builder setGrpcExternalServerBuilder(ServerBuilder<?> grpcExternalServerBuilder) {
        this.grpcExternalServerBuilder = (ServerBuilder)Preconditions.checkNotNull(grpcExternalServerBuilder);
        this._unsetProperties.remove((Object)Property.GRPC_EXTERNAL_SERVER_BUILDER);
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder mapGrpcExternalServerBuilder(UnaryOperator<ServerBuilder<?>> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setGrpcExternalServerBuilder((ServerBuilder)mapper.apply(this.getGrpcExternalServerBuilder()));
    }

    public ServerBuilder<?> getGrpcExternalServerBuilder() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.GRPC_EXTERNAL_SERVER_BUILDER) ? 1 : 0) != 0, (Object)"grpcExternalServerBuilder not set");
        return this.grpcExternalServerBuilder;
    }

    public GrpcWebServerModule.Builder setServiceGraph(ServiceGraph serviceGraph) {
        this.serviceGraph = (ServiceGraph)Preconditions.checkNotNull((Object)serviceGraph);
        this._unsetProperties.remove((Object)Property.SERVICE_GRAPH);
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder mapServiceGraph(UnaryOperator<ServiceGraph> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setServiceGraph((ServiceGraph)mapper.apply(this.getServiceGraph()));
    }

    public ServiceGraph getServiceGraph() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.SERVICE_GRAPH) ? 1 : 0) != 0, (Object)"serviceGraph not set");
        return this.serviceGraph;
    }

    public GrpcWebServerModule.Builder setServiceScan(ServiceScan serviceScan) {
        this.serviceScan.clear();
        this.serviceScan.mergeFrom((ServiceScan)Preconditions.checkNotNull((Object)serviceScan));
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder setServiceScan(ServiceScan.Builder builder) {
        return this.setServiceScan(builder.build());
    }

    public GrpcWebServerModule.Builder mutateServiceScan(Consumer<ServiceScan.Builder> mutator) {
        mutator.accept(this.serviceScan);
        return (GrpcWebServerModule.Builder)this;
    }

    public ServiceScan.Builder getServiceScanBuilder() {
        return this.serviceScan;
    }

    public GrpcWebServerModule.Builder setRestServerEnabled(boolean restServerEnabled) {
        this.restServerEnabled = restServerEnabled;
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder mapRestServerEnabled(UnaryOperator<Boolean> mapper) {
        return this.setRestServerEnabled((Boolean)mapper.apply(this.isRestServerEnabled()));
    }

    public boolean isRestServerEnabled() {
        return this.restServerEnabled;
    }

    public GrpcWebServerModule.Builder setCorsEnabled(boolean corsEnabled) {
        this.corsEnabled = corsEnabled;
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder mapCorsEnabled(UnaryOperator<Boolean> mapper) {
        return this.setCorsEnabled((Boolean)mapper.apply(this.isCorsEnabled()));
    }

    public boolean isCorsEnabled() {
        return this.corsEnabled;
    }

    public GrpcWebServerModule.Builder setGrpcInternalServerBuilder(InProcessServerBuilder grpcInternalServerBuilder) {
        this.grpcInternalServerBuilder = (InProcessServerBuilder)Preconditions.checkNotNull((Object)grpcInternalServerBuilder);
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder setGrpcInternalServerBuilder(Optional<? extends InProcessServerBuilder> grpcInternalServerBuilder) {
        if (grpcInternalServerBuilder.isPresent()) {
            return this.setGrpcInternalServerBuilder(grpcInternalServerBuilder.get());
        }
        return this.clearGrpcInternalServerBuilder();
    }

    public GrpcWebServerModule.Builder setNullableGrpcInternalServerBuilder(@Nullable InProcessServerBuilder grpcInternalServerBuilder) {
        if (grpcInternalServerBuilder != null) {
            return this.setGrpcInternalServerBuilder(grpcInternalServerBuilder);
        }
        return this.clearGrpcInternalServerBuilder();
    }

    public GrpcWebServerModule.Builder mapGrpcInternalServerBuilder(UnaryOperator<InProcessServerBuilder> mapper) {
        return this.setGrpcInternalServerBuilder(this.getGrpcInternalServerBuilder().map(mapper));
    }

    public GrpcWebServerModule.Builder clearGrpcInternalServerBuilder() {
        this.grpcInternalServerBuilder = null;
        return (GrpcWebServerModule.Builder)this;
    }

    public Optional<InProcessServerBuilder> getGrpcInternalServerBuilder() {
        return Optional.ofNullable(this.grpcInternalServerBuilder);
    }

    public GrpcWebServerModule.Builder setRestResourceConfig(ResourceConfig restResourceConfig) {
        this.restResourceConfig = (ResourceConfig)Preconditions.checkNotNull((Object)restResourceConfig);
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder setRestResourceConfig(Optional<? extends ResourceConfig> restResourceConfig) {
        if (restResourceConfig.isPresent()) {
            return this.setRestResourceConfig(restResourceConfig.get());
        }
        return this.clearRestResourceConfig();
    }

    public GrpcWebServerModule.Builder setNullableRestResourceConfig(@Nullable ResourceConfig restResourceConfig) {
        if (restResourceConfig != null) {
            return this.setRestResourceConfig(restResourceConfig);
        }
        return this.clearRestResourceConfig();
    }

    public GrpcWebServerModule.Builder mapRestResourceConfig(UnaryOperator<ResourceConfig> mapper) {
        return this.setRestResourceConfig(this.getRestResourceConfig().map(mapper));
    }

    public GrpcWebServerModule.Builder clearRestResourceConfig() {
        this.restResourceConfig = null;
        return (GrpcWebServerModule.Builder)this;
    }

    public Optional<ResourceConfig> getRestResourceConfig() {
        return Optional.ofNullable(this.restResourceConfig);
    }

    public GrpcWebServerModule.Builder putRestResourceConstructors(Class<?> key, Constructor<?> value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        this.restResourceConstructors.put(key, value);
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder putAllRestResourceConstructors(Map<? extends Class<?>, ? extends Constructor<?>> map) {
        for (Map.Entry<Class<?>, Constructor<?>> entry : map.entrySet()) {
            this.putRestResourceConstructors(entry.getKey(), entry.getValue());
        }
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder removeRestResourceConstructors(Class<?> key) {
        Preconditions.checkNotNull(key);
        this.restResourceConstructors.remove(key);
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder mutateRestResourceConstructors(Consumer<? super Map<Class<?>, Constructor<?>>> mutator) {
        mutator.accept(this.restResourceConstructors);
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder clearRestResourceConstructors() {
        this.restResourceConstructors.clear();
        return (GrpcWebServerModule.Builder)this;
    }

    public Map<Class<?>, Constructor<?>> getRestResourceConstructors() {
        return Collections.unmodifiableMap(this.restResourceConstructors);
    }

    public GrpcWebServerModule.Builder mergeFrom(GrpcWebServerModule value) {
        GrpcWebServerModule.Builder _defaults = new GrpcWebServerModule.Builder();
        if (!Objects.equals(value.isWebServerAutoBindingEnabled(), ((GrpcWebServerModule_Builder)_defaults).isWebServerAutoBindingEnabled())) {
            this.setWebServerAutoBindingEnabled(value.isWebServerAutoBindingEnabled());
        }
        if (_defaults._unsetProperties.contains((Object)Property.APPLICATION_NAME) || !Objects.equals(value.getApplicationName(), ((GrpcWebServerModule_Builder)_defaults).getApplicationName())) {
            this.setApplicationName(value.getApplicationName());
        }
        if (_defaults._unsetProperties.contains((Object)Property.GRPC_EXTERNAL_SERVER_BUILDER) || !Objects.equals(value.getGrpcExternalServerBuilder(), ((GrpcWebServerModule_Builder)_defaults).getGrpcExternalServerBuilder())) {
            this.setGrpcExternalServerBuilder(value.getGrpcExternalServerBuilder());
        }
        if (_defaults._unsetProperties.contains((Object)Property.SERVICE_GRAPH) || !Objects.equals(value.getServiceGraph(), ((GrpcWebServerModule_Builder)_defaults).getServiceGraph())) {
            this.setServiceGraph(value.getServiceGraph());
        }
        this.serviceScan.mergeFrom(value.getServiceScan());
        if (!Objects.equals(value.isRestServerEnabled(), ((GrpcWebServerModule_Builder)_defaults).isRestServerEnabled())) {
            this.setRestServerEnabled(value.isRestServerEnabled());
        }
        if (!Objects.equals(value.isCorsEnabled(), ((GrpcWebServerModule_Builder)_defaults).isCorsEnabled())) {
            this.setCorsEnabled(value.isCorsEnabled());
        }
        value.getGrpcInternalServerBuilder().ifPresent(this::setGrpcInternalServerBuilder);
        value.getRestResourceConfig().ifPresent(this::setRestResourceConfig);
        this.putAllRestResourceConstructors(value.getRestResourceConstructors());
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder mergeFrom(GrpcWebServerModule.Builder template) {
        GrpcWebServerModule.Builder _defaults = new GrpcWebServerModule.Builder();
        GrpcWebServerModule.Builder base = template;
        if (!Objects.equals(template.isWebServerAutoBindingEnabled(), ((GrpcWebServerModule_Builder)_defaults).isWebServerAutoBindingEnabled())) {
            this.setWebServerAutoBindingEnabled(template.isWebServerAutoBindingEnabled());
        }
        if (!(base._unsetProperties.contains((Object)Property.APPLICATION_NAME) || !_defaults._unsetProperties.contains((Object)Property.APPLICATION_NAME) && Objects.equals(template.getApplicationName(), ((GrpcWebServerModule_Builder)_defaults).getApplicationName()))) {
            this.setApplicationName(template.getApplicationName());
        }
        if (!(base._unsetProperties.contains((Object)Property.GRPC_EXTERNAL_SERVER_BUILDER) || !_defaults._unsetProperties.contains((Object)Property.GRPC_EXTERNAL_SERVER_BUILDER) && Objects.equals(template.getGrpcExternalServerBuilder(), ((GrpcWebServerModule_Builder)_defaults).getGrpcExternalServerBuilder()))) {
            this.setGrpcExternalServerBuilder(template.getGrpcExternalServerBuilder());
        }
        if (!(base._unsetProperties.contains((Object)Property.SERVICE_GRAPH) || !_defaults._unsetProperties.contains((Object)Property.SERVICE_GRAPH) && Objects.equals(template.getServiceGraph(), ((GrpcWebServerModule_Builder)_defaults).getServiceGraph()))) {
            this.setServiceGraph(template.getServiceGraph());
        }
        this.serviceScan.mergeFrom(template.getServiceScanBuilder());
        if (!Objects.equals(template.isRestServerEnabled(), ((GrpcWebServerModule_Builder)_defaults).isRestServerEnabled())) {
            this.setRestServerEnabled(template.isRestServerEnabled());
        }
        if (!Objects.equals(template.isCorsEnabled(), ((GrpcWebServerModule_Builder)_defaults).isCorsEnabled())) {
            this.setCorsEnabled(template.isCorsEnabled());
        }
        template.getGrpcInternalServerBuilder().ifPresent(this::setGrpcInternalServerBuilder);
        template.getRestResourceConfig().ifPresent(this::setRestResourceConfig);
        this.putAllRestResourceConstructors(template.restResourceConstructors);
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule.Builder clear() {
        GrpcWebServerModule.Builder _defaults = new GrpcWebServerModule.Builder();
        this.webServerAutoBindingEnabled = _defaults.webServerAutoBindingEnabled;
        this.applicationName = _defaults.applicationName;
        this.grpcExternalServerBuilder = _defaults.grpcExternalServerBuilder;
        this.serviceGraph = _defaults.serviceGraph;
        this.serviceScan.clear();
        this.restServerEnabled = _defaults.restServerEnabled;
        this.corsEnabled = _defaults.corsEnabled;
        this.grpcInternalServerBuilder = _defaults.grpcInternalServerBuilder;
        this.restResourceConfig = _defaults.restResourceConfig;
        this.restResourceConstructors.clear();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (GrpcWebServerModule.Builder)this;
    }

    public GrpcWebServerModule build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public GrpcWebServerModule buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends GrpcWebServerModule {
        private final boolean webServerAutoBindingEnabled;
        private final String applicationName;
        private final ServerBuilder<?> grpcExternalServerBuilder;
        private final ServiceGraph serviceGraph;
        private final ServiceScan serviceScan;
        private final boolean restServerEnabled;
        private final boolean corsEnabled;
        private final InProcessServerBuilder grpcInternalServerBuilder;
        private final ResourceConfig restResourceConfig;
        private final Map<Class<?>, Constructor<?>> restResourceConstructors;
        private final EnumSet<Property> _unsetProperties;

        Partial(GrpcWebServerModule_Builder builder) {
            this.webServerAutoBindingEnabled = builder.webServerAutoBindingEnabled;
            this.applicationName = builder.applicationName;
            this.grpcExternalServerBuilder = builder.grpcExternalServerBuilder;
            this.serviceGraph = builder.serviceGraph;
            this.serviceScan = builder.serviceScan.buildPartial();
            this.restServerEnabled = builder.restServerEnabled;
            this.corsEnabled = builder.corsEnabled;
            this.grpcInternalServerBuilder = builder.grpcInternalServerBuilder;
            this.restResourceConfig = builder.restResourceConfig;
            this.restResourceConstructors = ImmutableMap.copyOf((Map)builder.restResourceConstructors);
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public boolean isWebServerAutoBindingEnabled() {
            return this.webServerAutoBindingEnabled;
        }

        @Override
        public String getApplicationName() {
            if (this._unsetProperties.contains((Object)Property.APPLICATION_NAME)) {
                throw new UnsupportedOperationException("applicationName not set");
            }
            return this.applicationName;
        }

        @Override
        public ServerBuilder<?> getGrpcExternalServerBuilder() {
            if (this._unsetProperties.contains((Object)Property.GRPC_EXTERNAL_SERVER_BUILDER)) {
                throw new UnsupportedOperationException("grpcExternalServerBuilder not set");
            }
            return this.grpcExternalServerBuilder;
        }

        @Override
        public ServiceGraph getServiceGraph() {
            if (this._unsetProperties.contains((Object)Property.SERVICE_GRAPH)) {
                throw new UnsupportedOperationException("serviceGraph not set");
            }
            return this.serviceGraph;
        }

        @Override
        public ServiceScan getServiceScan() {
            return this.serviceScan;
        }

        @Override
        public boolean isRestServerEnabled() {
            return this.restServerEnabled;
        }

        @Override
        public boolean isCorsEnabled() {
            return this.corsEnabled;
        }

        @Override
        public Optional<InProcessServerBuilder> getGrpcInternalServerBuilder() {
            return Optional.ofNullable(this.grpcInternalServerBuilder);
        }

        @Override
        public Optional<ResourceConfig> getRestResourceConfig() {
            return Optional.ofNullable(this.restResourceConfig);
        }

        @Override
        public Map<Class<?>, Constructor<?>> getRestResourceConstructors() {
            return this.restResourceConstructors;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)((Object)obj);
            return Objects.equals(this.webServerAutoBindingEnabled, other.webServerAutoBindingEnabled) && Objects.equals(this.applicationName, other.applicationName) && Objects.equals(this.grpcExternalServerBuilder, other.grpcExternalServerBuilder) && Objects.equals(this.serviceGraph, other.serviceGraph) && Objects.equals(this.serviceScan, other.serviceScan) && Objects.equals(this.restServerEnabled, other.restServerEnabled) && Objects.equals(this.corsEnabled, other.corsEnabled) && Objects.equals(this.grpcInternalServerBuilder, other.grpcInternalServerBuilder) && Objects.equals(this.restResourceConfig, other.restResourceConfig) && Objects.equals(this.restResourceConstructors, other.restResourceConstructors) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.webServerAutoBindingEnabled, this.applicationName, this.grpcExternalServerBuilder, this.serviceGraph, this.serviceScan, this.restServerEnabled, this.corsEnabled, this.grpcInternalServerBuilder, this.restResourceConfig, this.restResourceConstructors, this._unsetProperties);
        }

        public String toString() {
            return "partial GrpcWebServerModule{" + COMMA_JOINER.join((Object)("webServerAutoBindingEnabled=" + this.webServerAutoBindingEnabled), (Object)(!this._unsetProperties.contains((Object)Property.APPLICATION_NAME) ? "applicationName=" + this.applicationName : null), new Object[]{!this._unsetProperties.contains((Object)Property.GRPC_EXTERNAL_SERVER_BUILDER) ? "grpcExternalServerBuilder=" + this.grpcExternalServerBuilder : null, !this._unsetProperties.contains((Object)Property.SERVICE_GRAPH) ? "serviceGraph=" + this.serviceGraph : null, "serviceScan=" + this.serviceScan, "restServerEnabled=" + this.restServerEnabled, "corsEnabled=" + this.corsEnabled, this.grpcInternalServerBuilder != null ? "grpcInternalServerBuilder=" + this.grpcInternalServerBuilder : null, this.restResourceConfig != null ? "restResourceConfig=" + this.restResourceConfig : null, "restResourceConstructors=" + this.restResourceConstructors}) + "}";
        }
    }

    private static final class Value
    extends GrpcWebServerModule {
        private final boolean webServerAutoBindingEnabled;
        private final String applicationName;
        private final ServerBuilder<?> grpcExternalServerBuilder;
        private final ServiceGraph serviceGraph;
        private final ServiceScan serviceScan;
        private final boolean restServerEnabled;
        private final boolean corsEnabled;
        private final InProcessServerBuilder grpcInternalServerBuilder;
        private final ResourceConfig restResourceConfig;
        private final Map<Class<?>, Constructor<?>> restResourceConstructors;

        private Value(GrpcWebServerModule_Builder builder) {
            this.webServerAutoBindingEnabled = builder.webServerAutoBindingEnabled;
            this.applicationName = builder.applicationName;
            this.grpcExternalServerBuilder = builder.grpcExternalServerBuilder;
            this.serviceGraph = builder.serviceGraph;
            this.serviceScan = builder.serviceScan.build();
            this.restServerEnabled = builder.restServerEnabled;
            this.corsEnabled = builder.corsEnabled;
            this.grpcInternalServerBuilder = builder.grpcInternalServerBuilder;
            this.restResourceConfig = builder.restResourceConfig;
            this.restResourceConstructors = ImmutableMap.copyOf((Map)builder.restResourceConstructors);
        }

        @Override
        public boolean isWebServerAutoBindingEnabled() {
            return this.webServerAutoBindingEnabled;
        }

        @Override
        public String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public ServerBuilder<?> getGrpcExternalServerBuilder() {
            return this.grpcExternalServerBuilder;
        }

        @Override
        public ServiceGraph getServiceGraph() {
            return this.serviceGraph;
        }

        @Override
        public ServiceScan getServiceScan() {
            return this.serviceScan;
        }

        @Override
        public boolean isRestServerEnabled() {
            return this.restServerEnabled;
        }

        @Override
        public boolean isCorsEnabled() {
            return this.corsEnabled;
        }

        @Override
        public Optional<InProcessServerBuilder> getGrpcInternalServerBuilder() {
            return Optional.ofNullable(this.grpcInternalServerBuilder);
        }

        @Override
        public Optional<ResourceConfig> getRestResourceConfig() {
            return Optional.ofNullable(this.restResourceConfig);
        }

        @Override
        public Map<Class<?>, Constructor<?>> getRestResourceConstructors() {
            return this.restResourceConstructors;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)((Object)obj);
            return Objects.equals(this.webServerAutoBindingEnabled, other.webServerAutoBindingEnabled) && Objects.equals(this.applicationName, other.applicationName) && Objects.equals(this.grpcExternalServerBuilder, other.grpcExternalServerBuilder) && Objects.equals(this.serviceGraph, other.serviceGraph) && Objects.equals(this.serviceScan, other.serviceScan) && Objects.equals(this.restServerEnabled, other.restServerEnabled) && Objects.equals(this.corsEnabled, other.corsEnabled) && Objects.equals(this.grpcInternalServerBuilder, other.grpcInternalServerBuilder) && Objects.equals(this.restResourceConfig, other.restResourceConfig) && Objects.equals(this.restResourceConstructors, other.restResourceConstructors);
        }

        public int hashCode() {
            return Objects.hash(this.webServerAutoBindingEnabled, this.applicationName, this.grpcExternalServerBuilder, this.serviceGraph, this.serviceScan, this.restServerEnabled, this.corsEnabled, this.grpcInternalServerBuilder, this.restResourceConfig, this.restResourceConstructors);
        }

        public String toString() {
            return "GrpcWebServerModule{" + COMMA_JOINER.join((Object)("webServerAutoBindingEnabled=" + this.webServerAutoBindingEnabled), (Object)("applicationName=" + this.applicationName), new Object[]{"grpcExternalServerBuilder=" + this.grpcExternalServerBuilder, "serviceGraph=" + this.serviceGraph, "serviceScan=" + this.serviceScan, "restServerEnabled=" + this.restServerEnabled, "corsEnabled=" + this.corsEnabled, this.grpcInternalServerBuilder != null ? "grpcInternalServerBuilder=" + this.grpcInternalServerBuilder : null, this.restResourceConfig != null ? "restResourceConfig=" + this.restResourceConfig : null, "restResourceConstructors=" + this.restResourceConstructors}) + "}";
        }
    }

    private static enum Property {
        APPLICATION_NAME("applicationName"),
        GRPC_EXTERNAL_SERVER_BUILDER("grpcExternalServerBuilder"),
        SERVICE_GRAPH("serviceGraph");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

