/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.app.grpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.typesafe.config.Config;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.netty.channel.Channel;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.UriBuilder;
import net.spals.appbuilder.app.core.App;
import net.spals.appbuilder.app.core.WebAppBuilder;
import net.spals.appbuilder.app.core.generic.GenericWorkerApp;
import net.spals.appbuilder.app.grpc.GrpcWebServerModule;
import net.spals.appbuilder.config.service.ServiceScan;
import net.spals.appbuilder.executor.core.ExecutorServiceFactory;
import net.spals.appbuilder.graph.model.ServiceGraphFormat;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainerProvider;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GrpcWebApp
implements App {
    private final AtomicReference<App> appDelegateRef = new AtomicReference();
    private final AtomicReference<Server> grpcExternalServerRef = new AtomicReference();
    private final AtomicReference<Optional<Server>> grpcInternalServerRef = new AtomicReference(Optional.empty());
    private final AtomicReference<Optional<ResourceConfig>> restResourceConfigRef = new AtomicReference(Optional.empty());
    private final AtomicReference<Optional<Channel>> restServerRef = new AtomicReference(Optional.empty());
    private final AtomicBoolean isConfigured = new AtomicBoolean(false);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    @VisibleForTesting
    final Builder grpcWebAppBuilder;

    protected GrpcWebApp(int grpcPort) {
        this.grpcWebAppBuilder = new Builder(new GenericWorkerApp.Builder(this.getClass().getSimpleName(), LoggerFactory.getLogger(this.getClass())), ServerBuilder.forPort((int)grpcPort), this);
    }

    protected abstract void configure(Builder var1);

    synchronized GrpcWebApp runConfigure() {
        if (!this.isConfigured.getAndSet(true)) {
            this.configure(this.grpcWebAppBuilder);
            return this.grpcWebAppBuilder.build();
        }
        return this;
    }

    @VisibleForTesting
    Server getGrpcExternalServer() {
        return this.grpcExternalServerRef.get();
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public final void awaitTermination() throws InterruptedException {
        this.runConfigure().grpcExternalServerRef.get().awaitTermination();
    }

    public final int getGrpcPort() {
        return this.runConfigure().grpcExternalServerRef.get().getPort();
    }

    public final int getRestPort() {
        return this.getGrpcPort() + 10;
    }

    @VisibleForTesting
    final synchronized void shutdown() {
        if (this.isRunning.getAndSet(false)) {
            this.isStarted.set(false);
            this.restServerRef.get().ifPresent(restServer -> restServer.close());
            this.grpcInternalServerRef.get().ifPresent(grpcInternalServer -> grpcInternalServer.shutdown());
            this.runConfigure().grpcExternalServerRef.get().shutdown();
        }
    }

    @VisibleForTesting
    final synchronized void shutdownNow() {
        if (this.isRunning.getAndSet(false)) {
            this.isStarted.set(false);
            this.restServerRef.get().ifPresent(restServer -> restServer.close());
            this.grpcInternalServerRef.get().ifPresent(grpcInternalServer -> grpcInternalServer.shutdownNow());
            this.runConfigure().grpcExternalServerRef.get().shutdownNow();
        }
    }

    public final synchronized void start() throws IOException {
        if (!this.isStarted.getAndSet(true)) {
            Server grpcExternalServer = this.runConfigure().grpcExternalServerRef.get();
            grpcExternalServer.start();
            this.getLogger().info("gRPC external server started (listening on " + this.getGrpcPort() + ")");
            if (this.grpcInternalServerRef.get().isPresent()) {
                this.grpcInternalServerRef.get().get().start();
                this.getLogger().info("gRPC internal server started");
            }
            this.restResourceConfigRef.get().ifPresent(resourceConfig -> {
                int restPort = this.getRestPort();
                URI baseUri = UriBuilder.fromUri((String)"http://localhost/").port(restPort).build(new Object[0]);
                Channel restServer = NettyHttpContainerProvider.createHttp2Server((URI)baseUri, (ResourceConfig)resourceConfig, null);
                this.getLogger().info("RESTful external server started (listening on " + restPort + ")");
                this.restServerRef.set(Optional.of(restServer));
            });
            this.isRunning.set(true);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                System.err.println("*** shutting down gRPC web app due to JVM shutdown");
                this.shutdown();
                System.err.println("*** gRPC server shut down");
            }));
        }
    }

    public final Logger getLogger() {
        return this.runConfigure().appDelegateRef.get().getLogger();
    }

    public final String getName() {
        return this.runConfigure().appDelegateRef.get().getName();
    }

    public final Config getServiceConfig() {
        return this.runConfigure().appDelegateRef.get().getServiceConfig();
    }

    public final Injector getServiceInjector() {
        return this.runConfigure().appDelegateRef.get().getServiceInjector();
    }

    public static class Builder
    implements WebAppBuilder<GrpcWebApp> {
        private final GenericWorkerApp.Builder appDelegateBuilder;
        private final GrpcWebApp grpcWebApp;
        private final GrpcWebServerModule.Builder webServerModuleBuilder = new GrpcWebServerModule.Builder();

        Builder(GenericWorkerApp.Builder appDelegateBuilder, ServerBuilder<?> grpcExternalServerBuilder, GrpcWebApp grpcWebApp) {
            this.appDelegateBuilder = appDelegateBuilder;
            this.webServerModuleBuilder.setApplicationName(appDelegateBuilder.getName());
            this.setGrpcExternalServerBuilder(grpcExternalServerBuilder);
            this.grpcWebApp = grpcWebApp;
        }

        public Builder addModule(Module module) {
            this.appDelegateBuilder.addModule(module);
            return this;
        }

        public Builder directExecutor() {
            this.webServerModuleBuilder.getGrpcExternalServerBuilder().directExecutor();
            return this;
        }

        public Builder disableErrorOnServiceLeaks() {
            this.appDelegateBuilder.disableErrorOnServiceLeaks();
            return this;
        }

        public Builder disableWebServerAutoBinding() {
            this.webServerModuleBuilder.setWebServerAutoBindingEnabled(false);
            return this;
        }

        public Builder enableBindingOverrides() {
            this.appDelegateBuilder.enableBindingOverrides();
            return this;
        }

        public Builder enableCors() {
            this.webServerModuleBuilder.setCorsEnabled(true);
            return this;
        }

        public Builder enableRequestScoping() {
            throw new UnsupportedOperationException("Coming soon.");
        }

        public Builder enableRestServer() {
            this.webServerModuleBuilder.enableRestServer(InProcessServerBuilder.forName((String)this.appDelegateBuilder.getName()), new ResourceConfig());
            return this;
        }

        public Builder enableServiceGraph(ServiceGraphFormat graphFormat) {
            this.appDelegateBuilder.enableServiceGraph(graphFormat);
            return this;
        }

        public Builder handshakeTimeout(long timeout, TimeUnit unit) {
            this.webServerModuleBuilder.getGrpcExternalServerBuilder().handshakeTimeout(timeout, unit);
            return this;
        }

        @VisibleForTesting
        Builder setGrpcExternalServerBuilder(ServerBuilder<?> grpcExternalServerBuilder) {
            this.webServerModuleBuilder.setGrpcExternalServerBuilder((ServerBuilder)grpcExternalServerBuilder);
            return this;
        }

        public Builder setServiceConfig(Config serviceConfig) {
            this.appDelegateBuilder.setServiceConfig(serviceConfig);
            return this;
        }

        public Builder setServiceConfigFromClasspath(String serviceConfigFileName) {
            this.appDelegateBuilder.setServiceConfigFromClasspath(serviceConfigFileName);
            return this;
        }

        public Builder setServiceScan(ServiceScan serviceScan) {
            this.appDelegateBuilder.setServiceScan(serviceScan);
            this.webServerModuleBuilder.setServiceScan(serviceScan);
            return this;
        }

        public Builder useTransportSecurity(File certChain, File privateKey) {
            this.webServerModuleBuilder.getGrpcExternalServerBuilder().useTransportSecurity(certChain, privateKey);
            return this;
        }

        public GrpcWebApp build() {
            this.webServerModuleBuilder.setServiceGraph(this.appDelegateBuilder.getServiceGraph());
            GrpcWebServerModule webServerModule = this.webServerModuleBuilder.build();
            this.appDelegateBuilder.addModule((Module)webServerModule);
            GenericWorkerApp appDelegate = this.appDelegateBuilder.build();
            this.grpcWebApp.appDelegateRef.set(appDelegate);
            this.registerGrpcServerExecutor(appDelegate.getServiceInjector());
            Server grpcExternalServer = webServerModule.getGrpcExternalServerBuilder().build();
            this.grpcWebApp.grpcExternalServerRef.set(grpcExternalServer);
            this.grpcWebApp.grpcInternalServerRef.set(webServerModule.getGrpcInternalServerBuilder().map(grpcInternalServerBuilder -> grpcInternalServerBuilder.build()));
            this.grpcWebApp.restResourceConfigRef.set(webServerModule.getRestResourceConfig());
            return this.grpcWebApp;
        }

        private void registerGrpcServerExecutor(Injector serviceInjector) {
            Key executorServiceBindingKey = Key.get(ExecutorServiceFactory.class);
            Optional.ofNullable(serviceInjector.getExistingBinding(executorServiceBindingKey)).map(binding -> (ExecutorServiceFactory)serviceInjector.getInstance(binding.getKey())).map(executorServiceFactory -> {
                ExecutorServiceFactory.Key grpcExecutorKey = new ExecutorServiceFactory.Key.Builder(this.webServerModuleBuilder.getGrpcExternalServerBuilder().getClass()).build();
                return executorServiceFactory.createCachedThreadPool(grpcExecutorKey);
            }).ifPresent(executor -> {
                this.webServerModuleBuilder.getGrpcExternalServerBuilder().executor((Executor)executor);
                this.webServerModuleBuilder.getGrpcInternalServerBuilder().ifPresent(grpcInternalServerBuilder -> {
                    InProcessServerBuilder cfr_ignored_0 = (InProcessServerBuilder)grpcInternalServerBuilder.executor((Executor)executor);
                });
            });
        }
    }
}

