/**
 * Generated by Scrooge
 *   version: 4.16.0
 *   rev: 0201cac9fdd6188248d42da91fd14c87744cc4a5
 *   built at: 20170421-125131
 */
package com.twitter.finagle.thrift.thriftscala

import com.twitter.scrooge.{
  HasThriftStructCodec3,
  LazyTProtocol,
  TFieldBlob,
  ThriftException,
  ThriftStruct,
  ThriftStructCodec3,
  ThriftStructFieldInfo,
  ThriftStructMetaData,
  ThriftUtil
}
import org.apache.thrift.protocol._
import org.apache.thrift.transport.{TMemoryBuffer, TTransport}
import java.nio.ByteBuffer
import java.util.Arrays
import scala.collection.immutable.{Map => immutable$Map}
import scala.collection.mutable.Builder
import scala.collection.mutable.{
  ArrayBuffer => mutable$ArrayBuffer, Buffer => mutable$Buffer,
  HashMap => mutable$HashMap, HashSet => mutable$HashSet}
import scala.collection.{Map, Set}

/**
 * Binary annotations are tags applied to a Span to give it context. For
 * example, a binary annotation of "http.uri" could the path to a resource in a
 * RPC call.
 *
 * Binary annotations of type STRING are always queryable, though more a
 * historical implementation detail than a structural concern.
 *
 * Binary annotations can repeat, and vary on the host. Similar to Annotation,
 * the host indicates who logged the event. This allows you to tell the
 * difference between the client and server side of the same key. For example,
 * the key "http.uri" might be different on the client and server side due to
 * rewriting, like "/api/v1/myresource" vs "/myresource. Via the host field,
 * you can see the different points of view, which often help in debugging.
 */
object BinaryAnnotation extends ThriftStructCodec3[BinaryAnnotation] {
  private val NoPassthroughFields = immutable$Map.empty[Short, TFieldBlob]
  val Struct = new TStruct("BinaryAnnotation")
  val KeyField = new TField("key", TType.STRING, 1)
  val KeyFieldManifest = implicitly[Manifest[String]]
  val ValueField = new TField("value", TType.STRING, 2)
  val ValueFieldManifest = implicitly[Manifest[ByteBuffer]]
  val AnnotationTypeField = new TField("annotation_type", TType.ENUM, 3)
  val AnnotationTypeFieldI32 = new TField("annotation_type", TType.I32, 3)
  val AnnotationTypeFieldManifest = implicitly[Manifest[com.twitter.finagle.thrift.thriftscala.AnnotationType]]
  val HostField = new TField("host", TType.STRUCT, 4)
  val HostFieldManifest = implicitly[Manifest[com.twitter.finagle.thrift.thriftscala.Endpoint]]

  /**
   * Field information in declaration order.
   */
  lazy val fieldInfos: scala.List[ThriftStructFieldInfo] = scala.List[ThriftStructFieldInfo](
    new ThriftStructFieldInfo(
      KeyField,
      false,
      false,
      KeyFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None
    ),
    new ThriftStructFieldInfo(
      ValueField,
      false,
      false,
      ValueFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None
    ),
    new ThriftStructFieldInfo(
      AnnotationTypeField,
      false,
      false,
      AnnotationTypeFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None
    ),
    new ThriftStructFieldInfo(
      HostField,
      true,
      false,
      HostFieldManifest,
      _root_.scala.None,
      _root_.scala.None,
      immutable$Map.empty[String, String],
      immutable$Map.empty[String, String],
      None
    )
  )

  lazy val structAnnotations: immutable$Map[String, String] =
    immutable$Map.empty[String, String]

  /**
   * Checks that all required fields are non-null.
   */
  def validate(_item: BinaryAnnotation): Unit = {
  }

  def withoutPassthroughFields(original: BinaryAnnotation): BinaryAnnotation =
    new Immutable(
      key =
        {
          val field = original.key
          field
        },
      value =
        {
          val field = original.value
          field
        },
      annotationType =
        {
          val field = original.annotationType
          field
        },
      host =
        {
          val field = original.host
          field.map { field =>
            com.twitter.finagle.thrift.thriftscala.Endpoint.withoutPassthroughFields(field)
          }
        }
    )

  override def encode(_item: BinaryAnnotation, _oproto: TProtocol): Unit = {
    _item.write(_oproto)
  }

  private[this] def lazyDecode(_iprot: LazyTProtocol): BinaryAnnotation = {

    var keyOffset: Int = -1
    var value: ByteBuffer = null
    var annotationType: com.twitter.finagle.thrift.thriftscala.AnnotationType = null
    var host: Option[com.twitter.finagle.thrift.thriftscala.Endpoint] = None

    var _passthroughFields: Builder[(Short, TFieldBlob), immutable$Map[Short, TFieldBlob]] = null
    var _done = false
    val _start_offset = _iprot.offset

    _iprot.readStructBegin()
    while (!_done) {
      val _field = _iprot.readFieldBegin()
      if (_field.`type` == TType.STOP) {
        _done = true
      } else {
        _field.id match {
          case 1 =>
            _field.`type` match {
              case TType.STRING =>
                keyOffset = _iprot.offsetSkipString
    
              case _actualType =>
                val _expectedType = TType.STRING
                throw new TProtocolException(
                  "Received wrong type for field 'key' (expected=%s, actual=%s).".format(
                    ttypeToString(_expectedType),
                    ttypeToString(_actualType)
                  )
                )
            }
          case 2 =>
            _field.`type` match {
              case TType.STRING =>
    
                value = readValueValue(_iprot)
              case _actualType =>
                val _expectedType = TType.STRING
                throw new TProtocolException(
                  "Received wrong type for field 'value' (expected=%s, actual=%s).".format(
                    ttypeToString(_expectedType),
                    ttypeToString(_actualType)
                  )
                )
            }
          case 3 =>
            _field.`type` match {
              case TType.I32 | TType.ENUM =>
    
                annotationType = readAnnotationTypeValue(_iprot)
              case _actualType =>
                val _expectedType = TType.ENUM
                throw new TProtocolException(
                  "Received wrong type for field 'annotationType' (expected=%s, actual=%s).".format(
                    ttypeToString(_expectedType),
                    ttypeToString(_actualType)
                  )
                )
            }
          case 4 =>
            _field.`type` match {
              case TType.STRUCT =>
    
                host = Some(readHostValue(_iprot))
              case _actualType =>
                val _expectedType = TType.STRUCT
                throw new TProtocolException(
                  "Received wrong type for field 'host' (expected=%s, actual=%s).".format(
                    ttypeToString(_expectedType),
                    ttypeToString(_actualType)
                  )
                )
            }
          case _ =>
            if (_passthroughFields == null)
              _passthroughFields = immutable$Map.newBuilder[Short, TFieldBlob]
            _passthroughFields += (_field.id -> TFieldBlob.read(_field, _iprot))
        }
        _iprot.readFieldEnd()
      }
    }
    _iprot.readStructEnd()

    new LazyImmutable(
      _iprot,
      _iprot.buffer,
      _start_offset,
      _iprot.offset,
      keyOffset,
      value,
      annotationType,
      host,
      if (_passthroughFields == null)
        NoPassthroughFields
      else
        _passthroughFields.result()
    )
  }

  override def decode(_iprot: TProtocol): BinaryAnnotation =
    _iprot match {
      case i: LazyTProtocol => lazyDecode(i)
      case i => eagerDecode(i)
    }

  private[this] def eagerDecode(_iprot: TProtocol): BinaryAnnotation = {
    var key: String = null
    var value: ByteBuffer = null
    var annotationType: com.twitter.finagle.thrift.thriftscala.AnnotationType = null
    var host: _root_.scala.Option[com.twitter.finagle.thrift.thriftscala.Endpoint] = _root_.scala.None
    var _passthroughFields: Builder[(Short, TFieldBlob), immutable$Map[Short, TFieldBlob]] = null
    var _done = false

    _iprot.readStructBegin()
    while (!_done) {
      val _field = _iprot.readFieldBegin()
      if (_field.`type` == TType.STOP) {
        _done = true
      } else {
        _field.id match {
          case 1 =>
            _field.`type` match {
              case TType.STRING =>
                key = readKeyValue(_iprot)
              case _actualType =>
                val _expectedType = TType.STRING
                throw new TProtocolException(
                  "Received wrong type for field 'key' (expected=%s, actual=%s).".format(
                    ttypeToString(_expectedType),
                    ttypeToString(_actualType)
                  )
                )
            }
          case 2 =>
            _field.`type` match {
              case TType.STRING =>
                value = readValueValue(_iprot)
              case _actualType =>
                val _expectedType = TType.STRING
                throw new TProtocolException(
                  "Received wrong type for field 'value' (expected=%s, actual=%s).".format(
                    ttypeToString(_expectedType),
                    ttypeToString(_actualType)
                  )
                )
            }
          case 3 =>
            _field.`type` match {
              case TType.I32 | TType.ENUM =>
                annotationType = readAnnotationTypeValue(_iprot)
              case _actualType =>
                val _expectedType = TType.ENUM
                throw new TProtocolException(
                  "Received wrong type for field 'annotationType' (expected=%s, actual=%s).".format(
                    ttypeToString(_expectedType),
                    ttypeToString(_actualType)
                  )
                )
            }
          case 4 =>
            _field.`type` match {
              case TType.STRUCT =>
                host = _root_.scala.Some(readHostValue(_iprot))
              case _actualType =>
                val _expectedType = TType.STRUCT
                throw new TProtocolException(
                  "Received wrong type for field 'host' (expected=%s, actual=%s).".format(
                    ttypeToString(_expectedType),
                    ttypeToString(_actualType)
                  )
                )
            }
          case _ =>
            if (_passthroughFields == null)
              _passthroughFields = immutable$Map.newBuilder[Short, TFieldBlob]
            _passthroughFields += (_field.id -> TFieldBlob.read(_field, _iprot))
        }
        _iprot.readFieldEnd()
      }
    }
    _iprot.readStructEnd()

    new Immutable(
      key,
      value,
      annotationType,
      host,
      if (_passthroughFields == null)
        NoPassthroughFields
      else
        _passthroughFields.result()
    )
  }

  def apply(
    key: String,
    value: ByteBuffer,
    annotationType: com.twitter.finagle.thrift.thriftscala.AnnotationType,
    host: _root_.scala.Option[com.twitter.finagle.thrift.thriftscala.Endpoint] = _root_.scala.None
  ): BinaryAnnotation =
    new Immutable(
      key,
      value,
      annotationType,
      host
    )

  def unapply(_item: BinaryAnnotation): _root_.scala.Option[_root_.scala.Tuple4[String, ByteBuffer, com.twitter.finagle.thrift.thriftscala.AnnotationType, Option[com.twitter.finagle.thrift.thriftscala.Endpoint]]] = _root_.scala.Some(_item.toTuple)


  @inline private def readKeyValue(_iprot: TProtocol): String = {
    _iprot.readString()
  }

  @inline private def writeKeyField(key_item: String, _oprot: TProtocol): Unit = {
    _oprot.writeFieldBegin(KeyField)
    writeKeyValue(key_item, _oprot)
    _oprot.writeFieldEnd()
  }

  @inline private def writeKeyValue(key_item: String, _oprot: TProtocol): Unit = {
    _oprot.writeString(key_item)
  }

  @inline private def readValueValue(_iprot: TProtocol): ByteBuffer = {
    _iprot.readBinary()
  }

  @inline private def writeValueField(value_item: ByteBuffer, _oprot: TProtocol): Unit = {
    _oprot.writeFieldBegin(ValueField)
    writeValueValue(value_item, _oprot)
    _oprot.writeFieldEnd()
  }

  @inline private def writeValueValue(value_item: ByteBuffer, _oprot: TProtocol): Unit = {
    _oprot.writeBinary(value_item)
  }

  @inline private def readAnnotationTypeValue(_iprot: TProtocol): com.twitter.finagle.thrift.thriftscala.AnnotationType = {
    com.twitter.finagle.thrift.thriftscala.AnnotationType.getOrUnknown(_iprot.readI32())
  }

  @inline private def writeAnnotationTypeField(annotationType_item: com.twitter.finagle.thrift.thriftscala.AnnotationType, _oprot: TProtocol): Unit = {
    _oprot.writeFieldBegin(AnnotationTypeFieldI32)
    writeAnnotationTypeValue(annotationType_item, _oprot)
    _oprot.writeFieldEnd()
  }

  @inline private def writeAnnotationTypeValue(annotationType_item: com.twitter.finagle.thrift.thriftscala.AnnotationType, _oprot: TProtocol): Unit = {
    _oprot.writeI32(annotationType_item.value)
  }

  @inline private def readHostValue(_iprot: TProtocol): com.twitter.finagle.thrift.thriftscala.Endpoint = {
    com.twitter.finagle.thrift.thriftscala.Endpoint.decode(_iprot)
  }

  @inline private def writeHostField(host_item: com.twitter.finagle.thrift.thriftscala.Endpoint, _oprot: TProtocol): Unit = {
    _oprot.writeFieldBegin(HostField)
    writeHostValue(host_item, _oprot)
    _oprot.writeFieldEnd()
  }

  @inline private def writeHostValue(host_item: com.twitter.finagle.thrift.thriftscala.Endpoint, _oprot: TProtocol): Unit = {
    host_item.write(_oprot)
  }


  object Immutable extends ThriftStructCodec3[BinaryAnnotation] {
    override def encode(_item: BinaryAnnotation, _oproto: TProtocol): Unit = { _item.write(_oproto) }
    override def decode(_iprot: TProtocol): BinaryAnnotation = BinaryAnnotation.decode(_iprot)
    override lazy val metaData: ThriftStructMetaData[BinaryAnnotation] = BinaryAnnotation.metaData
  }

  /**
   * The default read-only implementation of BinaryAnnotation.  You typically should not need to
   * directly reference this class; instead, use the BinaryAnnotation.apply method to construct
   * new instances.
   */
  class Immutable(
      val key: String,
      val value: ByteBuffer,
      val annotationType: com.twitter.finagle.thrift.thriftscala.AnnotationType,
      val host: _root_.scala.Option[com.twitter.finagle.thrift.thriftscala.Endpoint],
      override val _passthroughFields: immutable$Map[Short, TFieldBlob])
    extends BinaryAnnotation {
    def this(
      key: String,
      value: ByteBuffer,
      annotationType: com.twitter.finagle.thrift.thriftscala.AnnotationType,
      host: _root_.scala.Option[com.twitter.finagle.thrift.thriftscala.Endpoint] = _root_.scala.None
    ) = this(
      key,
      value,
      annotationType,
      host,
      Map.empty
    )
  }

  /**
   * This is another Immutable, this however keeps strings as lazy values that are lazily decoded from the backing
   * array byte on read.
   */
  private[this] class LazyImmutable(
      _proto: LazyTProtocol,
      _buf: Array[Byte],
      _start_offset: Int,
      _end_offset: Int,
      keyOffset: Int,
      val value: ByteBuffer,
      val annotationType: com.twitter.finagle.thrift.thriftscala.AnnotationType,
      val host: _root_.scala.Option[com.twitter.finagle.thrift.thriftscala.Endpoint],
      override val _passthroughFields: immutable$Map[Short, TFieldBlob])
    extends BinaryAnnotation {

    override def write(_oprot: TProtocol): Unit = {
      _oprot match {
        case i: LazyTProtocol => i.writeRaw(_buf, _start_offset, _end_offset - _start_offset)
        case _ => super.write(_oprot)
      }
    }

    lazy val key: String =
      if (keyOffset == -1)
        null
      else {
        _proto.decodeString(_buf, keyOffset)
      }

    /**
     * Override the super hash code to make it a lazy val rather than def.
     *
     * Calculating the hash code can be expensive, caching it where possible
     * can provide significant performance wins. (Key in a hash map for instance)
     * Usually not safe since the normal constructor will accept a mutable map or
     * set as an arg
     * Here however we control how the class is generated from serialized data.
     * With the class private and the contract that we throw away our mutable references
     * having the hash code lazy here is safe.
     */
    override lazy val hashCode = super.hashCode
  }

  /**
   * This Proxy trait allows you to extend the BinaryAnnotation trait with additional state or
   * behavior and implement the read-only methods from BinaryAnnotation using an underlying
   * instance.
   */
  trait Proxy extends BinaryAnnotation {
    protected def _underlying_BinaryAnnotation: BinaryAnnotation
    override def key: String = _underlying_BinaryAnnotation.key
    override def value: ByteBuffer = _underlying_BinaryAnnotation.value
    override def annotationType: com.twitter.finagle.thrift.thriftscala.AnnotationType = _underlying_BinaryAnnotation.annotationType
    override def host: _root_.scala.Option[com.twitter.finagle.thrift.thriftscala.Endpoint] = _underlying_BinaryAnnotation.host
    override def _passthroughFields = _underlying_BinaryAnnotation._passthroughFields
  }
}

trait BinaryAnnotation
  extends ThriftStruct
  with _root_.scala.Product4[String, ByteBuffer, com.twitter.finagle.thrift.thriftscala.AnnotationType, Option[com.twitter.finagle.thrift.thriftscala.Endpoint]]
  with HasThriftStructCodec3[BinaryAnnotation]
  with java.io.Serializable
{
  import BinaryAnnotation._

  def key: String
  def value: ByteBuffer
  def annotationType: com.twitter.finagle.thrift.thriftscala.AnnotationType
  def host: _root_.scala.Option[com.twitter.finagle.thrift.thriftscala.Endpoint]

  def _passthroughFields: immutable$Map[Short, TFieldBlob] = immutable$Map.empty

  def _1 = key
  def _2 = value
  def _3 = annotationType
  def _4 = host

  def toTuple: _root_.scala.Tuple4[String, ByteBuffer, com.twitter.finagle.thrift.thriftscala.AnnotationType, Option[com.twitter.finagle.thrift.thriftscala.Endpoint]] = {
    (
      key,
      value,
      annotationType,
      host
    )
  }


  /**
   * Gets a field value encoded as a binary blob using TCompactProtocol.  If the specified field
   * is present in the passthrough map, that value is returned.  Otherwise, if the specified field
   * is known and not optional and set to None, then the field is serialized and returned.
   */
  def getFieldBlob(_fieldId: Short): _root_.scala.Option[TFieldBlob] = {
    lazy val _buff = new TMemoryBuffer(32)
    lazy val _oprot = new TCompactProtocol(_buff)
    _passthroughFields.get(_fieldId) match {
      case blob: _root_.scala.Some[TFieldBlob] => blob
      case _root_.scala.None => {
        val _fieldOpt: _root_.scala.Option[TField] =
          _fieldId match {
            case 1 =>
              if (key ne null) {
                writeKeyValue(key, _oprot)
                _root_.scala.Some(BinaryAnnotation.KeyField)
              } else {
                _root_.scala.None
              }
            case 2 =>
              if (value ne null) {
                writeValueValue(value, _oprot)
                _root_.scala.Some(BinaryAnnotation.ValueField)
              } else {
                _root_.scala.None
              }
            case 3 =>
              if (annotationType ne null) {
                writeAnnotationTypeValue(annotationType, _oprot)
                _root_.scala.Some(BinaryAnnotation.AnnotationTypeField)
              } else {
                _root_.scala.None
              }
            case 4 =>
              if (host.isDefined) {
                writeHostValue(host.get, _oprot)
                _root_.scala.Some(BinaryAnnotation.HostField)
              } else {
                _root_.scala.None
              }
            case _ => _root_.scala.None
          }
        _fieldOpt match {
          case _root_.scala.Some(_field) =>
            val _data = Arrays.copyOfRange(_buff.getArray, 0, _buff.length)
            _root_.scala.Some(TFieldBlob(_field, _data))
          case _root_.scala.None =>
            _root_.scala.None
        }
      }
    }
  }

  /**
   * Collects TCompactProtocol-encoded field values according to `getFieldBlob` into a map.
   */
  def getFieldBlobs(ids: TraversableOnce[Short]): immutable$Map[Short, TFieldBlob] =
    (ids flatMap { id => getFieldBlob(id) map { id -> _ } }).toMap

  /**
   * Sets a field using a TCompactProtocol-encoded binary blob.  If the field is a known
   * field, the blob is decoded and the field is set to the decoded value.  If the field
   * is unknown and passthrough fields are enabled, then the blob will be stored in
   * _passthroughFields.
   */
  def setField(_blob: TFieldBlob): BinaryAnnotation = {
    var key: String = this.key
    var value: ByteBuffer = this.value
    var annotationType: com.twitter.finagle.thrift.thriftscala.AnnotationType = this.annotationType
    var host: _root_.scala.Option[com.twitter.finagle.thrift.thriftscala.Endpoint] = this.host
    var _passthroughFields = this._passthroughFields
    _blob.id match {
      case 1 =>
        key = readKeyValue(_blob.read)
      case 2 =>
        value = readValueValue(_blob.read)
      case 3 =>
        annotationType = readAnnotationTypeValue(_blob.read)
      case 4 =>
        host = _root_.scala.Some(readHostValue(_blob.read))
      case _ => _passthroughFields += (_blob.id -> _blob)
    }
    new Immutable(
      key,
      value,
      annotationType,
      host,
      _passthroughFields
    )
  }

  /**
   * If the specified field is optional, it is set to None.  Otherwise, if the field is
   * known, it is reverted to its default value; if the field is unknown, it is removed
   * from the passthroughFields map, if present.
   */
  def unsetField(_fieldId: Short): BinaryAnnotation = {
    var key: String = this.key
    var value: ByteBuffer = this.value
    var annotationType: com.twitter.finagle.thrift.thriftscala.AnnotationType = this.annotationType
    var host: _root_.scala.Option[com.twitter.finagle.thrift.thriftscala.Endpoint] = this.host

    _fieldId match {
      case 1 =>
        key = null
      case 2 =>
        value = null
      case 3 =>
        annotationType = null
      case 4 =>
        host = _root_.scala.None
      case _ =>
    }
    new Immutable(
      key,
      value,
      annotationType,
      host,
      _passthroughFields - _fieldId
    )
  }

  /**
   * If the specified field is optional, it is set to None.  Otherwise, if the field is
   * known, it is reverted to its default value; if the field is unknown, it is removed
   * from the passthroughFields map, if present.
   */
  def unsetKey: BinaryAnnotation = unsetField(1)

  def unsetValue: BinaryAnnotation = unsetField(2)

  def unsetAnnotationType: BinaryAnnotation = unsetField(3)

  def unsetHost: BinaryAnnotation = unsetField(4)


  override def write(_oprot: TProtocol): Unit = {
    BinaryAnnotation.validate(this)
    _oprot.writeStructBegin(Struct)
    if (key ne null) writeKeyField(key, _oprot)
    if (value ne null) writeValueField(value, _oprot)
    if (annotationType ne null) writeAnnotationTypeField(annotationType, _oprot)
    if (host.isDefined) writeHostField(host.get, _oprot)
    if (_passthroughFields.nonEmpty) {
      _passthroughFields.values.foreach { _.write(_oprot) }
    }
    _oprot.writeFieldStop()
    _oprot.writeStructEnd()
  }

  def copy(
    key: String = this.key,
    value: ByteBuffer = this.value,
    annotationType: com.twitter.finagle.thrift.thriftscala.AnnotationType = this.annotationType,
    host: _root_.scala.Option[com.twitter.finagle.thrift.thriftscala.Endpoint] = this.host,
    _passthroughFields: immutable$Map[Short, TFieldBlob] = this._passthroughFields
  ): BinaryAnnotation =
    new Immutable(
      key,
      value,
      annotationType,
      host,
      _passthroughFields
    )

  override def canEqual(other: Any): Boolean = other.isInstanceOf[BinaryAnnotation]

  private def _equals(x: BinaryAnnotation, y: BinaryAnnotation): Boolean =
      x.productArity == y.productArity &&
      x.productIterator.sameElements(y.productIterator)

  override def equals(other: Any): Boolean =
    canEqual(other) &&
      _equals(this, other.asInstanceOf[BinaryAnnotation]) &&
      _passthroughFields == other.asInstanceOf[BinaryAnnotation]._passthroughFields

  override def hashCode: Int = _root_.scala.runtime.ScalaRunTime._hashCode(this)

  override def toString: String = _root_.scala.runtime.ScalaRunTime._toString(this)


  override def productArity: Int = 4

  override def productElement(n: Int): Any = n match {
    case 0 => this.key
    case 1 => this.value
    case 2 => this.annotationType
    case 3 => this.host
    case _ => throw new IndexOutOfBoundsException(n.toString)
  }

  override def productPrefix: String = "BinaryAnnotation"

  def _codec: ThriftStructCodec3[BinaryAnnotation] = BinaryAnnotation
}