// =================================================================================================
// Copyright 2015 Twitter, Inc.
// -------------------------------------------------------------------------------------------------
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this work except in compliance with the License.
// You may obtain a copy of the License in the LICENSE file, or at:
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// =================================================================================================

package com.twitter.common.metrics;

import java.util.Set;

/**
 * An abstraction that provides access to a timeseries.
 */
public interface TimeSeriesProvider {

  /**
   * Fetches all the available series in this provider.
   *
   * @return all available timeseries, which can then be obtained by calling
   *         {@link #getTimeSeries(String)}
   */
  Set<String> getAvailableSeries();

  /**
   * Fetches timeseries represented as {@code Iterable<Number>} with a given {@code name}.
   *
   * @param name the name of the timeseries to fetch
   * @return the timeseries registered with the given name, or {@code null} if no such time series
   *         has been registered.
   */
  Iterable<Number> getTimeSeries(String name);

  /**
   * Gets an ordered iterable of the timestamps that all timeseries were sampled at.
   */
  Iterable<Number> getTimestamps();
}
