/*
 * Decompiled with CFR 0.152.
 */
package net.sozal.stackwriter.api.domain;

public class LocalVariable {
    private final String name;
    private final Object value;
    private final Class<?> type;

    public LocalVariable(String name, Object value, char typeSignature) {
        this.name = name;
        this.value = value;
        this.type = LocalVariable.getType(value, typeSignature);
    }

    private static Class<?> getType(Object value, char typeSignature) {
        switch (typeSignature) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
        }
        return value != null ? value.getClass() : null;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        return "LocalVariable{name='" + this.name + '\'' + ", value=" + this.value + ", type=" + (this.type != null ? this.type.getName() : "?") + '}';
    }
}

