/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class Utility {
    private static final Logger LOGGER = Logger.getLogger(Utility.class.getName());
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final Pattern containsWhitespacePattern = Pattern.compile(".*\\s.*");
    private static final Pattern isAllWhitespacePattern = Pattern.compile("^\\s*$");

    public static String commonPrefix(String string1, String string2) {
        int index = Utility.indexOfDifference(string1, string2);
        if (index == -1) {
            return null;
        }
        return string1.substring(0, index).toLowerCase();
    }

    public static boolean containsWhitespace(String text) {
        if (text == null) {
            return false;
        }
        return containsWhitespacePattern.matcher(text).matches();
    }

    public static String convertForComparison(String text) {
        String textWithoutQuotes;
        if (!Utility.isBlank(text)) {
            char[] charArray = text.toCharArray();
            StringBuilder builder = new StringBuilder();
            for (char ch : charArray) {
                if (!Character.isLetterOrDigit(ch) && ch != '_' && ch != '.') continue;
                builder.append(Character.toLowerCase(ch));
            }
            textWithoutQuotes = builder.toString();
        } else {
            textWithoutQuotes = text;
        }
        return textWithoutQuotes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static boolean isBlank(String text) {
        return text == null || text.isEmpty() || isAllWhitespacePattern.matcher(text).matches();
    }

    public static String pastelColorHTMLValue(String text) {
        float hue = Utility.isBlank(text) ? 0.123456f : (float)text.hashCode() / 5119.0f % 1.0f;
        float saturation = 0.4f;
        float luminance = 0.98f;
        Color color = Color.getHSBColor(hue, 0.4f, 0.98f);
        return "#" + Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
    }

    public static String readFully(InputStream stream) {
        InputStreamReader reader;
        if (stream == null) {
            return null;
        }
        try {
            reader = new InputStreamReader(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            return "";
        }
        return Utility.readFully(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) {
        if (reader == null) {
            LOGGER.log(Level.WARNING, "Cannot read null reader");
            return "";
        }
        StringBuilder out = new StringBuilder();
        try {
            int read;
            char[] buffer = new char[65536];
            do {
                BufferedReader bufferedReader;
                if ((read = ((Reader)(bufferedReader = new BufferedReader(reader, buffer.length))).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not read from reader", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not close reader", e);
            }
        }
        return out.toString();
    }

    public static String readResourceFully(String resource) {
        return Utility.readFully(Utility.class.getResourceAsStream(resource));
    }

    public static void setApplicationLogLevel(Level logLevel) {
        LogManager logManager = LogManager.getLogManager();
        ArrayList<String> loggerNames = Collections.list(logManager.getLoggerNames());
        for (String loggerName : loggerNames) {
            Logger logger = logManager.getLogger(loggerName);
            if (logger == null) continue;
            logger.setLevel(null);
            for (Handler handler : logger.getHandlers()) {
                handler.setLevel(logLevel);
            }
        }
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(logLevel);
    }

    private static int indexOfDifference(String string1, String string2) {
        int i;
        if (string1 == null || string2 == null) {
            return 0;
        }
        for (i = 0; i < string1.length() && i < string2.length() && string1.charAt(i) == string2.charAt(i); ++i) {
        }
        if (i < string2.length() || i < string1.length()) {
            return i;
        }
        return -1;
    }

    private Utility() {
    }
}

