/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import schemacrawler.crawl.JavaSqlType;
import schemacrawler.crawl.JavaSqlTypesUtility;
import schemacrawler.schema.Column;

public final class MetaDataUtility {
    public static Connectivity getConnectivity(Column fkColumn) {
        boolean isColumnReference;
        if (fkColumn == null) {
            return Connectivity.unknown;
        }
        try {
            fkColumn.getColumnDataType();
            isColumnReference = false;
        }
        catch (Exception e) {
            isColumnReference = true;
        }
        if (isColumnReference) {
            return Connectivity.unknown;
        }
        if (fkColumn.isPartOfPrimaryKey() || fkColumn.isPartOfUniqueIndex()) {
            return Connectivity.zero_one;
        }
        return Connectivity.zero_many;
    }

    public static JavaSqlType lookupSqlDataType(int type) {
        return JavaSqlTypesUtility.lookupSqlDataType(type);
    }

    public static JavaSqlType lookupSqlDataType(String typeName) {
        return JavaSqlTypesUtility.lookupSqlDataType(typeName);
    }

    private MetaDataUtility() {
    }

    public static enum Connectivity {
        unknown,
        zero_one,
        zero_many,
        one_one;

    }
}

