/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.crawl.MutableResultsColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.ResultsColumn;
import schemacrawler.schema.ResultsColumns;

class MutableResultsColumns
extends AbstractNamedObject
implements ResultsColumns {
    private static final long serialVersionUID = 5204766782914559188L;
    private final NamedObjectList<MutableResultsColumn> columns = new NamedObjectList();

    MutableResultsColumns(String name) {
        super(name);
    }

    @Override
    public ResultsColumn getColumn(String name) {
        return this.columns.lookup(name);
    }

    @Override
    public List<ResultsColumn> getColumns() {
        return new ArrayList<ResultsColumn>(this.columns.values());
    }

    @Override
    public String getColumnsListAsString() {
        String columnsList = "";
        List<ResultsColumn> columns = this.getColumns();
        if (columns != null && columns.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < columns.size(); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                ResultsColumn column = columns.get(i);
                buffer.append(column.getFullName());
            }
            columnsList = buffer.toString();
        }
        return columnsList;
    }

    @Override
    public Iterator<ResultsColumn> iterator() {
        return this.getColumns().iterator();
    }

    void addColumn(MutableResultsColumn column) {
        this.columns.add(column);
    }
}

