/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.DatabaseConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.BaseDatabaseConnectionOptionsParser;
import sf.util.Utility;
import sf.util.clparser.StringOption;

final class CommandLineConnectionOptionsParser
extends BaseDatabaseConnectionOptionsParser {
    CommandLineConnectionOptionsParser(Config config) {
        super(config);
        this.addOption(new StringOption("driver", null));
        this.addOption(new StringOption("url", null));
    }

    @Override
    public DatabaseConnectionOptions getOptions() throws SchemaCrawlerException {
        DatabaseConnectionOptions connectionOptions;
        if (this.hasOptionValue("url")) {
            String jdbcDriverClassName = this.getStringValue("driver");
            String connectionUrl = this.getStringValue("url");
            if (Utility.isBlank((String)jdbcDriverClassName) || Utility.isBlank((String)connectionUrl)) {
                connectionOptions = null;
            } else {
                connectionOptions = new DatabaseConnectionOptions(jdbcDriverClassName, connectionUrl);
                this.setUser((ConnectionOptions)connectionOptions);
                this.setPassword((ConnectionOptions)connectionOptions);
            }
        } else {
            connectionOptions = null;
        }
        return connectionOptions;
    }
}

