/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import schemacrawler.crawl.JavaSqlType;
import schemacrawler.crawl.JavaSqlTypesUtility;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import sf.util.TemplatingUtility;
import sf.util.Utility;

final class Query
implements Serializable {
    private static final long serialVersionUID = 2820769346069413473L;
    private final String name;
    private final String query;

    private static String getOrderByColumnsListAsString(Table table) {
        Column[] columnsArray = table.getColumns();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < columnsArray.length; ++i) {
            Column column = columnsArray[i];
            JavaSqlType.JavaSqlTypeGroup javaSqlTypeGroup = JavaSqlTypesUtility.lookupSqlDataType((int)column.getType().getType()).getJavaSqlTypeGroup();
            if (javaSqlTypeGroup == JavaSqlType.JavaSqlTypeGroup.large_object) continue;
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(column.getName());
        }
        return buffer.toString();
    }

    Query(String name, String query) {
        if (Utility.isBlank((String)name)) {
            throw new IllegalArgumentException("No name provided for the query");
        }
        this.name = name;
        if (Utility.isBlank((String)query)) {
            throw new IllegalArgumentException("No SQL provided for query '" + name + "'");
        }
        this.query = query;
    }

    public String getName() {
        return this.name;
    }

    public String getQuery() {
        return TemplatingUtility.expandTemplate((String)this.query);
    }

    public boolean isQueryOver() {
        Set keys = TemplatingUtility.extractTemplateVariables((String)this.query);
        return keys.contains("table");
    }

    public String toString() {
        return this.name + ":" + this.query;
    }

    String getQueryForTable(Table table) {
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        if (table != null) {
            if (table.getSchema() != null) {
                tableProperties.put("schema", table.getSchema().getFullName());
            }
            tableProperties.put("table", table.getFullName());
            tableProperties.put("columns", table.getColumnsListAsString());
            tableProperties.put("orderbycolumns", Query.getOrderByColumnsListAsString(table));
            tableProperties.put("tabletype", table.getType().toString());
        }
        String sql = this.query;
        sql = TemplatingUtility.expandTemplate((String)sql, tableProperties);
        sql = TemplatingUtility.expandTemplate((String)sql);
        return sql;
    }
}

