/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import schemacrawler.schema.ColumnMap;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.associations.WeakAssociationsCollector;

public class SimpleWeakAssociationsCollector
implements WeakAssociationsCollector {
    private final Set<ColumnMap> weakAssociations = new HashSet<ColumnMap>();

    public static final ColumnMap[] getWeakAssociations(Table table) {
        if (table == null) {
            return null;
        }
        Set weakAssociations = (Set)table.getAttribute("schemacrawler.weak_associations", new HashSet());
        Object[] tableWeakAssociations = weakAssociations.toArray(new ColumnMap[weakAssociations.size()]);
        Arrays.sort(tableWeakAssociations);
        return tableWeakAssociations;
    }

    @Override
    public void addWeakAssociation(ColumnMap weakAssociation) {
        if (weakAssociation != null) {
            this.weakAssociations.add(weakAssociation);
            this.addWeakAssociation((Table)weakAssociation.getPrimaryKeyColumn().getParent(), weakAssociation);
            this.addWeakAssociation((Table)weakAssociation.getForeignKeyColumn().getParent(), weakAssociation);
        }
    }

    @Override
    public void clear() {
        this.weakAssociations.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.weakAssociations.isEmpty();
    }

    @Override
    public Iterator<ColumnMap> iterator() {
        return this.weakAssociations.iterator();
    }

    @Override
    public int size() {
        return this.weakAssociations.size();
    }

    @Override
    public ColumnMap[] toArray() {
        return this.weakAssociations.toArray(new ColumnMap[this.weakAssociations.size()]);
    }

    private void addWeakAssociation(Table table, ColumnMap weakAssociation) {
        if (table != null && weakAssociation != null) {
            this.weakAssociations.add(weakAssociation);
            Collection tableWeakAssociations = (Collection)table.getAttribute("schemacrawler.weak_associations", new HashSet());
            tableWeakAssociations.add(weakAssociation);
            table.setAttribute("schemacrawler.weak_associations", (Object)tableWeakAssociations);
        }
    }
}

