/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.spring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.integration.spring.SpringOptions;
import schemacrawler.tools.integration.spring.SpringOptionsParser;
import sf.util.ObjectToString;

public class SchemaCrawlerSpringCommandLine
implements CommandLine {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerSpringCommandLine.class.getName());
    private final SpringOptions springOptions;

    public SchemaCrawlerSpringCommandLine(String[] args) throws SchemaCrawlerException {
        SpringOptionsParser springOptionsParser = new SpringOptionsParser();
        String[] remainingArgs = springOptionsParser.parse(args);
        this.springOptions = springOptionsParser.getOptions();
        if (remainingArgs.length > 0) {
            throw new SchemaCrawlerException("Too many command line arguments provided: " + ObjectToString.toString((Object)remainingArgs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        Connection connection = null;
        try {
            FileSystemXmlApplicationContext appContext = new FileSystemXmlApplicationContext(this.springOptions.getContextFileName());
            DataSource dataSource = (DataSource)appContext.getBean(this.springOptions.getDataSourceName());
            connection = dataSource.getConnection();
            LOGGER.log(Level.INFO, "Opened database connection, " + connection);
            Executable executable = (Executable)appContext.getBean(this.springOptions.getExecutableName());
            executable.execute(connection);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                    LOGGER.log(Level.INFO, "Closed database connection, " + connection);
                }
            }
            catch (SQLException e) {
                String errorMessage = e.getMessage();
                LOGGER.log(Level.WARNING, "Could not close the connection: " + errorMessage);
            }
        }
    }
}

