/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnMap;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnMap;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schema.Table;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.utility.MetaDataUtility;
import sf.util.Utility;

final class DotWriter {
    private final PrintWriter out;
    private final Map<Schema, String> colorMap;

    DotWriter(File dotFile) throws SchemaCrawlerException {
        if (dotFile == null) {
            throw new SchemaCrawlerException("No dot file provided");
        }
        try {
            this.out = new PrintWriter(dotFile);
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Cannot open dot file for output", (Throwable)e);
        }
        this.colorMap = new HashMap<Schema, String>();
    }

    public void close() {
        this.out.println("}");
        this.out.flush();
        this.out.close();
    }

    public void open() {
        String text = Utility.readResourceFully((String)"/dot.header.txt");
        this.out.println(text);
    }

    public void print(Collection<Table> tables, Collection<ColumnMap> weakAssociations) {
        if (tables != null) {
            for (Table table : tables) {
                this.print(table);
                this.out.write(Utility.NEWLINE);
                for (ForeignKey foreignKey : table.getForeignKeys()) {
                    ForeignKeyColumnMap[] columnPairs;
                    for (ForeignKeyColumnMap columnMap : columnPairs = foreignKey.getColumnPairs()) {
                        if (!table.equals(columnMap.getPrimaryKeyColumn().getParent())) continue;
                        this.out.write(this.printColumnAssociation(foreignKey.getName(), (ColumnMap)columnMap, tables));
                    }
                }
                this.out.write(Utility.NEWLINE);
                this.out.write(Utility.NEWLINE);
            }
        }
        this.out.write(Utility.NEWLINE);
        for (ColumnMap columnMap : weakAssociations) {
            this.out.write(this.printColumnAssociation("", columnMap, tables));
        }
        this.out.write(Utility.NEWLINE);
    }

    public void print(SchemaCrawlerInfo schemaCrawlerInfo, DatabaseInfo databaseInfo, JdbcDriverInfo jdbcDriverInfo) {
        StringBuilder graphInfo = new StringBuilder();
        graphInfo.append("      <table border=\"1\" cellborder=\"0\" cellspacing=\"0\">").append(Utility.NEWLINE);
        graphInfo.append("        <tr>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"right\">Generated by:</td>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"left\">").append(schemaCrawlerInfo.getSchemaCrawlerProductName()).append(" ").append(schemaCrawlerInfo.getSchemaCrawlerVersion()).append("</td>").append(Utility.NEWLINE);
        graphInfo.append("        </tr>").append(Utility.NEWLINE);
        graphInfo.append("        <tr>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"right\">Database:</td>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"left\">").append(databaseInfo.getProductName()).append("  ").append(databaseInfo.getProductVersion()).append("</td>").append(Utility.NEWLINE);
        graphInfo.append("        </tr>").append(Utility.NEWLINE);
        graphInfo.append("        <tr>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"right\">JDBC Connection:</td>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"left\">").append(jdbcDriverInfo.getConnectionUrl()).append("</td>").append(Utility.NEWLINE);
        graphInfo.append("        </tr>").append(Utility.NEWLINE);
        graphInfo.append("        <tr>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"right\">JDBC Driver:</td>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"left\">").append(jdbcDriverInfo.getDriverName()).append("  ").append(jdbcDriverInfo.getDriverVersion()).append("</td>").append(Utility.NEWLINE);
        graphInfo.append("        </tr>").append(Utility.NEWLINE);
        graphInfo.append("      </table>");
        String graphLabel = String.format("  graph [%n    label=<%n%s    >%n    labeljust=r%n    labelloc=b%n  ];%n%n", graphInfo.toString());
        this.out.println(graphLabel);
    }

    private String[] getPortIds(Column column, Collection<Table> tables) {
        String[] portIds = new String[2];
        if (tables.contains(column.getParent())) {
            portIds[0] = String.format("\"%s\":\"%s.start\"", this.nodeId((NamedObject)column.getParent()), this.nodeId((NamedObject)column));
            portIds[1] = String.format("\"%s\":\"%s.end\"", this.nodeId((NamedObject)column.getParent()), this.nodeId((NamedObject)column));
        } else {
            String nodeId;
            portIds[0] = nodeId = this.print(column);
            portIds[1] = nodeId;
        }
        return portIds;
    }

    private String nodeId(NamedObject namedOjbect) {
        if (namedOjbect == null) {
            return "";
        }
        return Utility.convertForComparison((String)namedOjbect.getName()) + "_" + Integer.toHexString(namedOjbect.getFullName().hashCode());
    }

    private String print(Column column) {
        String nodeId = "\"" + UUID.randomUUID().toString() + "\"";
        String columnNode = String.format("  %s [label=<%s>];%n", nodeId, column.getFullName());
        this.out.write(columnNode);
        return nodeId;
    }

    private void print(Table table) {
        String tableNameBgColor;
        Schema schema = table.getSchema();
        if (!this.colorMap.containsKey(schema)) {
            tableNameBgColor = Utility.pastelColorHTMLValue((String)schema.getName());
            this.colorMap.put(schema, tableNameBgColor);
        } else {
            tableNameBgColor = this.colorMap.get(schema);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("  /* ").append(table.getFullName()).append(" -=-=-=-=-=-=-=-=-=-=-=-=-=- */").append(Utility.NEWLINE);
        buffer.append("  \"").append(this.nodeId((NamedObject)table)).append("\" [").append(Utility.NEWLINE).append("    label=<").append(Utility.NEWLINE);
        buffer.append("      <table border=\"1\" cellborder=\"0\" cellspacing=\"0\" bgcolor=\"white\">").append(Utility.NEWLINE);
        buffer.append("        <tr>").append(Utility.NEWLINE);
        buffer.append("          <td colspan=\"2\" bgcolor=\"").append(tableNameBgColor).append("\" align=\"left\"><b>").append(table.getFullName()).append("</b></td>").append(Utility.NEWLINE);
        buffer.append("          <td bgcolor=\"").append(tableNameBgColor).append("\" align=\"right\">").append(table instanceof View ? "[view]" : "[table]").append("</td>").append(Utility.NEWLINE);
        buffer.append("        </tr>").append(Utility.NEWLINE);
        for (Column column : table.getColumns()) {
            buffer.append("        <tr>").append(Utility.NEWLINE);
            buffer.append("          <td port=\"").append(this.nodeId((NamedObject)column)).append(".start\" align=\"left\">");
            if (column.isPartOfPrimaryKey()) {
                buffer.append("<b><i>");
            }
            buffer.append(column.getName());
            if (column.isPartOfPrimaryKey()) {
                buffer.append("</i></b>");
            }
            buffer.append("</td>").append(Utility.NEWLINE);
            buffer.append("          <td> </td>").append(Utility.NEWLINE);
            buffer.append("          <td port=\"").append(this.nodeId((NamedObject)column)).append(".end\" align=\"right\">");
            buffer.append(column.getType().getDatabaseSpecificTypeName()).append(column.getWidth());
            buffer.append("</td>").append(Utility.NEWLINE);
            buffer.append("        </tr>").append(Utility.NEWLINE);
        }
        buffer.append("      </table>").append(Utility.NEWLINE);
        buffer.append("    >").append(Utility.NEWLINE).append("  ];").append(Utility.NEWLINE);
        this.out.write(buffer.toString());
    }

    private String printColumnAssociation(String associationName, ColumnMap columnMap, Collection<Table> tables) {
        String fkSymbol;
        Column primaryKeyColumn = columnMap.getPrimaryKeyColumn();
        Column foreignKeyColumn = columnMap.getForeignKeyColumn();
        String[] pkPortIds = this.getPortIds(primaryKeyColumn, tables);
        String[] fkPortIds = this.getPortIds(foreignKeyColumn, tables);
        MetaDataUtility.Connectivity connectivity = MetaDataUtility.getConnectivity((Column)foreignKeyColumn);
        String pkSymbol = "teetee";
        if (connectivity != null) {
            switch (connectivity) {
                case OneToOne: {
                    fkSymbol = "teeodot";
                    break;
                }
                case OneToMany: {
                    fkSymbol = "crowodot";
                    break;
                }
                default: {
                    fkSymbol = "none";
                    break;
                }
            }
        } else {
            fkSymbol = "none";
        }
        String style = Utility.isBlank((String)associationName) ? "dashed" : "solid";
        return String.format("  %s:w -> %s:e [label=<%s> style=\"%s\" arrowhead=\"%s\" arrowtail=\"%s\"];%n", pkPortIds[0], fkPortIds[1], associationName, style, fkSymbol, "teetee");
    }
}

