/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.HashMap;
import java.util.Map;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.DatabaseConfigConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.BaseDatabaseConnectionOptionsParser;
import sf.util.Utility;
import sf.util.clparser.BooleanOption;
import sf.util.clparser.StringOption;

final class ConfigConnectionOptionsParser
extends BaseDatabaseConnectionOptionsParser {
    private static Map<String, String> partition(Map<String, String> config, String prefix) {
        if (Utility.isBlank((String)prefix)) {
            return config;
        }
        String dottedPrefix = prefix + ".";
        HashMap<String, String> partition = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(dottedPrefix)) continue;
            String unprefixed = key.substring(dottedPrefix.length());
            partition.put(unprefixed, entry.getValue());
        }
        return partition;
    }

    ConfigConnectionOptionsParser(Config config) {
        super(config);
        this.addOption(new BooleanOption(Character.valueOf('d'), "default"));
        this.addOption(new StringOption(Character.valueOf('c'), "connection", null));
    }

    @Override
    public ConnectionOptions getOptions() throws SchemaCrawlerException {
        String connectionName = this.hasOptionValue("default") ? (String)this.config.get((Object)"defaultconnection") : this.getStringValue("connection");
        if (this.config.isEmpty()) {
            throw new SchemaCrawlerException(String.format("No configuration provided for connection \"%s\"", connectionName));
        }
        Map<String, String> databaseConnectionConfig = ConfigConnectionOptionsParser.partition((Map<String, String>)this.config, connectionName);
        this.config.putAll(databaseConnectionConfig);
        DatabaseConfigConnectionOptions connectionOptions = new DatabaseConfigConnectionOptions(databaseConnectionConfig);
        if (!databaseConnectionConfig.containsKey("user")) {
            this.setUser((ConnectionOptions)connectionOptions);
        }
        if (!databaseConnectionConfig.containsKey("password")) {
            this.setPassword((ConnectionOptions)connectionOptions);
        }
        return connectionOptions;
    }
}

