/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableSequence;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;
import sf.util.DatabaseUtility;

final class SequenceRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(SequenceRetriever.class.getName());

    SequenceRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    void retrieveSequenceInformation(InclusionRule sequenceInclusionRule) throws SQLException {
        InclusionRuleFilter<MutableSequence> sequenceFilter = new InclusionRuleFilter<MutableSequence>(sequenceInclusionRule, false);
        if (sequenceFilter.isExcludeAll()) {
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasSequencesSql()) {
            LOGGER.log(Level.FINE, "Sequence definition SQL statement was not provided");
            return;
        }
        String sequencesDefinitionSql = informationSchemaViews.getSequencesSql();
        Collection<Schema> schemas = this.database.getSchemaNames();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(DatabaseUtility.executeSql(statement, sequencesDefinitionSql));){
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("SEQUENCE_CATALOG"));
                String schemaName = this.quotedName(results.getString("SEQUENCE_SCHEMA"));
                String sequenceName = this.quotedName(results.getString("SEQUENCE_NAME"));
                BigInteger minimumValue = results.getBigInteger("MINIMUM_VALUE");
                BigInteger maximumValue = results.getBigInteger("MAXIMUM_VALUE");
                BigInteger increment = results.getBigInteger("INCREMENT");
                long longIncrement = increment == null ? 1L : increment.longValue();
                boolean cycle = results.getBoolean("CYCLE_OPTION");
                SchemaReference schema = new SchemaReference(catalogName, schemaName);
                if (!schemas.contains(schema)) continue;
                MutableSequence sequence = new MutableSequence(schema, sequenceName);
                sequence.setMaximumValue(maximumValue);
                sequence.setMinimumValue(minimumValue);
                sequence.setIncrement(longIncrement);
                sequence.setCycle(cycle);
                sequence.addAttributes(results.getAttributes());
                if (!sequenceFilter.include(sequence)) continue;
                this.database.addSequence(sequence);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve sequences", e);
        }
    }
}

