/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.commandline.ApplicationOptionsParser;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerHelpCommandLine;
import schemacrawler.tools.options.ApplicationOptions;
import schemacrawler.tools.options.BundledDriverOptions;

public class SchemaCrawlerMain {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerMain.class.getName());

    public static void main(String[] args) throws Exception {
        SchemaCrawlerMain.main(args, new BundledDriverOptions(){
            private static final long serialVersionUID = 1352308748762219275L;
        });
    }

    public static void main(String[] args, BundledDriverOptions bundledDriverOptions) throws Exception {
        if (bundledDriverOptions == null) {
            throw new IllegalArgumentException("No bundled driver options provided");
        }
        String[] remainingArgs = args;
        ApplicationOptionsParser applicationOptionsParser = new ApplicationOptionsParser();
        remainingArgs = applicationOptionsParser.parse(remainingArgs);
        ApplicationOptions applicationOptions = applicationOptionsParser.getOptions();
        if (applicationOptions.isShowHelp()) {
            boolean showVersionOnly = applicationOptions.isShowVersionOnly();
            SchemaCrawlerHelpCommandLine helpCommandLine = new SchemaCrawlerHelpCommandLine(remainingArgs, bundledDriverOptions.getHelpOptions(), showVersionOnly);
            helpCommandLine.execute();
            return;
        }
        applicationOptions.applyApplicationLogLevel();
        LOGGER.log(Level.CONFIG, "Command line: " + Arrays.toString(args));
        SchemaCrawlerCommandLine commandLine = new SchemaCrawlerCommandLine(bundledDriverOptions, remainingArgs);
        commandLine.execute();
    }

    private SchemaCrawlerMain() {
    }
}

