/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.sql.Connection;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.DatabaseWithAssociations;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.options.InfoLevel;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.schema.SchemaJsonFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextFormatter;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;

public final class SchemaTextExecutable
extends BaseStagedExecutable {
    private SchemaTextOptions schemaTextOptions;

    public SchemaTextExecutable(String command) {
        super(command);
    }

    @Override
    public void executeOn(Database db, Connection connection) throws Exception {
        InfoLevel infoLevel;
        this.loadSchemaTextOptions();
        this.checkOutputFormat();
        try {
            infoLevel = InfoLevel.valueOf(this.schemaCrawlerOptions.getSchemaInfoLevel().getTag());
        }
        catch (Exception e) {
            infoLevel = InfoLevel.unknown;
        }
        Object database = infoLevel == InfoLevel.maximum ? new DatabaseWithAssociations(db) : db;
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler();
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setDatabase((Database)database);
        traverser.setHandler(formatter);
        traverser.traverse();
    }

    public final SchemaTextOptions getSchemaTextOptions() {
        this.loadSchemaTextOptions();
        return this.schemaTextOptions;
    }

    public final void setSchemaTextOptions(SchemaTextOptions schemaTextOptions) {
        this.schemaTextOptions = schemaTextOptions;
    }

    private void checkOutputFormat() {
        if (!this.outputOptions.hasOutputFormat()) {
            throw new IllegalArgumentException("Unknown output format: " + this.outputOptions.getOutputFormatValue());
        }
    }

    private SchemaTraversalHandler getSchemaTraversalHandler() throws SchemaCrawlerException {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = SchemaTextDetailType.schema;
        }
        OutputFormat outputFormat = this.outputOptions.getOutputFormat();
        BaseFormatter formatter = outputFormat == OutputFormat.json ? new SchemaJsonFormatter(schemaTextDetailType, this.schemaTextOptions, this.outputOptions) : new SchemaTextFormatter(schemaTextDetailType, this.schemaTextOptions, this.outputOptions);
        return formatter;
    }

    private void loadSchemaTextOptions() {
        if (this.schemaTextOptions == null) {
            this.schemaTextOptions = new SchemaTextOptions(this.additionalConfiguration);
        }
    }
}

