/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import schemacrawler.schema.Column;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.Table;
import schemacrawler.utility.NamedObjectSort;
import sf.util.TemplatingUtility;
import sf.util.Utility;

public final class Query
implements Serializable {
    private static final long serialVersionUID = 2820769346069413473L;
    private final String name;
    private final String query;

    private static String getColumnsListAsString(List<Column> columns, boolean omitLargeObjectColumns) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            JavaSqlType.JavaSqlTypeGroup javaSqlTypeGroup = column.getColumnDataType().getJavaSqlType().getJavaSqlTypeGroup();
            if (omitLargeObjectColumns && javaSqlTypeGroup == JavaSqlType.JavaSqlTypeGroup.large_object) continue;
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(column.getName());
        }
        return buffer.toString();
    }

    Query(String name, String query) {
        boolean isQueryProvided;
        boolean isNameProvided = !Utility.isBlank((String)name);
        boolean bl = isQueryProvided = !Utility.isBlank((String)query);
        if (isNameProvided && isQueryProvided) {
            this.name = name;
            this.query = query;
        } else if (isNameProvided && !isQueryProvided) {
            this.name = this.query = name;
        } else {
            throw new IllegalArgumentException("No SQL found for query");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getQuery() {
        return TemplatingUtility.expandTemplate((String)this.query);
    }

    public boolean isQueryOver() {
        Set keys = TemplatingUtility.extractTemplateVariables((String)this.query);
        return keys.contains("table");
    }

    public String toString() {
        return this.name + ":" + this.query;
    }

    String getQueryForTable(Table table, boolean isAlphabeticalSortForTableColumns) {
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        if (table != null) {
            NamedObjectSort columnsSort = NamedObjectSort.getNamedObjectSort((boolean)isAlphabeticalSortForTableColumns);
            List columns = table.getColumns();
            Collections.sort(columns, columnsSort);
            if (table.getSchema() != null) {
                tableProperties.put("schema", table.getSchema().getFullName());
            }
            tableProperties.put("table", table.getFullName());
            tableProperties.put("columns", Query.getColumnsListAsString(columns, false));
            tableProperties.put("orderbycolumns", Query.getColumnsListAsString(columns, true));
            tableProperties.put("tabletype", table.getTableType().toString());
        }
        String sql = this.query;
        sql = TemplatingUtility.expandTemplate((String)sql, tableProperties);
        sql = TemplatingUtility.expandTemplate((String)sql);
        return sql;
    }
}

