/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.sql.Connection;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.options.HelpOptions;
import schemacrawler.tools.options.InfoLevel;

public abstract class BundledDriverOptions
implements Options {
    private static final long serialVersionUID = 2160456864554076419L;
    private final HelpOptions helpOptions;
    private final String configResource;

    protected BundledDriverOptions() {
        this.helpOptions = new HelpOptions();
        this.configResource = null;
    }

    protected BundledDriverOptions(String title, String helpResource, String configResource) {
        this.helpOptions = new HelpOptions(title, helpResource);
        this.configResource = configResource;
    }

    public final Config getConfig() {
        return Config.loadResource((String)this.configResource);
    }

    public final HelpOptions getHelpOptions() {
        return this.helpOptions;
    }

    public final SchemaCrawlerOptions getSchemaCrawlerOptions(InfoLevel infoLevel) {
        SchemaCrawlerOptions schemaCrawlerOptions = new SchemaCrawlerOptions(this.getConfig());
        if (infoLevel != null) {
            schemaCrawlerOptions.setSchemaInfoLevel(infoLevel.getSchemaInfoLevel());
        }
        return schemaCrawlerOptions;
    }

    public final boolean hasConfig() {
        return this.configResource != null;
    }

    public Executable newPostExecutable() throws SchemaCrawlerException {
        return new NoOpExecutable("no-op");
    }

    public Executable newPreExecutable() throws SchemaCrawlerException {
        return new NoOpExecutable("no-op");
    }

    private final class NoOpExecutable
    extends BaseExecutable {
        private NoOpExecutable(String command) {
            super(command);
        }

        @Override
        public void execute(Connection connection) throws Exception {
        }
    }
}

