/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.protocol.BufferedContent;
import org.apache.http.nio.protocol.ContentOutputStream;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.nio.util.SimpleOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.util.EncodingUtils;

public class BufferingHttpServiceHandler
implements NHttpServiceHandler {
    private static final String CONN_STATE = "http.nio.conn-state";
    private HttpParams params;
    private HttpProcessor httpProcessor;
    private HttpResponseFactory responseFactory;
    private ConnectionReuseStrategy connStrategy;
    private HttpRequestHandlerResolver handlerResolver;
    private HttpExpectationVerifier expectationVerifier;
    private EventListener eventListener;

    public BufferingHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory responseFactory, ConnectionReuseStrategy connStrategy, HttpParams params) {
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null.");
        }
        if (connStrategy == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null");
        }
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.httpProcessor = httpProcessor;
        this.connStrategy = connStrategy;
        this.responseFactory = responseFactory;
        this.params = params;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setHandlerResolver(HttpRequestHandlerResolver handlerResolver) {
        this.handlerResolver = handlerResolver;
    }

    public void setExpectationVerifier(HttpExpectationVerifier expectationVerifier) {
        this.expectationVerifier = expectationVerifier;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void connected(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        ServerConnState connState = new ServerConnState();
        context.setAttribute(CONN_STATE, (Object)connState);
        if (this.eventListener != null) {
            InetAddress address = null;
            if (conn instanceof HttpInetConnection) {
                address = ((HttpInetConnection)conn).getRemoteAddress();
            }
            this.eventListener.connectionOpen(address);
        }
    }

    public void requestReceived(NHttpServerConnection conn) {
        block11: {
            HttpContext context = conn.getContext();
            HttpRequest request = conn.getHttpRequest();
            ServerConnState connState = (ServerConnState)context.getAttribute(CONN_STATE);
            connState.resetInput();
            connState.setRequest(request);
            connState.setInputState(1);
            HttpVersion ver = request.getRequestLine().getHttpVersion();
            if (!ver.lessEquals(HttpVersion.HTTP_1_1)) {
                ver = HttpVersion.HTTP_1_1;
            }
            try {
                if (request instanceof HttpEntityEnclosingRequest) {
                    if (!((HttpEntityEnclosingRequest)request).expectContinue()) break block11;
                    HttpResponse response = this.responseFactory.newHttpResponse(ver, 100, context);
                    response.getParams().setDefaults(this.params);
                    if (this.expectationVerifier != null) {
                        try {
                            this.expectationVerifier.verify(request, response, context);
                        }
                        catch (HttpException ex) {
                            response = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, context);
                            response.getParams().setDefaults(this.params);
                            this.handleException(ex, response);
                        }
                    }
                    if (response.getStatusLine().getStatusCode() < 200) {
                        conn.submitResponse(response);
                    } else {
                        conn.cancelRequest();
                        connState.resetInput();
                        this.sendResponse(conn, response);
                    }
                    break block11;
                }
                conn.suspendInput();
                this.processRequest(conn, request);
            }
            catch (IOException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex);
                }
            }
            catch (HttpException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener == null) break block11;
                this.eventListener.fatalProtocolException(ex);
            }
        }
    }

    public void closed(NHttpServerConnection conn) {
        if (this.eventListener != null) {
            InetAddress address = null;
            if (conn instanceof HttpInetConnection) {
                address = ((HttpInetConnection)conn).getRemoteAddress();
            }
            this.eventListener.connectionClosed(address);
        }
    }

    public void exception(NHttpServerConnection conn, HttpException httpex) {
        block4: {
            HttpContext context = conn.getContext();
            try {
                HttpResponse response = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, context);
                response.getParams().setDefaults(this.params);
                this.handleException(httpex, response);
                this.sendResponse(conn, response);
            }
            catch (IOException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex);
                }
            }
            catch (HttpException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener == null) break block4;
                this.eventListener.fatalProtocolException(ex);
            }
        }
    }

    public void exception(NHttpServerConnection conn, IOException ex) {
        this.shutdownConnection(conn);
        if (this.eventListener != null) {
            this.eventListener.fatalIOException(ex);
        }
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        block6: {
            HttpContext context = conn.getContext();
            HttpRequest request = conn.getHttpRequest();
            ServerConnState connState = (ServerConnState)context.getAttribute(CONN_STATE);
            ContentInputBuffer buffer = connState.getInbuffer();
            connState.setInputState(2);
            try {
                buffer.consumeContent(decoder);
                if (decoder.isCompleted()) {
                    connState.setInputState(4);
                    HttpEntityEnclosingRequest entityReq = (HttpEntityEnclosingRequest)request;
                    if (entityReq.getEntity() != null) {
                        entityReq.setEntity((HttpEntity)new BufferedContent(entityReq.getEntity(), connState.getInbuffer()));
                    }
                    conn.suspendInput();
                    this.processRequest(conn, request);
                }
            }
            catch (IOException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex);
                }
            }
            catch (HttpException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener == null) break block6;
                this.eventListener.fatalProtocolException(ex);
            }
        }
    }

    public void responseReady(NHttpServerConnection conn) {
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        block5: {
            HttpContext context = conn.getContext();
            HttpResponse response = conn.getHttpResponse();
            ServerConnState connState = (ServerConnState)context.getAttribute(CONN_STATE);
            ContentOutputBuffer buffer = connState.getOutbuffer();
            connState.setOutputState(16);
            try {
                buffer.produceContent(encoder);
                if (encoder.isCompleted()) {
                    connState.setOutputState(32);
                    connState.resetOutput();
                    if (!this.connStrategy.keepAlive(response, context)) {
                        conn.close();
                    } else {
                        conn.requestInput();
                    }
                }
            }
            catch (IOException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener == null) break block5;
                this.eventListener.fatalIOException(ex);
            }
        }
    }

    public void timeout(NHttpServerConnection conn) {
        this.shutdownConnection(conn);
        if (this.eventListener != null) {
            InetAddress address = null;
            if (conn instanceof HttpInetConnection) {
                address = ((HttpInetConnection)conn).getRemoteAddress();
            }
            this.eventListener.connectionTimeout(address);
        }
    }

    private void shutdownConnection(NHttpConnection conn) {
        try {
            conn.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handleException(HttpException ex, HttpResponse response) {
        int code = 500;
        if (ex instanceof MethodNotSupportedException) {
            code = 501;
        } else if (ex instanceof UnsupportedHttpVersionException) {
            code = 505;
        } else if (ex instanceof ProtocolException) {
            code = 400;
        }
        response.setStatusCode(code);
        byte[] msg = EncodingUtils.getAsciiBytes((String)ex.getMessage());
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=US-ASCII");
        response.setEntity((HttpEntity)entity);
    }

    private void processRequest(NHttpServerConnection conn, HttpRequest request) throws IOException, HttpException {
        HttpContext context = conn.getContext();
        HttpVersion ver = request.getRequestLine().getHttpVersion();
        if (!ver.lessEquals(HttpVersion.HTTP_1_1)) {
            ver = HttpVersion.HTTP_1_1;
        }
        HttpResponse response = this.responseFactory.newHttpResponse(ver, 200, conn.getContext());
        response.getParams().setDefaults(this.params);
        context.setAttribute("http.request", (Object)request);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.response", (Object)response);
        try {
            this.httpProcessor.process(request, context);
            HttpRequestHandler handler = null;
            if (this.handlerResolver != null) {
                String requestURI = request.getRequestLine().getUri();
                handler = this.handlerResolver.lookup(requestURI);
            }
            if (handler != null) {
                handler.handle(request, response, context);
            } else {
                response.setStatusCode(501);
            }
        }
        catch (HttpException ex) {
            response = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, context);
            response.getParams().setDefaults(this.params);
            this.handleException(ex, response);
        }
        this.sendResponse(conn, response);
    }

    private void sendResponse(NHttpServerConnection conn, HttpResponse response) throws IOException, HttpException {
        HttpContext context = conn.getContext();
        ServerConnState connState = (ServerConnState)context.getAttribute(CONN_STATE);
        ContentOutputBuffer buffer = connState.getOutbuffer();
        this.httpProcessor.process(response, context);
        conn.submitResponse(response);
        connState.setOutputState(8);
        if (response.getEntity() != null) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentOutputStream outstream = new ContentOutputStream(buffer);
                entity.writeTo((OutputStream)outstream);
                ((OutputStream)outstream).flush();
                ((OutputStream)outstream).close();
            }
        } else {
            connState.resetOutput();
            conn.requestInput();
        }
    }

    static class ServerConnState {
        public static final int READY = 0;
        public static final int REQUEST_RECEIVED = 1;
        public static final int REQUEST_BODY_STREAM = 2;
        public static final int REQUEST_BODY_DONE = 4;
        public static final int RESPONSE_SENT = 8;
        public static final int RESPONSE_BODY_STREAM = 16;
        public static final int RESPONSE_BODY_DONE = 32;
        private SimpleInputBuffer inbuffer;
        private ContentOutputBuffer outbuffer;
        private int inputState = 0;
        private int outputState = 0;
        private HttpRequest request;

        public ContentInputBuffer getInbuffer() {
            if (this.inbuffer == null) {
                this.inbuffer = new SimpleInputBuffer(2048);
            }
            return this.inbuffer;
        }

        public ContentOutputBuffer getOutbuffer() {
            if (this.outbuffer == null) {
                this.outbuffer = new SimpleOutputBuffer(2048);
            }
            return this.outbuffer;
        }

        public int getInputState() {
            return this.inputState;
        }

        public void setInputState(int inputState) {
            this.inputState = inputState;
        }

        public int getOutputState() {
            return this.outputState;
        }

        public void setOutputState(int outputState) {
            this.outputState = outputState;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest request) {
            this.request = request;
        }

        public void resetInput() {
            this.inbuffer = null;
            this.request = null;
            this.inputState = 0;
        }

        public void resetOutput() {
            this.outbuffer = null;
            this.outputState = 0;
        }
    }
}

