/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.codecs;

import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponseFactory;
import org.apache.http.StatusLine;
import org.apache.http.impl.nio.codecs.HttpMessageParser;
import org.apache.http.impl.nio.reactor.SessionInputBuffer;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.util.CharArrayBuffer;

public class HttpResponseParser
extends HttpMessageParser {
    private final HttpResponseFactory responseFactory;

    public HttpResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory) {
        super(buffer);
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        this.responseFactory = responseFactory;
    }

    protected HttpMessage createMessage(CharArrayBuffer buffer) throws HttpException {
        StatusLine statusline = BasicStatusLine.parse((CharArrayBuffer)buffer, (int)0, (int)buffer.length());
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

