/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import sf.util.Utility;

final class SchemaReference
implements Serializable,
Comparable<SchemaReference> {
    private static final long serialVersionUID = -5309848447599233878L;
    private final String catalogName;
    private final String schemaName;
    private transient String fullName;

    SchemaReference(String catalogName, String schemaName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    @Override
    public int compareTo(SchemaReference otherSchemaRef) {
        if (otherSchemaRef == null) {
            return -1;
        }
        return this.getFullName().compareTo(otherSchemaRef.getFullName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaReference)) {
            return false;
        }
        SchemaReference other = (SchemaReference)obj;
        if (this.catalogName == null ? other.catalogName != null : !this.catalogName.equals(other.catalogName)) {
            return false;
        }
        return !(this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.catalogName == null ? 0 : this.catalogName.hashCode());
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        return result;
    }

    public String toString() {
        return this.getFullName();
    }

    String getCatalogName() {
        return this.catalogName;
    }

    String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    String getSchemaName() {
        return this.schemaName;
    }

    private void buildFullName() {
        if (this.fullName == null) {
            boolean hasCatalogName = !Utility.isBlank(this.catalogName);
            boolean hasSchemaName = !Utility.isBlank(this.schemaName);
            this.fullName = (hasCatalogName ? this.catalogName : "") + (hasCatalogName && hasSchemaName ? "." : "") + (hasSchemaName ? this.schemaName : "");
        }
    }
}

