/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractColumn;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Column;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Table;

class MutableColumn
extends AbstractColumn<Table>
implements Column {
    private static final long serialVersionUID = 3834591019449528633L;
    private String defaultValue;
    private boolean isPartOfPrimaryKey;
    private boolean isPartOfUniqueIndex;
    private MutableColumn referencedColumn;
    private final NamedObjectList<MutablePrivilege<Column>> privileges = new NamedObjectList();

    MutableColumn(Table parent, String name) {
        super(parent, name);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public MutablePrivilege<Column> getPrivilege(String name) {
        return this.privileges.lookup(this, name);
    }

    @Override
    public Privilege<Column>[] getPrivileges() {
        return this.privileges.values().toArray(new Privilege[this.privileges.size()]);
    }

    @Override
    public Column getReferencedColumn() {
        return this.referencedColumn;
    }

    @Override
    public boolean isPartOfForeignKey() {
        return this.referencedColumn != null;
    }

    @Override
    public boolean isPartOfPrimaryKey() {
        return this.isPartOfPrimaryKey;
    }

    @Override
    public boolean isPartOfUniqueIndex() {
        return this.isPartOfUniqueIndex;
    }

    void addPrivilege(MutablePrivilege<Column> privilege) {
        this.privileges.add(privilege);
    }

    void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    void setPartOfPrimaryKey(boolean partOfPrimaryKey) {
        this.isPartOfPrimaryKey = partOfPrimaryKey;
    }

    void setPartOfUniqueIndex(boolean partOfUniqueIndex) {
        this.isPartOfUniqueIndex = partOfUniqueIndex;
    }

    void setReferencedColumn(MutableColumn referencedColumn) {
        this.referencedColumn = referencedColumn;
    }
}

