/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.Connection;
import schemacrawler.schema.Database;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationHandler;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.operation.Query;

public final class OperationExecutable
extends BaseExecutable {
    private OperationOptions operationOptions;

    public OperationExecutable(String command) {
        super(command);
    }

    public final OperationOptions getOperationOptions() {
        OperationOptions operationOptions = this.operationOptions == null ? new OperationOptions(this.additionalConfiguration) : this.operationOptions;
        return operationOptions;
    }

    public final void setOperationOptions(OperationOptions operationOptions) {
        this.operationOptions = operationOptions;
    }

    @Override
    protected void executeOn(Database database, Connection connection) throws Exception {
        OperationHandler handler = this.getHandler(connection);
        handler.begin();
        handler.handle(database.getSchemaCrawlerInfo(), database.getDatabaseInfo(), database.getJdbcDriverInfo());
        for (Schema schema : database.getSchemas()) {
            Table[] tables;
            for (Table table : tables = schema.getTables()) {
                handler.handle(table);
            }
        }
        handler.end();
    }

    private OperationHandler getHandler(Connection connection) throws SchemaCrawlerException {
        Query query;
        Operation operation = null;
        try {
            operation = Operation.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            operation = null;
        }
        if (operation == null) {
            String queryName = this.command;
            String queryString = this.additionalConfiguration != null ? (String)this.additionalConfiguration.get((Object)queryName) : null;
            query = new Query(queryName, queryString);
        } else {
            query = operation.getQuery();
        }
        OperationOptions operationOptions = this.getOperationOptions();
        OperationHandler handler = new OperationHandler(operation, query, operationOptions, this.outputOptions, connection);
        return handler;
    }
}

