/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.utility.Alignment;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import sf.util.ObjectToString;

public abstract class BaseTabularFormatter<O extends Options>
extends BaseFormatter<O> {
    protected BaseTabularFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, printVerboseDatabaseInfo, outputOptions);
    }

    @Override
    public void begin() {
        if (!this.outputOptions.isNoHeader()) {
            this.out.println(this.formattingHelper.createDocumentStart());
        }
    }

    @Override
    public void end() throws SchemaCrawlerException {
        if (!this.outputOptions.isNoFooter()) {
            this.out.println(this.formattingHelper.createDocumentEnd());
        }
        this.out.close();
    }

    @Override
    public final void handle(DatabaseInfo dbInfo) {
        if (this.outputOptions.isNoInfo() || dbInfo == null) {
            return;
        }
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Information"));
        this.out.print(this.formattingHelper.createObjectStart(""));
        this.out.println(this.formattingHelper.createNameValueRow("database product name", dbInfo.getProductName(), Alignment.left));
        this.out.println(this.formattingHelper.createNameValueRow("database product version", dbInfo.getProductVersion(), Alignment.left));
        this.out.println(this.formattingHelper.createNameValueRow("database user name", dbInfo.getUserName(), Alignment.left));
        this.out.print(this.formattingHelper.createObjectEnd());
        if (this.printVerboseDatabaseInfo && dbInfo.getProperties().length > 0) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Characteristics"));
            this.out.print(this.formattingHelper.createObjectStart(""));
            for (DatabaseProperty property : dbInfo.getProperties()) {
                String name = property.getDescription();
                Object value = property.getValue();
                if (value == null) {
                    value = "";
                }
                this.out.println(this.formattingHelper.createNameValueRow(name, ObjectToString.toString((Object)value), Alignment.left));
            }
            this.out.print(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    @Override
    public void handle(JdbcDriverInfo driverInfo) {
        if (this.outputOptions.isNoInfo() || driverInfo == null) {
            return;
        }
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "JDBC Driver Information"));
        this.out.print(this.formattingHelper.createObjectStart(""));
        this.out.println(this.formattingHelper.createNameValueRow("driver name", driverInfo.getDriverName(), Alignment.left));
        this.out.println(this.formattingHelper.createNameValueRow("driver version", driverInfo.getDriverVersion(), Alignment.left));
        this.out.println(this.formattingHelper.createNameValueRow("driver class name", driverInfo.getDriverClassName(), Alignment.left));
        this.out.println(this.formattingHelper.createNameValueRow("url", driverInfo.getConnectionUrl(), Alignment.left));
        this.out.println(this.formattingHelper.createNameValueRow("is JDBC compliant", Boolean.toString(driverInfo.isJdbcCompliant()), Alignment.left));
        this.out.print(this.formattingHelper.createObjectEnd());
        JdbcDriverProperty[] jdbcDriverProperties = driverInfo.getDriverProperties();
        if (this.printVerboseDatabaseInfo && jdbcDriverProperties.length > 0) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "JDBC Driver Properties"));
            for (JdbcDriverProperty driverProperty : jdbcDriverProperties) {
                this.out.print(this.formattingHelper.createObjectStart(""));
                this.printJdbcDriverProperty(driverProperty);
                this.out.print(this.formattingHelper.createObjectEnd());
            }
        }
        this.out.flush();
    }

    @Override
    public void handle(SchemaCrawlerInfo schemaCrawlerInfo) {
        TreeMap systemProperties;
        if (this.outputOptions.isNoInfo() || schemaCrawlerInfo == null) {
            return;
        }
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "SchemaCrawler Information"));
        this.out.print(this.formattingHelper.createObjectStart(""));
        this.out.println(this.formattingHelper.createNameValueRow("product name", schemaCrawlerInfo.getSchemaCrawlerProductName(), Alignment.left));
        this.out.println(this.formattingHelper.createNameValueRow("product version", schemaCrawlerInfo.getSchemaCrawlerVersion(), Alignment.left));
        this.out.print(this.formattingHelper.createObjectEnd());
        if (this.printVerboseDatabaseInfo && !(systemProperties = new TreeMap(schemaCrawlerInfo.getSystemProperties())).isEmpty()) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.section, "System Properties"));
            this.out.print(this.formattingHelper.createObjectStart(""));
            for (Map.Entry systemProperty : systemProperties.entrySet()) {
                this.out.println(this.formattingHelper.createNameValueRow((String)systemProperty.getKey(), (String)systemProperty.getValue(), Alignment.left));
            }
            this.out.print(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    @Override
    public final void handleInfoEnd() throws SchemaCrawlerException {
    }

    @Override
    public final void handleInfoStart() throws SchemaCrawlerException {
        if (this.outputOptions.isNoInfo()) {
            return;
        }
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "System Information"));
    }

    private void printJdbcDriverProperty(JdbcDriverProperty driverProperty) {
        String required;
        String choices = Arrays.asList(driverProperty.getChoices()).toString();
        String details = required = (driverProperty.isRequired() ? "" : "not ") + "required";
        if (driverProperty.getChoices() != null && driverProperty.getChoices().length > 0) {
            details = details + "; choices " + choices;
        }
        String value = driverProperty.getValue();
        this.out.println(this.formattingHelper.createNameRow(driverProperty.getName(), "[driver property]", false));
        this.out.println(this.formattingHelper.createDescriptionRow(driverProperty.getDescription()));
        this.out.println(this.formattingHelper.createDescriptionRow(details));
        this.out.println(this.formattingHelper.createDetailRow("", "value", value));
    }
}

