/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.File;
import java.io.Writer;
import schemacrawler.schemacrawler.Options;
import schemacrawler.tools.options.OutputFormat;

public final class OutputOptions
implements Options {
    private static final long serialVersionUID = 7018337388923813055L;
    private String outputFormatValue;
    private File outputFile;
    private Writer writer;
    private boolean appendOutput;
    private boolean noHeader;
    private boolean noFooter;
    private boolean noInfo;

    public OutputOptions() {
        this(OutputFormat.text.name());
    }

    public OutputOptions(String outputFormatValue) {
        this.outputFormatValue = outputFormatValue;
        this.outputFile = null;
        this.writer = null;
    }

    public OutputOptions(String outputFormatValue, File outputFile) {
        this.outputFormatValue = outputFormatValue;
        this.outputFile = outputFile;
        this.writer = null;
    }

    public OutputOptions(String outputFormatValue, Writer writer) {
        this.outputFormatValue = outputFormatValue;
        this.outputFile = null;
        this.writer = writer;
    }

    public OutputOptions duplicate() {
        OutputOptions outputOptions = new OutputOptions();
        outputOptions.outputFormatValue = this.outputFormatValue;
        outputOptions.outputFile = this.outputFile;
        outputOptions.writer = this.writer;
        outputOptions.appendOutput = this.appendOutput;
        outputOptions.noHeader = this.noHeader;
        outputOptions.noFooter = this.noFooter;
        outputOptions.noInfo = this.noInfo;
        return outputOptions;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public OutputFormat getOutputFormat() {
        OutputFormat outputFormat;
        try {
            outputFormat = OutputFormat.valueOf(this.outputFormatValue);
        }
        catch (IllegalArgumentException e) {
            outputFormat = OutputFormat.text;
        }
        return outputFormat;
    }

    public String getOutputFormatValue() {
        return this.outputFormatValue;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isAppendOutput() {
        return this.appendOutput;
    }

    public boolean isConsoleOutput() {
        return this.outputFile == null && this.writer == null;
    }

    public boolean isNoFooter() {
        return this.noFooter;
    }

    public boolean isNoHeader() {
        return this.noHeader;
    }

    public boolean isNoInfo() {
        return this.noInfo;
    }

    public void setAppendOutput(boolean appendOutput) {
        this.appendOutput = appendOutput;
    }

    public void setNoFooter(boolean noFooter) {
        this.noFooter = noFooter;
    }

    public void setNoHeader(boolean noHeader) {
        this.noHeader = noHeader;
    }

    public void setNoInfo(boolean noInfo) {
        this.noInfo = noInfo;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFile = new File(outputFileName);
    }

    public void setOutputFormatValue(String outputFormatValue) {
        if (outputFormatValue == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.outputFormatValue = outputFormatValue;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }
}

