/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.ArrayList;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.Commands;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.options.OutputOptions;

public class SchemaCrawlerExecutable
extends BaseExecutable {
    public SchemaCrawlerExecutable(String commands) {
        super(commands);
    }

    @Override
    protected void executeOn(Database database, Connection connection) throws Exception {
        CommandRegistry commandRegistry = new CommandRegistry();
        Commands commands = new Commands(this.getCommand());
        if (commands.isEmpty()) {
            throw new SchemaCrawlerException("No command specified");
        }
        ArrayList<Executable> executables = new ArrayList<Executable>();
        for (String command : commands) {
            Executable executable = commandRegistry.newExecutable(command);
            executables.add(executable);
        }
        for (Executable executable : executables) {
            executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
            executable.setAdditionalConfiguration(this.additionalConfiguration);
            String command = executable.getCommand();
            OutputOptions executableOutputOptions = this.outputOptions.duplicate();
            if (commands.size() > 1) {
                if (commands.isFirstCommand(command)) {
                    executableOutputOptions.setNoFooter(true);
                } else if (commands.isLastCommand(command)) {
                    executableOutputOptions.setNoHeader(true);
                    executableOutputOptions.setNoInfo(true);
                    executableOutputOptions.setAppendOutput(true);
                } else {
                    executableOutputOptions.setNoHeader(true);
                    executableOutputOptions.setNoInfo(true);
                    executableOutputOptions.setNoFooter(true);
                    executableOutputOptions.setAppendOutput(true);
                }
            }
            executable.setOutputOptions(executableOutputOptions);
            ((BaseExecutable)executable).executeOn(database, connection);
        }
    }
}

