/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.executable.ExecutableCommandProvider;

public final class CommandRegistry {
    private static final Logger LOGGER = Logger.getLogger(CommandRegistry.class.getName());
    private final Map<String, CommandProvider> commandRegistry = CommandRegistry.loadCommandRegistry();

    private static Map<String, CommandProvider> loadCommandRegistry() throws SchemaCrawlerException {
        HashMap<String, CommandProvider> commandRegistry = new HashMap<String, CommandProvider>();
        try {
            ClassLoader classLoader = CommandRegistry.class.getClassLoader();
            URL commandRegistryUrl = classLoader.getResource("tools.command.properties");
            Properties commandRegistryProperties = new Properties();
            commandRegistryProperties.load(commandRegistryUrl.openStream());
            ArrayList<String> commands = Collections.list(commandRegistryProperties.propertyNames());
            for (String command : commands) {
                String executableClassName = commandRegistryProperties.getProperty(command);
                commandRegistry.put(command, new ExecutableCommandProvider(command, executableClassName));
            }
            if (commandRegistry.isEmpty()) {
                throw new SchemaCrawlerException("Could not load base command registry");
            }
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Could not load base command registry", (Throwable)e);
        }
        try {
            ServiceLoader<CommandProvider> serviceLoader = ServiceLoader.load(CommandProvider.class);
            for (CommandProvider commandRegistryEntry : serviceLoader) {
                String executableCommand = commandRegistryEntry.getCommand();
                LOGGER.log(Level.FINER, "Loading executable, " + executableCommand + "=" + commandRegistryEntry.getClass().getName());
                commandRegistry.put(executableCommand, commandRegistryEntry);
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load extended command registry", (Throwable)e);
        }
        return commandRegistry;
    }

    public String getHelpResource(String command) {
        String helpResource = this.commandRegistry.containsKey(command) ? this.commandRegistry.get(command).getHelpResource() : null;
        return helpResource;
    }

    public boolean hasCommand(String command) {
        return this.commandRegistry.containsKey(command);
    }

    public String[] lookupAvailableCommands() {
        Set<String> availableCommandsList = this.commandRegistry.keySet();
        Object[] availableCommands = availableCommandsList.toArray(new String[availableCommandsList.size()]);
        Arrays.sort(availableCommands);
        return availableCommands;
    }

    Executable newExecutable(String command) throws SchemaCrawlerException {
        CommandProvider commandRegistryEntry = this.commandRegistry.containsKey(command) ? this.commandRegistry.get(command) : new ExecutableCommandProvider(command, "schemacrawler.tools.text.operation.OperationExecutable");
        return commandRegistryEntry.newExecutable();
    }
}

