/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.ArrayList;
import java.util.Map;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Database;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.associations.SimpleWeakAssociationsCollector;
import schemacrawler.tools.analysis.associations.WeakAssociationsAnalyzer;
import schemacrawler.tools.analysis.associations.WeakAssociationsCollector;

public final class DatabaseWithAssociations
implements Database {
    private static final long serialVersionUID = -3953296149824921463L;
    private final Database database;
    private final WeakAssociationsCollector collector;

    public DatabaseWithAssociations(Database database) {
        if (database == null) {
            throw new IllegalArgumentException("No database provided");
        }
        this.database = database;
        ArrayList<Table> allTables = new ArrayList<Table>();
        for (Schema schema : database.getSchemas()) {
            for (Table table : schema.getTables()) {
                allTables.add(table);
            }
        }
        this.collector = new SimpleWeakAssociationsCollector();
        WeakAssociationsAnalyzer weakAssociationsAnalyzer = new WeakAssociationsAnalyzer(allTables, this.collector);
        weakAssociationsAnalyzer.analyzeTables();
    }

    public int compareTo(NamedObject o) {
        return this.database.compareTo((Object)o);
    }

    public Object getAttribute(String name) {
        return this.database.getAttribute(name);
    }

    public <T> T getAttribute(String name, T defaultValue) {
        return (T)this.database.getAttribute(name, defaultValue);
    }

    public Map<String, Object> getAttributes() {
        return this.database.getAttributes();
    }

    public WeakAssociationsCollector getCollector() {
        return this.collector;
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.database.getDatabaseInfo();
    }

    public String getFullName() {
        return this.database.getFullName();
    }

    public JdbcDriverInfo getJdbcDriverInfo() {
        return this.database.getJdbcDriverInfo();
    }

    public String getName() {
        return this.database.getName();
    }

    public String getRemarks() {
        return this.database.getRemarks();
    }

    public Schema getSchema(String name) {
        return this.database.getSchema(name);
    }

    public SchemaCrawlerInfo getSchemaCrawlerInfo() {
        return this.database.getSchemaCrawlerInfo();
    }

    public Schema[] getSchemas() {
        return this.database.getSchemas();
    }

    public ColumnDataType getSystemColumnDataType(String name) {
        return this.database.getSystemColumnDataType(name);
    }

    public ColumnDataType[] getSystemColumnDataTypes() {
        return this.database.getSystemColumnDataTypes();
    }

    public void setAttribute(String name, Object value) {
        this.database.setAttribute(name, value);
    }
}

